/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.charset;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.charset.CharsetDecoders;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharsetDecodersTest {
    @Test
    public void testToCharsetDecoders_default() {
        CharsetDecoder charsetEncoder = CharsetDecoders.toCharsetDecoder((CharsetDecoder)Charset.defaultCharset().newDecoder());
        Assertions.assertNotNull((Object)charsetEncoder);
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)charsetEncoder.charset());
    }

    @Test
    public void testToCharsetDecoders_ISO_8859_1() {
        CharsetDecoder charsetEncoder = CharsetDecoders.toCharsetDecoder((CharsetDecoder)StandardCharsets.ISO_8859_1.newDecoder());
        Assertions.assertNotNull((Object)charsetEncoder);
        Assertions.assertEquals((Object)StandardCharsets.ISO_8859_1, (Object)charsetEncoder.charset());
    }

    @Test
    public void testToCharsetDecoders_null() {
        CharsetDecoder charsetEncoder = CharsetDecoders.toCharsetDecoder(null);
        Assertions.assertNotNull((Object)charsetEncoder);
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)charsetEncoder.charset());
    }
}

