/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v134.css.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v134.css.model.SourceRange;
import org.openqa.selenium.devtools.v134.css.model.StyleSheetId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CSSSupports {
    private final String text;
    private final Boolean active;
    private final Optional<SourceRange> range;
    private final Optional<StyleSheetId> styleSheetId;

    public CSSSupports(String text, Boolean active, Optional<SourceRange> range, Optional<StyleSheetId> styleSheetId) {
        this.text = Objects.requireNonNull(text, "text is required");
        this.active = Objects.requireNonNull(active, "active is required");
        this.range = range;
        this.styleSheetId = styleSheetId;
    }

    public String getText() {
        return this.text;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Optional<SourceRange> getRange() {
        return this.range;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    private static CSSSupports fromJson(JsonInput input) {
        String text = null;
        Boolean active = false;
        Optional<SourceRange> range = Optional.empty();
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "text": {
                    text = input.nextString();
                    continue block12;
                }
                case "active": {
                    active = input.nextBoolean();
                    continue block12;
                }
                case "range": {
                    range = Optional.ofNullable((SourceRange)input.read(SourceRange.class));
                    continue block12;
                }
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read(StyleSheetId.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSSupports(text, active, range, styleSheetId);
    }
}

