/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v134.css.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v134.css.model.SourceRange;
import org.openqa.selenium.json.JsonInput;

public class CSSProperty {
    private final String name;
    private final String value;
    private final Optional<Boolean> important;
    private final Optional<Boolean> implicit;
    private final Optional<String> text;
    private final Optional<Boolean> parsedOk;
    private final Optional<Boolean> disabled;
    private final Optional<SourceRange> range;
    private final Optional<List<CSSProperty>> longhandProperties;

    public CSSProperty(String name, String value, Optional<Boolean> important, Optional<Boolean> implicit, Optional<String> text, Optional<Boolean> parsedOk, Optional<Boolean> disabled, Optional<SourceRange> range, Optional<List<CSSProperty>> longhandProperties) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = Objects.requireNonNull(value, "value is required");
        this.important = important;
        this.implicit = implicit;
        this.text = text;
        this.parsedOk = parsedOk;
        this.disabled = disabled;
        this.range = range;
        this.longhandProperties = longhandProperties;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Optional<Boolean> getImportant() {
        return this.important;
    }

    public Optional<Boolean> getImplicit() {
        return this.implicit;
    }

    public Optional<String> getText() {
        return this.text;
    }

    public Optional<Boolean> getParsedOk() {
        return this.parsedOk;
    }

    public Optional<Boolean> getDisabled() {
        return this.disabled;
    }

    public Optional<SourceRange> getRange() {
        return this.range;
    }

    @Beta
    public Optional<List<CSSProperty>> getLonghandProperties() {
        return this.longhandProperties;
    }

    private static CSSProperty fromJson(JsonInput input) {
        String name = null;
        String value = null;
        Optional<Boolean> important = Optional.empty();
        Optional<Boolean> implicit = Optional.empty();
        Optional<String> text = Optional.empty();
        Optional<Boolean> parsedOk = Optional.empty();
        Optional<Boolean> disabled = Optional.empty();
        Optional<SourceRange> range = Optional.empty();
        Optional<List<CSSProperty>> longhandProperties = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block22;
                }
                case "value": {
                    value = input.nextString();
                    continue block22;
                }
                case "important": {
                    important = Optional.ofNullable(input.nextBoolean());
                    continue block22;
                }
                case "implicit": {
                    implicit = Optional.ofNullable(input.nextBoolean());
                    continue block22;
                }
                case "text": {
                    text = Optional.ofNullable(input.nextString());
                    continue block22;
                }
                case "parsedOk": {
                    parsedOk = Optional.ofNullable(input.nextBoolean());
                    continue block22;
                }
                case "disabled": {
                    disabled = Optional.ofNullable(input.nextBoolean());
                    continue block22;
                }
                case "range": {
                    range = Optional.ofNullable((SourceRange)input.read(SourceRange.class));
                    continue block22;
                }
                case "longhandProperties": {
                    longhandProperties = Optional.ofNullable(input.readArray(CSSProperty.class));
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSProperty(name, value, important, implicit, text, parsedOk, disabled, range, longhandProperties);
    }
}

