/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.nio.ByteBuffer;
import org.apache.commons.io.input.ByteBufferCleaner;
import org.apache.commons.lang3.RandomUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ByteBufferCleanerTest {
    @Test
    void testCleanEmpty() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(10);
        ByteBufferCleaner.clean(buffer);
    }

    @Test
    void testCleanFull() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(10);
        buffer.put(RandomUtils.nextBytes((int)10), 0, 10);
        ByteBufferCleaner.clean(buffer);
    }

    @Test
    void testSupported() {
        Assertions.assertTrue((boolean)ByteBufferCleaner.isSupported(), (String)"ByteBufferCleaner does not work on this platform, please investigate and fix");
    }
}

