/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.TestConstants;
import org.apache.commons.io.function.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IOSupplierTest {
    private AtomicReference<String> ref1;

    private String getThrowsIO(IOSupplier<String> supplier) throws IOException {
        return supplier.get();
    }

    private String getThrowsNoneAsSupplier(IOSupplier<String> supplier) {
        return supplier.asSupplier().get();
    }

    private String getThrowsNoneGetUnchecked(IOSupplier<String> supplier) {
        return supplier.getUnchecked();
    }

    @BeforeEach
    public void initEach() {
        this.ref1 = new AtomicReference();
    }

    @Test
    public void testAsSupplier() {
        Assertions.assertThrows(UncheckedIOException.class, () -> TestConstants.THROWING_IO_SUPPLIER.asSupplier().get());
        String s1 = "string1";
        String s2 = "string2";
        Assertions.assertEquals((Object)"string1", (Object)this.getThrowsNoneAsSupplier(() -> TestUtils.compareAndSetThrowsIO(this.ref1, null, "string1")));
        Assertions.assertEquals((Object)"string1", (Object)this.ref1.get());
        Assertions.assertEquals((Object)"string2", (Object)this.getThrowsNoneAsSupplier(() -> TestUtils.compareAndSetThrowsIO(this.ref1, "string1", "string2")));
        Assertions.assertEquals((Object)"string2", (Object)this.ref1.get());
        Assertions.assertNotEquals(TestConstants.THROWING_IO_SUPPLIER.asSupplier(), TestConstants.THROWING_IO_SUPPLIER.asSupplier());
    }

    @Test
    public void testGet() throws IOException {
        Assertions.assertThrows(IOException.class, () -> TestConstants.THROWING_IO_SUPPLIER.get());
        Assertions.assertThrows(IOException.class, () -> {
            throw new IOException();
        });
        Assertions.assertEquals((Object)"new1", (Object)this.getThrowsIO(() -> TestUtils.compareAndSetThrowsIO(this.ref1, "new1")));
        Assertions.assertEquals((Object)"new1", (Object)this.ref1.get());
    }

    @Test
    public void testGetUnchecked() {
        Assertions.assertThrows(UncheckedIOException.class, () -> TestConstants.THROWING_IO_SUPPLIER.asSupplier().get());
        String s1 = "string1";
        String s2 = "string2";
        Assertions.assertEquals((Object)"string1", (Object)this.getThrowsNoneGetUnchecked(() -> TestUtils.compareAndSetThrowsIO(this.ref1, null, "string1")));
        Assertions.assertEquals((Object)"string1", (Object)this.ref1.get());
        Assertions.assertEquals((Object)"string2", (Object)this.getThrowsNoneGetUnchecked(() -> TestUtils.compareAndSetThrowsIO(this.ref1, "string1", "string2")));
        Assertions.assertEquals((Object)"string2", (Object)this.ref1.get());
        Assertions.assertNotEquals(TestConstants.THROWING_IO_SUPPLIER.asSupplier(), TestConstants.THROWING_IO_SUPPLIER.asSupplier());
    }
}

