/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.apache.commons.io.function.IOBaseStream;
import org.apache.commons.io.function.IOStream;
import org.apache.commons.io.function.IOStreamAdapter;
import org.apache.commons.io.function.TestConstants;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IOBaseStreamTest {
    private BaseStream<Path, ? extends BaseStream<Path, ?>> baseStream;
    private IOBaseStreamFixture<Path, ? extends IOBaseStreamFixture<Path, ?, ?>, ?> ioBaseStream;
    private IOBaseStreamPathFixture<? extends BaseStream<Path, ?>> ioBaseStreamPath;
    private IOStream<Path> ioBaseStreamAdapter;

    @BeforeEach
    public void beforeEach() {
        this.baseStream = this.createStreamOfPaths();
        this.ioBaseStream = this.createIOBaseStream();
        this.ioBaseStreamPath = this.createIOBaseStreamPath();
        this.ioBaseStreamAdapter = this.createIOBaseStreamAdapter();
    }

    private IOBaseStreamFixture<Path, ?, Stream<Path>> createIOBaseStream() {
        return new IOBaseStreamFixture(this.createStreamOfPaths(), null);
    }

    private IOStream<Path> createIOBaseStreamAdapter() {
        return IOStreamAdapter.adapt(this.createStreamOfPaths());
    }

    private IOBaseStreamPathFixture<Stream<Path>> createIOBaseStreamPath() {
        return new IOBaseStreamPathFixture<Stream<Path>>(this.createStreamOfPaths(), null);
    }

    private Stream<Path> createStreamOfPaths() {
        return Stream.of(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B);
    }

    @Test
    @AfterEach
    public void testClose() {
        this.baseStream.close();
        this.ioBaseStream.close();
        this.ioBaseStreamPath.close();
        this.ioBaseStream.asBaseStream().close();
        this.ioBaseStreamPath.asBaseStream().close();
    }

    @Test
    public void testIsParallel() {
        Assertions.assertFalse((boolean)this.baseStream.isParallel());
        Assertions.assertFalse((boolean)this.ioBaseStream.isParallel());
        Assertions.assertFalse((boolean)this.ioBaseStream.asBaseStream().isParallel());
        Assertions.assertFalse((boolean)this.ioBaseStreamPath.asBaseStream().isParallel());
        Assertions.assertFalse((boolean)this.ioBaseStreamPath.isParallel());
    }

    @Test
    public void testIteratorPathIO() throws IOException {
        AtomicReference ref = new AtomicReference();
        this.ioBaseStream.iterator().forEachRemaining(e -> ref.set(e.toRealPath(new LinkOption[0])));
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_B.toRealPath(new LinkOption[0]), ref.get());
        this.ioBaseStreamPath.asBaseStream().iterator().forEachRemaining(e -> ref.set(e.getFileName()));
        Assertions.assertEquals((Object)TestConstants.ABS_PATH_B.getFileName(), ref.get());
    }

    @Test
    public void testIteratorSimple() throws IOException {
        AtomicInteger ref = new AtomicInteger();
        this.baseStream.iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)2, (int)ref.get());
        this.ioBaseStream.iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)4, (int)ref.get());
        this.ioBaseStreamPath.asBaseStream().iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)6, (int)ref.get());
    }

    @Test
    public void testOnClose() {
        this.testOnClose(this.baseStream);
        this.testOnClose(this.ioBaseStream.asBaseStream());
        this.testOnClose(this.ioBaseStreamPath.asBaseStream());
    }

    private <T, S extends BaseStream<T, S>> void testOnClose(BaseStream<T, S> stream) {
        AtomicReference refA = new AtomicReference();
        AtomicReference refB = new AtomicReference();
        stream.onClose(() -> refA.set("A"));
        stream.onClose(() -> {
            throw new MyRuntimeException("B");
        });
        stream.onClose(() -> {
            throw new MyRuntimeException("C");
        });
        stream.onClose(() -> refB.set("D"));
        MyRuntimeException e = (MyRuntimeException)Assertions.assertThrows(MyRuntimeException.class, stream::close);
        Assertions.assertEquals((Object)"A", refA.get());
        Assertions.assertEquals((Object)"D", refB.get());
        Assertions.assertEquals((Object)"B", (Object)e.getMessage());
        Throwable[] suppressed = e.getSuppressed();
        Assertions.assertNotNull((Object)suppressed);
        Assertions.assertEquals((int)1, (int)suppressed.length);
        Assertions.assertEquals((Object)"C", (Object)suppressed[0].getMessage());
    }

    @Test
    public void testParallel() throws IOException {
        AtomicInteger ref = new AtomicInteger();
        this.baseStream.parallel().iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)2, (int)ref.get());
        ((IOBaseStreamFixture)this.ioBaseStream.parallel()).iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)4, (int)ref.get());
        Object parallel = this.ioBaseStreamPath.asBaseStream().parallel();
        parallel.iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)6, (int)ref.get());
        Assertions.assertTrue((boolean)parallel.isParallel());
    }

    @Test
    public void testParallelParallel() {
        try (IOBaseStreamFixture<Path, ?, Stream<Path>> stream = this.createIOBaseStream();){
            this.testParallelParallel(stream);
        }
        stream = this.createIOBaseStreamPath();
        try {
            this.testParallelParallel(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        stream = this.createIOBaseStream();
        try {
            this.testParallelParallel(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        stream = this.createIOBaseStream();
        try {
            this.testParallelParallel(stream.asBaseStream());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private void testParallelParallel(BaseStream<?, ?> stream) {
        Object seq = stream.sequential();
        Assertions.assertFalse((boolean)seq.isParallel());
        Object p1 = seq.parallel();
        Assertions.assertTrue((boolean)p1.isParallel());
        Object p2 = p1.parallel();
        Assertions.assertTrue((boolean)p1.isParallel());
        Assertions.assertSame(p1, p2);
    }

    private void testParallelParallel(IOBaseStream<?, ?, ?> stream) {
        Object seq = stream.sequential();
        Assertions.assertFalse((boolean)seq.isParallel());
        Object p1 = seq.parallel();
        Assertions.assertTrue((boolean)p1.isParallel());
        Object p2 = p1.parallel();
        Assertions.assertTrue((boolean)p1.isParallel());
        Assertions.assertSame(p1, p2);
    }

    @Test
    public void testSequential() throws IOException {
        AtomicInteger ref = new AtomicInteger();
        this.baseStream.sequential().iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)2, (int)ref.get());
        ((IOBaseStreamFixture)this.ioBaseStream.sequential()).iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)4, (int)ref.get());
        this.ioBaseStreamPath.asBaseStream().sequential().iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)6, (int)ref.get());
    }

    @Test
    public void testSequentialSequential() {
        try (IOBaseStreamFixture<Path, ?, Stream<Path>> stream = this.createIOBaseStream();){
            this.testSequentialSequential(stream);
        }
        stream = this.createIOBaseStreamPath();
        try {
            this.testSequentialSequential(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        stream = this.createIOBaseStream();
        try {
            this.testSequentialSequential(stream.asBaseStream());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private void testSequentialSequential(BaseStream<?, ?> stream) {
        Object p = stream.parallel();
        Assertions.assertTrue((boolean)p.isParallel());
        Object seq1 = p.sequential();
        Assertions.assertFalse((boolean)seq1.isParallel());
        Object seq2 = seq1.sequential();
        Assertions.assertFalse((boolean)seq1.isParallel());
        Assertions.assertSame(seq1, seq2);
    }

    private void testSequentialSequential(IOBaseStream<?, ?, ?> stream) {
        Object p = stream.parallel();
        Assertions.assertTrue((boolean)p.isParallel());
        Object seq1 = p.sequential();
        Assertions.assertFalse((boolean)seq1.isParallel());
        Object seq2 = seq1.sequential();
        Assertions.assertFalse((boolean)seq1.isParallel());
        Assertions.assertSame(seq1, seq2);
    }

    @Test
    public void testSpliterator() {
        AtomicInteger ref = new AtomicInteger();
        this.baseStream.spliterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)2, (int)ref.get());
        this.ioBaseStream.spliterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)4, (int)ref.get());
        this.ioBaseStreamPath.asBaseStream().spliterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)6, (int)ref.get());
    }

    @Test
    public void testUnordered() throws IOException {
        AtomicInteger ref = new AtomicInteger();
        this.baseStream.unordered().iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)2, (int)ref.get());
        ((IOBaseStreamFixture)this.ioBaseStream.unordered()).iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)4, (int)ref.get());
        this.ioBaseStreamPath.asBaseStream().unordered().iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)6, (int)ref.get());
    }

    @Test
    public void testUnwrap() {
        AtomicInteger ref = new AtomicInteger();
        this.baseStream.iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)2, (int)ref.get());
        this.ioBaseStream.unwrap().iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)4, (int)ref.get());
        this.ioBaseStreamPath.asBaseStream().iterator().forEachRemaining(e -> ref.incrementAndGet());
        Assertions.assertEquals((int)6, (int)ref.get());
    }

    @Test
    public void testWrap() {
        Stream<Path> stream = this.createStreamOfPaths();
        IOStream wrap = (IOStream)this.ioBaseStreamAdapter.wrap(stream);
        Assertions.assertNotNull((Object)wrap);
        Assertions.assertEquals(stream, wrap.unwrap());
    }

    private static class IOBaseStreamFixture<T, S extends IOBaseStreamFixture<T, S, B>, B extends BaseStream<T, B>>
    implements IOBaseStream<T, S, B> {
        private final B baseStream;

        private IOBaseStreamFixture(B baseStream) {
            this.baseStream = baseStream;
        }

        @Override
        public B unwrap() {
            return this.baseStream;
        }

        @Override
        public S wrap(B delegate) {
            return (S)(delegate == this.baseStream ? this : new IOBaseStreamFixture<T, S, B>(delegate));
        }

        /* synthetic */ IOBaseStreamFixture(BaseStream x0, 1 x1) {
            this(x0);
        }
    }

    private static final class IOBaseStreamPathFixture<B extends BaseStream<Path, B>>
    extends IOBaseStreamFixture<Path, IOBaseStreamPathFixture<B>, B> {
        private IOBaseStreamPathFixture(B baseStream) {
            super((BaseStream)baseStream, null);
        }

        @Override
        public IOBaseStreamPathFixture<B> wrap(B delegate) {
            return delegate == this.unwrap() ? this : new IOBaseStreamPathFixture<B>(delegate);
        }

        /* synthetic */ IOBaseStreamPathFixture(BaseStream x0, 1 x1) {
            this(x0);
        }
    }

    private static final class MyRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public MyRuntimeException(String message) {
            super(message);
        }
    }
}

