/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import org.apache.commons.io.build.AbstractSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractSupplierTest {
    @Test
    public void test() {
        Foo foo = Foo.builder().setBar1("value1").setBar2("value2").setBar3("value3").get();
        Assertions.assertEquals((Object)"value1", (Object)foo.getBar1());
        Assertions.assertEquals((Object)"value2", (Object)foo.getBar2());
        Assertions.assertEquals((Object)"value3", (Object)foo.getBar3());
    }

    public static class Foo {
        private final String bar1;
        private final String bar2;
        private final String bar3;

        public static Builder builder() {
            return new Builder();
        }

        private Foo(String bar1, String bar2, String bar3) {
            this.bar1 = bar1;
            this.bar2 = bar2;
            this.bar3 = bar3;
        }

        public String getBar1() {
            return this.bar1;
        }

        public String getBar2() {
            return this.bar2;
        }

        public String getBar3() {
            return this.bar3;
        }
    }

    public static class Builder
    extends AbstractSupplier<Foo, Builder> {
        private String bar1;
        private String bar2;
        private String bar3;

        @Override
        public Foo get() {
            return new Foo(this.bar1, this.bar2, this.bar3);
        }

        public Builder setBar1(String bar1) {
            this.bar1 = bar1;
            return this;
        }

        public Builder setBar2(String bar2) {
            this.bar2 = bar2;
            return this;
        }

        public Builder setBar3(String bar3) {
            this.bar3 = bar3;
            return this;
        }
    }
}

