/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.commons.io.input.XmlStreamReaderException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmlStreamReaderUtilitiesTest {
    private static final String RAWMGS1 = "encoding mismatch";
    private static final String RAWMGS2 = "unknown BOM";
    private static final String HTTPMGS1 = "BOM must be null";
    private static final String HTTPMGS2 = "encoding mismatch";
    private static final String HTTPMGS3 = "Illegal MIME";
    private static final String APPXML = "application/xml";
    private static final String APPXML_UTF8 = "application/xml;charset=UTF-8";
    private static final String APPXML_UTF16 = "application/xml;charset=UTF-16";
    private static final String APPXML_UTF32 = "application/xml;charset=UTF-32";
    private static final String APPXML_UTF16BE = "application/xml;charset=UTF-16BE";
    private static final String APPXML_UTF16LE = "application/xml;charset=UTF-16LE";
    private static final String APPXML_UTF32BE = "application/xml;charset=UTF-32BE";
    private static final String APPXML_UTF32LE = "application/xml;charset=UTF-32LE";
    private static final String TXTXML = "text/xml";

    protected String calculateHttpEncoding(String httpContentType, String bomEnc, String xmlGuessEnc, String xmlEnc, boolean lenient, String defaultEncoding) throws IOException {
        try (MockXmlStreamReader mock = new MockXmlStreamReader(defaultEncoding);){
            String string = mock.calculateHttpEncoding(bomEnc, xmlGuessEnc, xmlEnc, lenient, httpContentType);
            return string;
        }
    }

    protected String calculateRawEncoding(String bomEnc, String xmlGuessEnc, String xmlEnc, String defaultEncoding) throws IOException {
        try (MockXmlStreamReader mock = new MockXmlStreamReader(defaultEncoding);){
            String string = mock.calculateRawEncoding(bomEnc, xmlGuessEnc, xmlEnc);
            return string;
        }
    }

    private void checkAppXml(boolean expected, String mime) {
        Assertions.assertEquals((Object)expected, (Object)XmlStreamReader.isAppXml((String)mime), (String)("Mime=[" + mime + "]"));
    }

    private void checkContentTypeEncoding(String expected, String httpContentType) {
        Assertions.assertEquals((Object)expected, (Object)XmlStreamReader.getContentTypeEncoding((String)httpContentType), (String)("ContentTypeEncoding=[" + httpContentType + "]"));
    }

    private void checkContentTypeMime(String expected, String httpContentType) {
        Assertions.assertEquals((Object)expected, (Object)XmlStreamReader.getContentTypeMime((String)httpContentType), (String)("ContentTypeMime=[" + httpContentType + "]"));
    }

    private void checkHttpEncoding(String expected, boolean lenient, String httpContentType, String bomEnc, String xmlGuessEnc, String xmlEnc, String defaultEncoding) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("HttpEncoding=[").append(bomEnc).append("], ");
        builder.append("lenient=[").append(lenient).append("], ");
        builder.append("httpContentType=[").append(httpContentType).append("], ");
        builder.append("bomEnc=[").append(bomEnc).append("], ");
        builder.append("xmlGuessEnc=[").append(xmlGuessEnc).append("], ");
        builder.append("xmlEnc=[").append(xmlEnc).append("], ");
        builder.append("defaultEncoding=[").append(defaultEncoding).append("],");
        String encoding = this.calculateHttpEncoding(httpContentType, bomEnc, xmlGuessEnc, xmlEnc, lenient, defaultEncoding);
        Assertions.assertEquals((Object)expected, (Object)encoding, (String)builder.toString());
    }

    private void checkHttpError(String msgSuffix, boolean lenient, String httpContentType, String bomEnc, String xmlGuessEnc, String xmlEnc, String defaultEncoding) {
        try {
            this.checkHttpEncoding("XmlStreamReaderException", lenient, httpContentType, bomEnc, xmlGuessEnc, xmlEnc, defaultEncoding);
            Assertions.fail((String)"Expected XmlStreamReaderException");
        }
        catch (XmlStreamReaderException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Illegal encoding"), (String)("Msg Start: " + e.getMessage()));
            Assertions.assertTrue((boolean)e.getMessage().endsWith(msgSuffix), (String)("Msg End: " + e.getMessage()));
            Assertions.assertEquals((Object)bomEnc, (Object)e.getBomEncoding(), (String)"bomEnc");
            Assertions.assertEquals((Object)xmlGuessEnc, (Object)e.getXmlGuessEncoding(), (String)"xmlGuessEnc");
            Assertions.assertEquals((Object)xmlEnc, (Object)e.getXmlEncoding(), (String)"xmlEnc");
            Assertions.assertEquals((Object)XmlStreamReader.getContentTypeEncoding((String)httpContentType), (Object)e.getContentTypeEncoding(), (String)"ContentTypeEncoding");
            Assertions.assertEquals((Object)XmlStreamReader.getContentTypeMime((String)httpContentType), (Object)e.getContentTypeMime(), (String)"ContentTypeMime");
        }
        catch (Exception e) {
            Assertions.fail((String)("Expected XmlStreamReaderException, but threw " + e));
        }
    }

    private void checkRawEncoding(String expected, String bomEnc, String xmlGuessEnc, String xmlEnc, String defaultEncoding) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("RawEncoding: ").append(bomEnc).append("], ");
        builder.append("bomEnc=[").append(bomEnc).append("], ");
        builder.append("xmlGuessEnc=[").append(xmlGuessEnc).append("], ");
        builder.append("xmlEnc=[").append(xmlEnc).append("], ");
        builder.append("defaultEncoding=[").append(defaultEncoding).append("],");
        String encoding = this.calculateRawEncoding(bomEnc, xmlGuessEnc, xmlEnc, defaultEncoding);
        Assertions.assertEquals((Object)expected, (Object)encoding, (String)builder.toString());
    }

    private void checkRawError(String msgSuffix, String bomEnc, String xmlGuessEnc, String xmlEnc, String defaultEncoding) {
        try {
            this.checkRawEncoding("XmlStreamReaderException", bomEnc, xmlGuessEnc, xmlEnc, defaultEncoding);
            Assertions.fail((String)"Expected XmlStreamReaderException");
        }
        catch (XmlStreamReaderException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Illegal encoding"), (String)("Msg Start: " + e.getMessage()));
            Assertions.assertTrue((boolean)e.getMessage().endsWith(msgSuffix), (String)("Msg End: " + e.getMessage()));
            Assertions.assertEquals((Object)bomEnc, (Object)e.getBomEncoding(), (String)"bomEnc");
            Assertions.assertEquals((Object)xmlGuessEnc, (Object)e.getXmlGuessEncoding(), (String)"xmlGuessEnc");
            Assertions.assertEquals((Object)xmlEnc, (Object)e.getXmlEncoding(), (String)"xmlEnc");
            Assertions.assertNull((Object)e.getContentTypeEncoding(), (String)"ContentTypeEncoding");
            Assertions.assertNull((Object)e.getContentTypeMime(), (String)"ContentTypeMime");
        }
        catch (Exception e) {
            Assertions.fail((String)("Expected XmlStreamReaderException, but threw " + e));
        }
    }

    private void checkTextXml(boolean expected, String mime) {
        Assertions.assertEquals((Object)expected, (Object)XmlStreamReader.isTextXml((String)mime), (String)("Mime=[" + mime + "]"));
    }

    @Test
    public void testAppXml() {
        this.checkAppXml(false, null);
        this.checkAppXml(false, "");
        this.checkAppXml(true, APPXML);
        this.checkAppXml(true, "application/xml-dtd");
        this.checkAppXml(true, "application/xml-external-parsed-entity");
        this.checkAppXml(true, "application/soap+xml");
        this.checkAppXml(true, "application/atom+xml");
        this.checkAppXml(false, "application/atomxml");
        this.checkAppXml(false, TXTXML);
        this.checkAppXml(false, "text/atom+xml");
        this.checkAppXml(true, "application/xml-dtd");
        this.checkAppXml(true, "application/xml-external-parsed-entity");
    }

    @Test
    public void testCalculateHttpEncoding() throws IOException {
        this.checkHttpError(HTTPMGS3, true, null, null, null, null, null);
        this.checkHttpError(HTTPMGS3, false, null, null, null, "UTF-8", null);
        this.checkHttpEncoding("UTF-8", true, null, null, null, "UTF-8", null);
        this.checkHttpEncoding("UTF-16LE", true, null, null, null, "UTF-16LE", null);
        this.checkHttpError(HTTPMGS3, false, "text/css", null, null, null, null);
        this.checkHttpEncoding("US-ASCII", false, TXTXML, null, null, null, null);
        this.checkHttpEncoding("UTF-16BE", false, TXTXML, null, null, null, "UTF-16BE");
        this.checkHttpEncoding("UTF-8", false, APPXML, null, null, null, null);
        this.checkHttpEncoding("UTF-16BE", false, APPXML, null, null, null, "UTF-16BE");
        this.checkHttpEncoding("UTF-8", false, APPXML, "UTF-8", null, null, "UTF-16BE");
        this.checkHttpEncoding("UTF-16LE", false, APPXML_UTF16LE, null, null, null, null);
        this.checkHttpEncoding("UTF-16BE", false, APPXML_UTF16BE, null, null, null, null);
        this.checkHttpError(HTTPMGS1, false, APPXML_UTF16LE, "UTF-16LE", null, null, null);
        this.checkHttpError(HTTPMGS1, false, APPXML_UTF16BE, "UTF-16BE", null, null, null);
        this.checkHttpError("encoding mismatch", false, APPXML_UTF16, null, null, null, null);
        this.checkHttpError("encoding mismatch", false, APPXML_UTF16, "UTF-8", null, null, null);
        this.checkHttpEncoding("UTF-16LE", false, APPXML_UTF16, "UTF-16LE", null, null, null);
        this.checkHttpEncoding("UTF-16BE", false, APPXML_UTF16, "UTF-16BE", null, null, null);
        this.checkHttpEncoding("UTF-8", false, APPXML_UTF8, null, null, null, null);
        this.checkHttpEncoding("UTF-8", false, APPXML_UTF8, "UTF-16BE", "UTF-16BE", "UTF-16BE", "UTF-16BE");
    }

    @Test
    public void testCalculateHttpEncodingUtf32() throws IOException {
        this.checkHttpEncoding("UTF-32LE", true, null, null, null, "UTF-32LE", null);
        this.checkHttpEncoding("UTF-32BE", false, TXTXML, null, null, null, "UTF-32BE");
        this.checkHttpEncoding("UTF-32BE", false, APPXML, null, null, null, "UTF-32BE");
        this.checkHttpEncoding("UTF-32LE", false, APPXML_UTF32LE, null, null, null, null);
        this.checkHttpEncoding("UTF-32BE", false, APPXML_UTF32BE, null, null, null, null);
        this.checkHttpError(HTTPMGS1, false, APPXML_UTF32LE, "UTF-32LE", null, null, null);
        this.checkHttpError(HTTPMGS1, false, APPXML_UTF32BE, "UTF-32BE", null, null, null);
        this.checkHttpError("encoding mismatch", false, APPXML_UTF32, null, null, null, null);
        this.checkHttpError("encoding mismatch", false, APPXML_UTF32, "UTF-8", null, null, null);
        this.checkHttpEncoding("UTF-32LE", false, APPXML_UTF32, "UTF-32LE", null, null, null);
        this.checkHttpEncoding("UTF-32BE", false, APPXML_UTF32, "UTF-32BE", null, null, null);
        this.checkHttpEncoding("UTF-8", false, APPXML_UTF8, "UTF-32BE", "UTF-32BE", "UTF-32BE", "UTF-32BE");
    }

    @Test
    public void testCalculateRawEncodingAdditionalUTF16() throws IOException {
        this.checkRawError("encoding mismatch", "UTF-16BE", "UTF-16", null, null);
        this.checkRawEncoding("UTF-16BE", "UTF-16BE", null, "UTF-16", null);
        this.checkRawEncoding("UTF-16BE", "UTF-16BE", "UTF-16BE", "UTF-16", null);
        this.checkRawError("encoding mismatch", "UTF-16BE", null, "UTF-16LE", null);
        this.checkRawError("encoding mismatch", "UTF-16BE", "UTF-16BE", "UTF-16LE", null);
        this.checkRawError("encoding mismatch", "UTF-16LE", "UTF-16", null, null);
        this.checkRawEncoding("UTF-16LE", "UTF-16LE", null, "UTF-16", null);
        this.checkRawEncoding("UTF-16LE", "UTF-16LE", "UTF-16LE", "UTF-16", null);
        this.checkRawError("encoding mismatch", "UTF-16LE", null, "UTF-16BE", null);
        this.checkRawError("encoding mismatch", "UTF-16LE", "UTF-16LE", "UTF-16BE", null);
    }

    @Test
    public void testCalculateRawEncodingAdditionalUTF32() throws IOException {
        this.checkRawError("encoding mismatch", "UTF-32BE", "UTF-32", null, null);
        this.checkRawEncoding("UTF-32BE", "UTF-32BE", null, "UTF-32", null);
        this.checkRawEncoding("UTF-32BE", "UTF-32BE", "UTF-32BE", "UTF-32", null);
        this.checkRawError("encoding mismatch", "UTF-32BE", null, "UTF-32LE", null);
        this.checkRawError("encoding mismatch", "UTF-32BE", "UTF-32BE", "UTF-32LE", null);
        this.checkRawError("encoding mismatch", "UTF-32LE", "UTF-32", null, null);
        this.checkRawEncoding("UTF-32LE", "UTF-32LE", null, "UTF-32", null);
        this.checkRawEncoding("UTF-32LE", "UTF-32LE", "UTF-32LE", "UTF-32", null);
        this.checkRawError("encoding mismatch", "UTF-32LE", null, "UTF-32BE", null);
        this.checkRawError("encoding mismatch", "UTF-32LE", "UTF-32LE", "UTF-32BE", null);
    }

    @Test
    public void testCalculateRawEncodingNoBOM() throws IOException {
        this.checkRawError(RAWMGS2, "UTF-32", null, null, null);
        this.checkRawEncoding("UTF-8", null, null, null, null);
        this.checkRawEncoding("UTF-8", null, "UTF-16BE", null, null);
        this.checkRawEncoding("UTF-8", null, null, "UTF-16BE", null);
        this.checkRawEncoding("UTF-8", null, "UTF-8", "UTF-8", "UTF-16BE");
        this.checkRawEncoding("UTF-16BE", null, "UTF-16BE", "UTF-16BE", null);
        this.checkRawEncoding("UTF-16BE", null, null, null, "UTF-16BE");
        this.checkRawEncoding("UTF-16BE", null, "UTF-8", null, "UTF-16BE");
        this.checkRawEncoding("UTF-16BE", null, null, "UTF-8", "UTF-16BE");
        this.checkRawEncoding("UTF-16BE", null, "UTF-16BE", "UTF-16", null);
        this.checkRawEncoding("UTF-16LE", null, "UTF-16LE", "UTF-16", null);
    }

    @Test
    public void testCalculateRawEncodingStandard() throws IOException {
        this.testCalculateRawEncodingStandard("UTF-8", "UTF-16BE", "UTF-16LE");
        this.testCalculateRawEncodingStandard("UTF-16BE", "UTF-8", "UTF-16LE");
        this.testCalculateRawEncodingStandard("UTF-16LE", "UTF-8", "UTF-16BE");
    }

    private void testCalculateRawEncodingStandard(String bomEnc, String otherEnc, String defaultEnc) throws IOException {
        this.checkRawEncoding(bomEnc, bomEnc, null, null, defaultEnc);
        this.checkRawEncoding(bomEnc, bomEnc, bomEnc, null, defaultEnc);
        this.checkRawError("encoding mismatch", bomEnc, otherEnc, null, defaultEnc);
        this.checkRawEncoding(bomEnc, bomEnc, null, bomEnc, defaultEnc);
        this.checkRawError("encoding mismatch", bomEnc, null, otherEnc, defaultEnc);
        this.checkRawEncoding(bomEnc, bomEnc, bomEnc, bomEnc, defaultEnc);
        this.checkRawError("encoding mismatch", bomEnc, bomEnc, otherEnc, defaultEnc);
        this.checkRawError("encoding mismatch", bomEnc, otherEnc, bomEnc, defaultEnc);
    }

    @Test
    public void testCalculateRawEncodingStandardUtf32() throws IOException {
        this.testCalculateRawEncodingStandard("UTF-8", "UTF-32BE", "UTF-32LE");
        this.testCalculateRawEncodingStandard("UTF-32BE", "UTF-8", "UTF-32LE");
        this.testCalculateRawEncodingStandard("UTF-32LE", "UTF-8", "UTF-32BE");
    }

    @Test
    public void testContentTypeEncoding() {
        this.checkContentTypeEncoding(null, null);
        this.checkContentTypeEncoding(null, "");
        this.checkContentTypeEncoding(null, APPXML);
        this.checkContentTypeEncoding(null, "application/xml;");
        this.checkContentTypeEncoding(null, "multipart/mixed;boundary=frontier");
        this.checkContentTypeEncoding(null, "multipart/mixed;boundary='frontier'");
        this.checkContentTypeEncoding(null, "multipart/mixed;boundary=\"frontier\"");
        this.checkContentTypeEncoding("UTF-16", "application/xml;charset=utf-16");
        this.checkContentTypeEncoding("UTF-16", APPXML_UTF16);
        this.checkContentTypeEncoding("UTF-16", "application/xml;charset='UTF-16'");
        this.checkContentTypeEncoding("UTF-16", "application/xml;charset=\"UTF-16\"");
        this.checkContentTypeEncoding("UTF-32", "application/xml;charset=utf-32");
        this.checkContentTypeEncoding("UTF-32", APPXML_UTF32);
        this.checkContentTypeEncoding("UTF-32", "application/xml;charset='UTF-32'");
        this.checkContentTypeEncoding("UTF-32", "application/xml;charset=\"UTF-32\"");
    }

    @Test
    public void testContentTypeMime() {
        this.checkContentTypeMime(null, null);
        this.checkContentTypeMime("", "");
        this.checkContentTypeMime(APPXML, APPXML);
        this.checkContentTypeMime(APPXML, "application/xml;");
        this.checkContentTypeMime(APPXML, "application/xml;charset=utf-16");
        this.checkContentTypeMime(APPXML, "application/xml;charset=utf-32");
    }

    @Test
    public void testTextXml() {
        this.checkTextXml(false, null);
        this.checkTextXml(false, "");
        this.checkTextXml(true, TXTXML);
        this.checkTextXml(true, "text/xml-external-parsed-entity");
        this.checkTextXml(true, "text/soap+xml");
        this.checkTextXml(true, "text/atom+xml");
        this.checkTextXml(false, "text/atomxml");
        this.checkTextXml(false, APPXML);
        this.checkTextXml(false, "application/atom+xml");
    }

    private static final class MockXmlStreamReader
    extends XmlStreamReader {
        MockXmlStreamReader(String defaultEncoding) throws IOException {
            super((InputStream)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence((CharSequence)"")).get(), null, true, defaultEncoding);
        }
    }
}

