/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.input.AbstractInputStreamTest;
import org.apache.commons.io.input.BufferedFileChannelInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BufferedFileChannelInputStreamTest
extends AbstractInputStreamTest {
    @Override
    @BeforeEach
    public void setUp() throws IOException {
        super.setUp();
        this.inputStreams = new InputStream[]{new BufferedFileChannelInputStream(this.inputFile), new BufferedFileChannelInputStream(this.inputFile, 123), ((BufferedFileChannelInputStream.Builder)BufferedFileChannelInputStream.builder().setPath(this.inputFile)).get(), ((BufferedFileChannelInputStream.Builder)((BufferedFileChannelInputStream.Builder)BufferedFileChannelInputStream.builder().setPath(this.inputFile)).setBufferSize(123)).get(), ((BufferedFileChannelInputStream.Builder)((BufferedFileChannelInputStream.Builder)BufferedFileChannelInputStream.builder().setURI(this.inputFile.toUri())).setBufferSize(1024)).get(), ((BufferedFileChannelInputStream.Builder)((BufferedFileChannelInputStream.Builder)BufferedFileChannelInputStream.builder().setPath(this.inputFile)).setOpenOptions(new OpenOption[]{StandardOpenOption.READ})).get(), BufferedFileChannelInputStream.builder().setFileChannel(FileChannel.open(this.inputFile, new OpenOption[0])).get()};
    }

    @Override
    @Test
    public void testAvailableAfterOpen() throws Exception {
        for (InputStream inputStream : this.inputStreams) {
            Assertions.assertTrue((inputStream.available() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBuilderGet() {
        Assertions.assertThrows(IllegalStateException.class, () -> BufferedFileChannelInputStream.builder().get());
    }

    @Test
    public void testReadAfterClose() throws Exception {
        for (InputStream inputStream : this.inputStreams) {
            inputStream.close();
            Assertions.assertThrows(IOException.class, inputStream::read);
        }
    }
}

