/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class PathUtilsDeleteFileTest
extends AbstractTempDirTest {
    @Test
    public void testDeleteBrokenSymbolicLink() throws IOException {
        Assumptions.assumeFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        Path missingFile = this.tempDirPath.resolve("missing.txt");
        Path brokenLink = this.tempDirPath.resolve("broken.txt");
        Files.createSymbolicLink(brokenLink, missingFile, new FileAttribute[0]);
        Assertions.assertTrue((boolean)Files.exists(brokenLink, LinkOption.NOFOLLOW_LINKS));
        Assertions.assertFalse((boolean)Files.exists(missingFile, LinkOption.NOFOLLOW_LINKS));
        PathUtils.deleteFile((Path)brokenLink);
        Assertions.assertFalse((boolean)Files.exists(brokenLink, LinkOption.NOFOLLOW_LINKS), (String)"Symbolic link not removed");
    }

    @Test
    public void testDeleteFileDirectory1FileSize0() throws IOException {
        String fileName = "file-size-0.bin";
        PathUtils.copyFileToDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0/file-size-0.bin", new String[0]), (Path)this.tempDirPath, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(0L, 1L, 0L, PathUtils.deleteFile((Path)this.tempDirPath.resolve("file-size-0.bin")));
        Files.deleteIfExists(this.tempDirPath);
    }

    @Test
    public void testDeleteFileDirectory1FileSize1() throws IOException {
        String fileName = "file-size-1.bin";
        PathUtils.copyFileToDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]), (Path)this.tempDirPath, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(0L, 1L, 1L, PathUtils.deleteFile((Path)this.tempDirPath.resolve("file-size-1.bin")));
        Files.deleteIfExists(this.tempDirPath);
    }

    @Test
    public void testDeleteFileDoesNotExist() throws IOException {
        this.testDeleteFileEmpty(PathUtils.deleteFile((Path)this.tempDirPath.resolve("file-does-not-exist.bin")));
        Files.deleteIfExists(this.tempDirPath);
    }

    private void testDeleteFileEmpty(Counters.PathCounters pathCounts) {
        CounterAssertions.assertCounts(0L, 0L, 0L, pathCounts);
    }

    @Test
    public void testDeleteFileEmptyDirectory() throws IOException {
        Assertions.assertThrows(NoSuchFileException.class, () -> this.testDeleteFileEmpty(PathUtils.deleteFile((Path)this.tempDirPath)));
        Files.deleteIfExists(this.tempDirPath);
    }

    @Test
    public void testDeleteReadOnlyFileDirectory1FileSize1() throws IOException {
        String fileName = "file-size-1.bin";
        PathUtils.copyFileToDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]), (Path)this.tempDirPath, (CopyOption[])new CopyOption[0]);
        Path resolved = this.tempDirPath.resolve("file-size-1.bin");
        PathUtils.setReadOnly((Path)resolved, (boolean)true, (LinkOption[])new LinkOption[0]);
        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertFalse((boolean)Files.isWritable(resolved));
            Assertions.assertThrows(IOException.class, () -> PathUtils.deleteFile((Path)resolved));
        }
        CounterAssertions.assertCounts(0L, 1L, 1L, PathUtils.deleteFile((Path)resolved, (DeleteOption[])new DeleteOption[]{StandardDeleteOption.OVERRIDE_READ_ONLY}));
        Files.deleteIfExists(this.tempDirPath);
    }

    @Test
    public void testSetReadOnlyFileDirectory1FileSize1() throws IOException {
        String fileName = "file-size-1.bin";
        PathUtils.copyFileToDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]), (Path)this.tempDirPath, (CopyOption[])new CopyOption[0]);
        Path resolved = this.tempDirPath.resolve("file-size-1.bin");
        PathUtils.setReadOnly((Path)resolved, (boolean)true, (LinkOption[])new LinkOption[0]);
        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertFalse((boolean)Files.isWritable(resolved));
            Assertions.assertThrows(IOException.class, () -> PathUtils.deleteFile((Path)resolved));
        }
        PathUtils.setReadOnly((Path)resolved, (boolean)false, (LinkOption[])new LinkOption[0]);
        PathUtils.deleteFile((Path)resolved);
        Files.deleteIfExists(this.tempDirPath);
    }
}

