/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import org.apache.commons.io.file.AbstractPathWrapper;
import org.apache.commons.io.file.CopyDirectoryVisitor;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.TempDirectory;
import org.apache.commons.io.file.TestArguments;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CopyDirectoryVisitorTest
extends TestArguments {
    private static final CopyOption[] EXPECTED_COPY_OPTIONS = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
    @TempDir
    private Path targetDir;

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    public void testCopyDirectoryEmptyFolder(Counters.PathCounters pathCounters) throws IOException {
        try (TempDirectory sourceDir = TempDirectory.create(this.getClass().getSimpleName(), new FileAttribute[0]);){
            Supplier<CopyDirectoryVisitor> supplier = () -> new CopyDirectoryVisitor(pathCounters, (Path)sourceDir, this.targetDir, EXPECTED_COPY_OPTIONS);
            CopyDirectoryVisitor visitFileTree = (CopyDirectoryVisitor)PathUtils.visitFileTree((FileVisitor)supplier.get(), (Path)sourceDir.get());
            CounterAssertions.assertCounts(1L, 0L, 0L, (CountingPathVisitor)visitFileTree);
            Assertions.assertArrayEquals((Object[])EXPECTED_COPY_OPTIONS, (Object[])visitFileTree.getCopyOptions());
            Assertions.assertEquals((Object)sourceDir.get(), (Object)((AbstractPathWrapper)visitFileTree.getSourceDirectory()).get());
            Assertions.assertEquals((Object)sourceDir, (Object)visitFileTree.getSourceDirectory());
            Assertions.assertEquals((Object)this.targetDir, (Object)visitFileTree.getTargetDirectory());
            Assertions.assertEquals((Object)this.targetDir, (Object)visitFileTree.getTargetDirectory());
            Assertions.assertEquals((Object)visitFileTree, (Object)supplier.get());
            Assertions.assertEquals((int)visitFileTree.hashCode(), (int)supplier.get().hashCode());
            Assertions.assertEquals((Object)visitFileTree, (Object)visitFileTree);
            Assertions.assertEquals((int)visitFileTree.hashCode(), (int)visitFileTree.hashCode());
            Assertions.assertNotEquals((Object)visitFileTree, (Object)"not");
            Assertions.assertNotEquals((Object)visitFileTree, (Object)CountingPathVisitor.withLongCounters());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    public void testCopyDirectoryEmptyFolderFilters(Counters.PathCounters pathCounters) throws IOException {
        try (TempDirectory sourceDir = TempDirectory.create(this.getClass().getSimpleName(), new FileAttribute[0]);){
            Supplier<CopyDirectoryVisitor> supplier = () -> new CopyDirectoryVisitor(pathCounters, (PathFilter)TrueFileFilter.INSTANCE, (PathFilter)TrueFileFilter.INSTANCE, (Path)sourceDir, this.targetDir, EXPECTED_COPY_OPTIONS);
            CopyDirectoryVisitor visitFileTree = (CopyDirectoryVisitor)PathUtils.visitFileTree((FileVisitor)supplier.get(), (Path)sourceDir.get());
            CounterAssertions.assertCounts(1L, 0L, 0L, (CountingPathVisitor)visitFileTree);
            Assertions.assertArrayEquals((Object[])EXPECTED_COPY_OPTIONS, (Object[])visitFileTree.getCopyOptions());
            Assertions.assertEquals((Object)sourceDir, (Object)visitFileTree.getSourceDirectory());
            Assertions.assertEquals((Object)this.targetDir, (Object)visitFileTree.getTargetDirectory());
            Assertions.assertEquals((Object)visitFileTree, (Object)supplier.get());
            Assertions.assertEquals((int)visitFileTree.hashCode(), (int)supplier.get().hashCode());
            Assertions.assertEquals((Object)visitFileTree, (Object)visitFileTree);
            Assertions.assertEquals((int)visitFileTree.hashCode(), (int)visitFileTree.hashCode());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    public void testCopyDirectoryFolders1FileSize0(Counters.PathCounters pathCounters) throws IOException {
        Path sourceDir = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]);
        Supplier<CopyDirectoryVisitor> supplier = () -> new CopyDirectoryVisitor(pathCounters, sourceDir, this.targetDir, EXPECTED_COPY_OPTIONS);
        CopyDirectoryVisitor visitFileTree = (CopyDirectoryVisitor)PathUtils.visitFileTree((FileVisitor)supplier.get(), (Path)sourceDir);
        CounterAssertions.assertCounts(1L, 1L, 0L, (CountingPathVisitor)visitFileTree);
        Assertions.assertArrayEquals((Object[])EXPECTED_COPY_OPTIONS, (Object[])visitFileTree.getCopyOptions());
        Assertions.assertEquals((Object)sourceDir, (Object)visitFileTree.getSourceDirectory());
        Assertions.assertEquals((Object)this.targetDir, (Object)visitFileTree.getTargetDirectory());
        Assertions.assertEquals((Object)visitFileTree, (Object)supplier.get());
        Assertions.assertEquals((int)visitFileTree.hashCode(), (int)supplier.get().hashCode());
        Assertions.assertEquals((Object)visitFileTree, (Object)visitFileTree);
        Assertions.assertEquals((int)visitFileTree.hashCode(), (int)visitFileTree.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    public void testCopyDirectoryFolders1FileSize1(Counters.PathCounters pathCounters) throws IOException {
        Path sourceDir = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]);
        CopyDirectoryVisitor visitFileTree = (CopyDirectoryVisitor)PathUtils.visitFileTree((FileVisitor)new CopyDirectoryVisitor(pathCounters, sourceDir, this.targetDir, EXPECTED_COPY_OPTIONS), (Path)sourceDir);
        CounterAssertions.assertCounts(1L, 1L, 1L, (CountingPathVisitor)visitFileTree);
        Assertions.assertArrayEquals((Object[])EXPECTED_COPY_OPTIONS, (Object[])visitFileTree.getCopyOptions());
        Assertions.assertEquals((Object)sourceDir, (Object)visitFileTree.getSourceDirectory());
        Assertions.assertEquals((Object)this.targetDir, (Object)visitFileTree.getTargetDirectory());
    }

    @ParameterizedTest
    @MethodSource(value={"pathCounters"})
    public void testCopyDirectoryFolders2FileSize2(Counters.PathCounters pathCounters) throws IOException {
        Path sourceDir = Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]);
        CopyDirectoryVisitor visitFileTree = (CopyDirectoryVisitor)PathUtils.visitFileTree((FileVisitor)new CopyDirectoryVisitor(pathCounters, sourceDir, this.targetDir, EXPECTED_COPY_OPTIONS), (Path)sourceDir);
        CounterAssertions.assertCounts(3L, 2L, 2L, (CountingPathVisitor)visitFileTree);
        Assertions.assertArrayEquals((Object[])EXPECTED_COPY_OPTIONS, (Object[])visitFileTree.getCopyOptions());
        Assertions.assertEquals((Object)sourceDir, (Object)visitFileTree.getSourceDirectory());
        Assertions.assertEquals((Object)this.targetDir, (Object)visitFileTree.getTargetDirectory());
    }
}

