/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.channels;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.channels.FileChannels;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileChannelsTest
extends AbstractTempDirTest {
    private static final int BUFFER_SIZE = 1024;
    private static final String CONTENT = StringUtils.repeat((String)"x", (int)1024);

    private boolean isEmpty(File empty) {
        return empty.length() == 0L;
    }

    private void testContentEquals(String content1, String content2) throws IOException {
        FileChannel channel2;
        FileChannel channel1;
        FileInputStream stream2;
        Assertions.assertTrue((boolean)FileChannels.contentEquals(null, null, (int)1024));
        File file1 = new File(this.tempDirFile, "test1.txt");
        File file2 = new File(this.tempDirFile, "test2.txt");
        FileUtils.writeStringToFile((File)file1, (String)content1, (Charset)StandardCharsets.US_ASCII);
        FileUtils.writeStringToFile((File)file2, (String)content2, (Charset)StandardCharsets.US_ASCII);
        Assertions.assertNotEquals((long)FileUtils.checksumCRC32((File)file1), (long)FileUtils.checksumCRC32((File)file2));
        try (FileInputStream stream1 = new FileInputStream(file1);){
            stream2 = new FileInputStream(file2);
            try {
                channel1 = stream1.getChannel();
                try {
                    channel2 = stream2.getChannel();
                    try {
                        Assertions.assertFalse((boolean)FileChannels.contentEquals((FileChannel)channel1, (FileChannel)channel2, (int)1024));
                    }
                    finally {
                        if (channel2 != null) {
                            channel2.close();
                        }
                    }
                }
                finally {
                    if (channel1 != null) {
                        channel1.close();
                    }
                }
            }
            finally {
                stream2.close();
            }
        }
        stream1 = new FileInputStream(file1);
        try {
            stream2 = new FileInputStream(file2);
            try {
                channel1 = stream1.getChannel();
                try {
                    channel2 = stream2.getChannel();
                    try {
                        Assertions.assertTrue((boolean)FileChannels.contentEquals((FileChannel)channel1, (FileChannel)channel1, (int)1024));
                        Assertions.assertTrue((boolean)FileChannels.contentEquals((FileChannel)channel2, (FileChannel)channel2, (int)1024));
                    }
                    finally {
                        if (channel2 != null) {
                            channel2.close();
                        }
                    }
                }
                finally {
                    if (channel1 != null) {
                        channel1.close();
                    }
                }
            }
            finally {
                stream2.close();
            }
        }
        finally {
            stream1.close();
        }
    }

    @Test
    public void testContentEqualsDifferentPostfix() throws IOException {
        this.testContentEquals(CONTENT + "ABC", CONTENT + "XYZ");
    }

    @Test
    public void testContentEqualsDifferentPrefix() throws IOException {
        this.testContentEquals("ABC" + CONTENT, "XYZ" + CONTENT);
    }

    @Test
    public void testContentEqualsEmpty() throws IOException {
        Assertions.assertTrue((boolean)FileChannels.contentEquals(null, null, (int)1024));
        File empty = new File(this.tempDirFile, "empty.txt");
        File notEmpty = new File(this.tempDirFile, "not-empty.txt");
        FileUtils.writeStringToFile((File)empty, (String)"", (Charset)StandardCharsets.US_ASCII);
        FileUtils.writeStringToFile((File)notEmpty, (String)"X", (Charset)StandardCharsets.US_ASCII);
        Assertions.assertTrue((boolean)this.isEmpty(empty));
        Assertions.assertFalse((boolean)this.isEmpty(notEmpty));
        Assertions.assertNotEquals((long)FileUtils.checksumCRC32((File)empty), (long)FileUtils.checksumCRC32((File)notEmpty));
        try (FileInputStream streamEmpty = new FileInputStream(empty);
             FileInputStream streamNotEmpty = new FileInputStream(notEmpty);
             FileChannel channelEmpty = streamEmpty.getChannel();
             FileChannel channelNotEmpty = streamNotEmpty.getChannel();){
            Assertions.assertFalse((boolean)FileChannels.contentEquals((FileChannel)channelEmpty, (FileChannel)channelNotEmpty, (int)1024));
            Assertions.assertFalse((boolean)FileChannels.contentEquals(null, (FileChannel)channelNotEmpty, (int)1024));
            Assertions.assertFalse((boolean)FileChannels.contentEquals((FileChannel)channelNotEmpty, null, (int)1024));
            Assertions.assertTrue((boolean)FileChannels.contentEquals((FileChannel)channelEmpty, (FileChannel)channelEmpty, (int)1024));
            Assertions.assertTrue((boolean)FileChannels.contentEquals(null, (FileChannel)channelEmpty, (int)1024));
            Assertions.assertTrue((boolean)FileChannels.contentEquals((FileChannel)channelEmpty, null, (int)1024));
            Assertions.assertTrue((boolean)FileChannels.contentEquals((FileChannel)channelNotEmpty, (FileChannel)channelNotEmpty, (int)1024));
        }
    }
}

