/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.io.CloseableURLConnection;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.IO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.SelectorAdapter;
import org.apache.commons.io.TestResources;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.input.CircularInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.NullReader;
import org.apache.commons.io.output.AppendableWriter;
import org.apache.commons.io.output.BrokenOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.io.test.TestUtils;
import org.apache.commons.io.test.ThrowOnCloseReader;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class IOUtilsTest {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final int FILE_SIZE = 4097;
    private static final boolean WINDOWS = File.separatorChar == '\\';
    @TempDir
    public File temporaryFolder;
    private char[] carr;
    private byte[] iarr;
    private File testFile;
    private Path testFilePath;

    @BeforeAll
    @AfterAll
    public static void beforeAll() {
        IO.clear();
    }

    private void assertEqualContent(byte[] b0, byte[] b1) {
        Assertions.assertArrayEquals((byte[])b0, (byte[])b1, (String)"Content not equal according to java.util.Arrays#equals()");
    }

    @BeforeEach
    public void setUp() {
        int i;
        try {
            this.testFile = new File(this.temporaryFolder, "file2-test.txt");
            this.testFilePath = this.testFile.toPath();
            if (!this.testFile.getParentFile().exists()) {
                throw new IOException("Cannot create file " + this.testFile + " as the parent directory does not exist");
            }
            try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.testFilePath, new OpenOption[0]));){
                TestUtils.generateTestData(output, 4097L);
            }
        }
        catch (IOException e) {
            Assertions.fail((String)("Can't run this test because the environment could not be built: " + e.getMessage()));
        }
        this.iarr = new byte[200];
        Arrays.fill(this.iarr, (byte)-1);
        for (i = 0; i < 80; ++i) {
            this.iarr[i] = (byte)i;
        }
        this.carr = new char[200];
        Arrays.fill(this.carr, '\uffff');
        for (i = 0; i < 80; ++i) {
            this.carr[i] = (char)i;
        }
    }

    @Test
    public void testAsBufferedInputStream() {
        InputStream is = new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        };
        BufferedInputStream bis = IOUtils.buffer((InputStream)is);
        Assertions.assertNotSame((Object)is, (Object)bis);
        Assertions.assertSame((Object)bis, (Object)IOUtils.buffer((InputStream)bis));
    }

    @Test
    public void testAsBufferedInputStreamWithBufferSize() {
        InputStream is = new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        };
        BufferedInputStream bis = IOUtils.buffer((InputStream)is, (int)2048);
        Assertions.assertNotSame((Object)is, (Object)bis);
        Assertions.assertSame((Object)bis, (Object)IOUtils.buffer((InputStream)bis));
        Assertions.assertSame((Object)bis, (Object)IOUtils.buffer((InputStream)bis, (int)1024));
    }

    @Test
    public void testAsBufferedNull() {
        String npeExpectedMessage = "Expected NullPointerException";
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.buffer((InputStream)null), (String)"Expected NullPointerException");
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.buffer((OutputStream)null), (String)"Expected NullPointerException");
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.buffer((Reader)null), (String)"Expected NullPointerException");
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.buffer((Writer)null), (String)"Expected NullPointerException");
    }

    @Test
    public void testAsBufferedOutputStream() {
        OutputStream is = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
        BufferedOutputStream bis = IOUtils.buffer((OutputStream)is);
        Assertions.assertNotSame((Object)is, (Object)bis);
        Assertions.assertSame((Object)bis, (Object)IOUtils.buffer((OutputStream)bis));
    }

    @Test
    public void testAsBufferedOutputStreamWithBufferSize() {
        OutputStream os = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
        BufferedOutputStream bos = IOUtils.buffer((OutputStream)os, (int)2048);
        Assertions.assertNotSame((Object)os, (Object)bos);
        Assertions.assertSame((Object)bos, (Object)IOUtils.buffer((OutputStream)bos));
        Assertions.assertSame((Object)bos, (Object)IOUtils.buffer((OutputStream)bos, (int)1024));
    }

    @Test
    public void testAsBufferedReader() {
        Reader is = new Reader(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return 0;
            }
        };
        BufferedReader bis = IOUtils.buffer((Reader)is);
        Assertions.assertNotSame((Object)is, (Object)bis);
        Assertions.assertSame((Object)bis, (Object)IOUtils.buffer((Reader)bis));
    }

    @Test
    public void testAsBufferedReaderWithBufferSize() {
        Reader r = new Reader(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return 0;
            }
        };
        BufferedReader br = IOUtils.buffer((Reader)r, (int)2048);
        Assertions.assertNotSame((Object)r, (Object)br);
        Assertions.assertSame((Object)br, (Object)IOUtils.buffer((Reader)br));
        Assertions.assertSame((Object)br, (Object)IOUtils.buffer((Reader)br, (int)1024));
    }

    @Test
    public void testAsBufferedWriter() {
        NullWriter nullWriter = NullWriter.INSTANCE;
        BufferedWriter bis = IOUtils.buffer((Writer)nullWriter);
        Assertions.assertNotSame((Object)nullWriter, (Object)bis);
        Assertions.assertSame((Object)bis, (Object)IOUtils.buffer((Writer)bis));
    }

    @Test
    public void testAsBufferedWriterWithBufferSize() {
        NullWriter nullWriter = NullWriter.INSTANCE;
        BufferedWriter bw = IOUtils.buffer((Writer)nullWriter, (int)2024);
        Assertions.assertNotSame((Object)nullWriter, (Object)bw);
        Assertions.assertSame((Object)bw, (Object)IOUtils.buffer((Writer)bw));
        Assertions.assertSame((Object)bw, (Object)IOUtils.buffer((Writer)bw, (int)1024));
    }

    @Test
    public void testAsWriterAppendable() throws IOException {
        StringBuffer a = new StringBuffer();
        try (Writer w = IOUtils.writer((Appendable)a);){
            Assertions.assertNotSame((Object)w, (Object)a);
            Assertions.assertEquals(AppendableWriter.class, w.getClass());
            Assertions.assertSame((Object)w, (Object)IOUtils.writer((Appendable)w));
        }
    }

    @Test
    public void testAsWriterNull() {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.writer(null));
    }

    @Test
    public void testAsWriterStringBuilder() throws IOException {
        StringBuilder a = new StringBuilder();
        try (Writer w = IOUtils.writer((Appendable)a);){
            Assertions.assertNotSame((Object)w, (Object)a);
            Assertions.assertEquals(StringBuilderWriter.class, w.getClass());
            Assertions.assertSame((Object)w, (Object)IOUtils.writer((Appendable)w));
        }
    }

    @Test
    public void testByteArrayWithNegativeSize() {
        Assertions.assertThrows(NegativeArraySizeException.class, () -> IOUtils.byteArray((int)-1));
    }

    @Test
    public void testClose() {
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)null));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)new StringReader("s")));
        Assertions.assertThrows(IOException.class, () -> IOUtils.close((Closeable)((Object)new ThrowOnCloseReader(new StringReader("s")))));
    }

    @Test
    public void testCloseConsumer() {
        Closeable nullCloseable = null;
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)nullCloseable, null));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)new StringReader("s"), null));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)((Object)new ThrowOnCloseReader(new StringReader("s"))), null));
        IOConsumer nullConsumer = null;
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)nullCloseable, (IOConsumer)nullConsumer));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)new StringReader("s"), (IOConsumer)nullConsumer));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)((Object)new ThrowOnCloseReader(new StringReader("s"))), (IOConsumer)nullConsumer));
        IOConsumer silentConsumer = IOConsumer.noop();
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)nullCloseable, (IOConsumer)silentConsumer));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)new StringReader("s"), (IOConsumer)silentConsumer));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)((Object)new ThrowOnCloseReader(new StringReader("s"))), (IOConsumer)silentConsumer));
        IOConsumer noisyConsumer = i -> {
            throw i;
        };
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)nullCloseable, (IOConsumer)noisyConsumer));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable)new StringReader("s"), (IOConsumer)noisyConsumer));
        Assertions.assertThrows(IOException.class, () -> IOUtils.close((Closeable)((Object)new ThrowOnCloseReader(new StringReader("s"))), (IOConsumer)noisyConsumer));
    }

    @Test
    public void testCloseMulti() {
        Closeable nullCloseable = null;
        Closeable[] closeables = new Closeable[]{null, null};
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable[])new Closeable[]{nullCloseable, nullCloseable}));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable[])closeables));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable[])null));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((Closeable[])new Closeable[]{new StringReader("s"), nullCloseable}));
        Assertions.assertThrows(IOException.class, () -> IOUtils.close((Closeable[])new Closeable[]{nullCloseable, new ThrowOnCloseReader(new StringReader("s"))}));
    }

    @Test
    public void testCloseQuietly_AllCloseableIOException() {
        BrokenInputStream closeable = BrokenInputStream.INSTANCE;
        Assertions.assertDoesNotThrow(() -> IOUtilsTest.lambda$testCloseQuietly_AllCloseableIOException$27((Closeable)closeable));
        Assertions.assertDoesNotThrow(() -> IOUtilsTest.lambda$testCloseQuietly_AllCloseableIOException$28((Closeable)closeable));
        Assertions.assertDoesNotThrow(() -> IOUtilsTest.lambda$testCloseQuietly_AllCloseableIOException$29((Closeable)closeable));
        Assertions.assertDoesNotThrow(() -> IOUtils.closeQuietly((Iterable)null));
    }

    @Test
    public void testCloseQuietly_CloseableIOException() {
        Assertions.assertDoesNotThrow(() -> IOUtils.closeQuietly((InputStream)BrokenInputStream.INSTANCE));
        Assertions.assertDoesNotThrow(() -> IOUtils.closeQuietly((OutputStream)BrokenOutputStream.INSTANCE));
    }

    @Test
    public void testCloseQuietly_Selector() {
        Selector selector = null;
        try {
            selector = Selector.open();
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((Selector)selector);
        }
    }

    @Test
    public void testCloseQuietly_SelectorIOException() {
        SelectorAdapter selector = new SelectorAdapter(){

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        };
        IOUtils.closeQuietly((Selector)selector);
    }

    @Test
    public void testCloseQuietly_SelectorNull() {
        Selector selector = null;
        IOUtils.closeQuietly(selector);
    }

    @Test
    public void testCloseQuietly_SelectorTwice() {
        Selector selector = null;
        try {
            selector = Selector.open();
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((Selector)selector);
            IOUtils.closeQuietly((Selector)selector);
        }
    }

    @Test
    public void testCloseQuietly_ServerSocket() {
        Assertions.assertDoesNotThrow(() -> IOUtils.closeQuietly((ServerSocket)null));
        Assertions.assertDoesNotThrow(() -> IOUtils.closeQuietly((ServerSocket)new ServerSocket()));
    }

    @Test
    public void testCloseQuietly_ServerSocketIOException() {
        Assertions.assertDoesNotThrow(() -> IOUtils.closeQuietly((ServerSocket)new ServerSocket(){

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        }));
    }

    @Test
    public void testCloseQuietly_Socket() {
        Assertions.assertDoesNotThrow(() -> IOUtils.closeQuietly((Socket)null));
        Assertions.assertDoesNotThrow(() -> IOUtils.closeQuietly((Socket)new Socket()));
    }

    @Test
    public void testCloseQuietly_SocketIOException() {
        Assertions.assertDoesNotThrow(() -> IOUtils.closeQuietly((Socket)new Socket(){

            @Override
            public synchronized void close() throws IOException {
                throw new IOException();
            }
        }));
    }

    @Test
    public void testCloseURLConnection() {
        Assertions.assertDoesNotThrow(() -> IOUtils.close((URLConnection)null));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((URLConnection)new URL("https://www.apache.org/").openConnection()));
        Assertions.assertDoesNotThrow(() -> IOUtils.close((URLConnection)new URL("file:///").openConnection()));
    }

    @Test
    public void testConstants() {
        Assertions.assertEquals((char)'/', (char)'/');
        Assertions.assertEquals((char)'\\', (char)'\\');
        Assertions.assertEquals((Object)"\n", (Object)IOUtils.LINE_SEPARATOR_UNIX);
        Assertions.assertEquals((Object)"\r\n", (Object)IOUtils.LINE_SEPARATOR_WINDOWS);
        if (WINDOWS) {
            Assertions.assertEquals((char)'\\', (char)IOUtils.DIR_SEPARATOR);
            Assertions.assertEquals((Object)"\r\n", (Object)IOUtils.LINE_SEPARATOR);
        } else {
            Assertions.assertEquals((char)'/', (char)IOUtils.DIR_SEPARATOR);
            Assertions.assertEquals((Object)"\n", (Object)IOUtils.LINE_SEPARATOR);
        }
        Assertions.assertEquals((int)13, (int)13);
        Assertions.assertEquals((int)10, (int)10);
        Assertions.assertEquals((int)-1, (int)-1);
    }

    @Test
    public void testConsumeInputStream() throws Exception {
        long size = 0x80000000L;
        NullInputStream in = new NullInputStream(0x80000000L);
        NullOutputStream out = NullOutputStream.INSTANCE;
        Assertions.assertEquals((int)-1, (int)IOUtils.copy((InputStream)in, (OutputStream)out));
        in.init();
        Assertions.assertEquals((long)0x80000000L, (long)IOUtils.consume((InputStream)in), (String)"consume()");
    }

    @Test
    public void testConsumeReader() throws Exception {
        long size = 0x80000000L;
        NullReader in = new NullReader(0x80000000L);
        NullWriter out = NullWriter.INSTANCE;
        Assertions.assertEquals((int)-1, (int)IOUtils.copy((Reader)in, (Writer)out));
        in.close();
        Assertions.assertEquals((long)0x80000000L, (long)IOUtils.consume((Reader)in), (String)"consume()");
    }

    @Test
    public void testContentEquals_InputStream_InputStream() throws Exception {
        Assertions.assertTrue((boolean)IOUtils.contentEquals((InputStream)null, null));
        byte[] dataEmpty = "".getBytes(StandardCharsets.UTF_8);
        byte[] dataAbc = "ABC".getBytes(StandardCharsets.UTF_8);
        byte[] dataAbcd = "ABCD".getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream input1 = new ByteArrayInputStream(dataEmpty);
        Assertions.assertFalse((boolean)IOUtils.contentEquals((InputStream)input1, null));
        input1 = new ByteArrayInputStream(dataEmpty);
        Assertions.assertFalse((boolean)IOUtils.contentEquals(null, (InputStream)input1));
        input1 = new ByteArrayInputStream(dataEmpty);
        Assertions.assertTrue((boolean)IOUtils.contentEquals((InputStream)input1, (InputStream)input1));
        input1 = new ByteArrayInputStream(dataAbc);
        Assertions.assertTrue((boolean)IOUtils.contentEquals((InputStream)input1, (InputStream)input1));
        Assertions.assertTrue((boolean)IOUtils.contentEquals((InputStream)new ByteArrayInputStream(dataEmpty), (InputStream)new ByteArrayInputStream(dataEmpty)));
        Assertions.assertTrue((boolean)IOUtils.contentEquals((InputStream)new BufferedInputStream(new ByteArrayInputStream(dataEmpty)), (InputStream)new BufferedInputStream(new ByteArrayInputStream(dataEmpty))));
        Assertions.assertTrue((boolean)IOUtils.contentEquals((InputStream)new ByteArrayInputStream(dataAbc), (InputStream)new ByteArrayInputStream(dataAbc)));
        Assertions.assertFalse((boolean)IOUtils.contentEquals((InputStream)new ByteArrayInputStream(dataAbcd), (InputStream)new ByteArrayInputStream(dataAbc)));
        Assertions.assertFalse((boolean)IOUtils.contentEquals((InputStream)new ByteArrayInputStream(dataAbc), (InputStream)new ByteArrayInputStream(dataAbcd)));
        Assertions.assertFalse((boolean)IOUtils.contentEquals((InputStream)new ByteArrayInputStream("apache".getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream("apacha".getBytes(StandardCharsets.UTF_8))));
        byte[] bytes2XDefaultA = new byte[16384];
        byte[] bytes2XDefaultB = new byte[16384];
        byte[] bytes2XDefaultA2 = new byte[16384];
        Arrays.fill(bytes2XDefaultA, (byte)97);
        Arrays.fill(bytes2XDefaultB, (byte)98);
        Arrays.fill(bytes2XDefaultA2, (byte)97);
        bytes2XDefaultA2[bytes2XDefaultA2.length - 1] = 100;
        Assertions.assertFalse((boolean)IOUtils.contentEquals((InputStream)new ByteArrayInputStream(bytes2XDefaultA), (InputStream)new ByteArrayInputStream(bytes2XDefaultB)));
        Assertions.assertFalse((boolean)IOUtils.contentEquals((InputStream)new ByteArrayInputStream(bytes2XDefaultA), (InputStream)new ByteArrayInputStream(bytes2XDefaultA2)));
        Assertions.assertTrue((boolean)IOUtils.contentEquals((InputStream)new ByteArrayInputStream(bytes2XDefaultA), (InputStream)new ByteArrayInputStream(bytes2XDefaultA)));
        try (FileInputStream input12 = new FileInputStream("src/test/resources/org/apache/commons/io/abitmorethan16k.txt");
             FileInputStream input2 = new FileInputStream("src/test/resources/org/apache/commons/io/abitmorethan16kcopy.txt");){
            Assertions.assertTrue((boolean)IOUtils.contentEquals((InputStream)input12, (InputStream)input12));
        }
    }

    @Test
    public void testContentEquals_Reader_Reader() throws Exception {
        Assertions.assertTrue((boolean)IOUtils.contentEquals((Reader)null, null));
        StringReader input1 = new StringReader("");
        Assertions.assertFalse((boolean)IOUtils.contentEquals(null, (Reader)input1));
        input1 = new StringReader("");
        Assertions.assertFalse((boolean)IOUtils.contentEquals((Reader)input1, null));
        input1 = new StringReader("");
        Assertions.assertTrue((boolean)IOUtils.contentEquals((Reader)input1, (Reader)input1));
        input1 = new StringReader("ABC");
        Assertions.assertTrue((boolean)IOUtils.contentEquals((Reader)input1, (Reader)input1));
        Assertions.assertTrue((boolean)IOUtils.contentEquals((Reader)new StringReader(""), (Reader)new StringReader("")));
        Assertions.assertTrue((boolean)IOUtils.contentEquals((Reader)new BufferedReader(new StringReader("")), (Reader)new BufferedReader(new StringReader(""))));
        Assertions.assertTrue((boolean)IOUtils.contentEquals((Reader)new StringReader("ABC"), (Reader)new StringReader("ABC")));
        Assertions.assertFalse((boolean)IOUtils.contentEquals((Reader)new StringReader("ABCD"), (Reader)new StringReader("ABC")));
        Assertions.assertFalse((boolean)IOUtils.contentEquals((Reader)new StringReader("ABC"), (Reader)new StringReader("ABCD")));
        Assertions.assertFalse((boolean)IOUtils.contentEquals((Reader)new StringReader("apache"), (Reader)new StringReader("apacha")));
    }

    @Test
    public void testContentEqualsIgnoreEOL() throws Exception {
        Assertions.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL(null, null));
        char[] empty = new char[]{};
        CharArrayReader input1 = new CharArrayReader(empty);
        Assertions.assertFalse((boolean)IOUtils.contentEqualsIgnoreEOL(null, (Reader)input1));
        input1 = new CharArrayReader(empty);
        Assertions.assertFalse((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)input1, null));
        input1 = new CharArrayReader(empty);
        Assertions.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)input1, (Reader)input1));
        input1 = new CharArrayReader("321\r\n".toCharArray());
        Assertions.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)input1, (Reader)input1));
        this.testSingleEOL("", "", true);
        this.testSingleEOL("", "\n", false);
        this.testSingleEOL("", "\r", false);
        this.testSingleEOL("", "\r\n", false);
        this.testSingleEOL("", "\r\r", false);
        this.testSingleEOL("", "\n\n", false);
        this.testSingleEOL("1", "1", true);
        this.testSingleEOL("1", "2", false);
        this.testSingleEOL("123\rabc", "123\nabc", true);
        this.testSingleEOL("321", "321\r\n", true);
        this.testSingleEOL("321", "321\r\naabb", false);
        this.testSingleEOL("321", "321\n", true);
        this.testSingleEOL("321", "321\r", true);
        this.testSingleEOL("321", "321\r\n", true);
        this.testSingleEOL("321", "321\r\r", false);
        this.testSingleEOL("321", "321\n\r", false);
        this.testSingleEOL("321\n", "321", true);
        this.testSingleEOL("321\n", "321\n\r", false);
        this.testSingleEOL("321\n", "321\r\n", true);
        this.testSingleEOL("321\r", "321\r\n", true);
        this.testSingleEOL("321\r\n", "321\r\n\r", false);
        this.testSingleEOL("123", "1234", false);
        this.testSingleEOL("1235", "1234", false);
    }

    @Test
    public void testCopy_ByteArray_OutputStream() throws Exception {
        byte[] in;
        File destination = TestUtils.newFile(this.temporaryFolder, "copy8.txt");
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            in = IOUtils.toByteArray((InputStream)fin);
        }
        try (OutputStream fout = Files.newOutputStream(destination.toPath(), new OpenOption[0]);){
            CopyUtils.copy((byte[])in, (OutputStream)fout);
            fout.flush();
            TestUtils.checkFile(destination, this.testFile);
            TestUtils.checkWrite(fout);
        }
        TestUtils.deleteFile(destination);
    }

    @Test
    public void testCopy_ByteArray_Writer() throws Exception {
        byte[] in;
        File destination = TestUtils.newFile(this.temporaryFolder, "copy7.txt");
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            in = IOUtils.toByteArray((InputStream)fin);
        }
        try (BufferedWriter fout = Files.newBufferedWriter(destination.toPath(), new OpenOption[0]);){
            CopyUtils.copy((byte[])in, (Writer)fout);
            ((Writer)fout).flush();
            TestUtils.checkFile(destination, this.testFile);
            TestUtils.checkWrite(fout);
        }
        TestUtils.deleteFile(destination);
    }

    @Test
    public void testCopy_String_Writer() throws Exception {
        String str;
        File destination = TestUtils.newFile(this.temporaryFolder, "copy6.txt");
        try (BufferedReader fin = Files.newBufferedReader(this.testFilePath);){
            str = IOUtils.toString((Reader)fin);
        }
        try (BufferedWriter fout = Files.newBufferedWriter(destination.toPath(), new OpenOption[0]);){
            CopyUtils.copy((String)str, (Writer)fout);
            ((Writer)fout).flush();
            TestUtils.checkFile(destination, this.testFile);
            TestUtils.checkWrite(fout);
        }
        TestUtils.deleteFile(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_CharExtraLength() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            Assertions.assertEquals((long)200L, (long)IOUtils.copyLarge((Reader)is, (Writer)os, (long)0L, (long)2000L));
            char[] oarr = os.toCharArray();
            Assertions.assertEquals((int)200, (int)oarr.length);
            Assertions.assertEquals((int)1, (int)oarr[1]);
            Assertions.assertEquals((int)79, (int)oarr[79]);
            Assertions.assertEquals((char)'\uffff', (char)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_CharFullLength() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            Assertions.assertEquals((long)200L, (long)IOUtils.copyLarge((Reader)is, (Writer)os, (long)0L, (long)-1L));
            char[] oarr = os.toCharArray();
            Assertions.assertEquals((int)200, (int)oarr.length);
            Assertions.assertEquals((int)1, (int)oarr[1]);
            Assertions.assertEquals((int)79, (int)oarr[79]);
            Assertions.assertEquals((char)'\uffff', (char)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_CharNoSkip() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            Assertions.assertEquals((long)100L, (long)IOUtils.copyLarge((Reader)is, (Writer)os, (long)0L, (long)100L));
            char[] oarr = os.toCharArray();
            Assertions.assertEquals((int)100, (int)oarr.length);
            Assertions.assertEquals((int)1, (int)oarr[1]);
            Assertions.assertEquals((int)79, (int)oarr[79]);
            Assertions.assertEquals((char)'\uffff', (char)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_CharSkip() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            Assertions.assertEquals((long)100L, (long)IOUtils.copyLarge((Reader)is, (Writer)os, (long)10L, (long)100L));
            char[] oarr = os.toCharArray();
            Assertions.assertEquals((int)100, (int)oarr.length);
            Assertions.assertEquals((int)11, (int)oarr[1]);
            Assertions.assertEquals((int)79, (int)oarr[69]);
            Assertions.assertEquals((char)'\uffff', (char)oarr[70]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }

    @Test
    public void testCopyLarge_CharSkipInvalid() {
        try (CharArrayReader is = new CharArrayReader(this.carr);
             CharArrayWriter os = new CharArrayWriter();){
            Assertions.assertThrows(EOFException.class, () -> IOUtils.copyLarge((Reader)is, (Writer)os, (long)1000L, (long)100L));
        }
    }

    @Test
    public void testCopyLarge_ExtraLength() throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.iarr);
             ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Assertions.assertEquals((long)200L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)0L, (long)2000L));
            byte[] oarr = os.toByteArray();
            Assertions.assertEquals((int)200, (int)oarr.length);
            Assertions.assertEquals((int)1, (int)oarr[1]);
            Assertions.assertEquals((int)79, (int)oarr[79]);
            Assertions.assertEquals((int)-1, (int)oarr[80]);
        }
    }

    @Test
    public void testCopyLarge_FullLength() throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.iarr);
             ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Assertions.assertEquals((long)200L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)0L, (long)-1L));
            byte[] oarr = os.toByteArray();
            Assertions.assertEquals((int)200, (int)oarr.length);
            Assertions.assertEquals((int)1, (int)oarr[1]);
            Assertions.assertEquals((int)79, (int)oarr[79]);
            Assertions.assertEquals((int)-1, (int)oarr[80]);
        }
    }

    @Test
    public void testCopyLarge_NoSkip() throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.iarr);
             ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Assertions.assertEquals((long)100L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)0L, (long)100L));
            byte[] oarr = os.toByteArray();
            Assertions.assertEquals((int)100, (int)oarr.length);
            Assertions.assertEquals((int)1, (int)oarr[1]);
            Assertions.assertEquals((int)79, (int)oarr[79]);
            Assertions.assertEquals((int)-1, (int)oarr[80]);
        }
    }

    @Test
    public void testCopyLarge_Skip() throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.iarr);
             ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Assertions.assertEquals((long)100L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)10L, (long)100L));
            byte[] oarr = os.toByteArray();
            Assertions.assertEquals((int)100, (int)oarr.length);
            Assertions.assertEquals((int)11, (int)oarr[1]);
            Assertions.assertEquals((int)79, (int)oarr[69]);
            Assertions.assertEquals((int)-1, (int)oarr[70]);
        }
    }

    @Test
    public void testCopyLarge_SkipInvalid() throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.iarr);
             ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Assertions.assertThrows(EOFException.class, () -> IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)1000L, (long)100L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_SkipWithInvalidOffset() throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new ByteArrayInputStream(this.iarr);
            os = new ByteArrayOutputStream();
            Assertions.assertEquals((long)100L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)-10L, (long)100L));
            byte[] oarr = os.toByteArray();
            Assertions.assertEquals((int)100, (int)oarr.length);
            Assertions.assertEquals((int)1, (int)oarr[1]);
            Assertions.assertEquals((int)79, (int)oarr[79]);
            Assertions.assertEquals((int)-1, (int)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRead_ReadableByteChannel() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(4097);
        FileInputStream fileInputStream = new FileInputStream(this.testFile);
        FileChannel input = fileInputStream.getChannel();
        try {
            Assertions.assertEquals((int)4097, (int)IOUtils.read((ReadableByteChannel)input, (ByteBuffer)buffer));
            Assertions.assertEquals((int)0, (int)IOUtils.read((ReadableByteChannel)input, (ByteBuffer)buffer));
            Assertions.assertEquals((int)0, (int)buffer.remaining());
            Assertions.assertEquals((int)0, (int)input.read(buffer));
            buffer.clear();
            Assertions.assertThrows(EOFException.class, () -> IOUtils.readFully((ReadableByteChannel)input, (ByteBuffer)buffer), (String)"Should have failed with EOFException");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable[])new Closeable[]{input, fileInputStream});
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{input, fileInputStream});
    }

    @Test
    public void testReadFully_InputStream__ReturnByteArray() throws Exception {
        byte[] bytes = "abcd1234".getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        byte[] result = IOUtils.readFully((InputStream)stream, (int)bytes.length);
        IOUtils.closeQuietly((InputStream)stream);
        this.assertEqualContent(result, bytes);
    }

    @Test
    public void testReadFully_InputStream_ByteArray() throws Exception {
        int size = 1027;
        byte[] buffer = new byte[1027];
        ByteArrayInputStream input = new ByteArrayInputStream(new byte[1027]);
        Assertions.assertThrows(IllegalArgumentException.class, () -> IOUtils.readFully((InputStream)input, (byte[])buffer, (int)0, (int)-1), (String)"Should have failed with IllegalArgumentException");
        IOUtils.readFully((InputStream)input, (byte[])buffer, (int)0, (int)0);
        IOUtils.readFully((InputStream)input, (byte[])buffer, (int)0, (int)1026);
        Assertions.assertThrows(EOFException.class, () -> IOUtils.readFully((InputStream)input, (byte[])buffer, (int)0, (int)2), (String)"Should have failed with EOFException");
        IOUtils.closeQuietly((InputStream)input);
    }

    @Test
    public void testReadFully_InputStream_Offset() throws Exception {
        CharSequenceInputStream stream = ((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence((CharSequence)"abcd1234")).setCharset(StandardCharsets.UTF_8).get();
        byte[] buffer = "wx00000000".getBytes(StandardCharsets.UTF_8);
        IOUtils.readFully((InputStream)stream, (byte[])buffer, (int)2, (int)8);
        Assertions.assertEquals((Object)"wxabcd1234", (Object)new String(buffer, 0, buffer.length, StandardCharsets.UTF_8));
        IOUtils.closeQuietly((InputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFully_ReadableByteChannel() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(4097);
        FileInputStream fileInputStream = new FileInputStream(this.testFile);
        FileChannel input = fileInputStream.getChannel();
        try {
            IOUtils.readFully((ReadableByteChannel)input, (ByteBuffer)buffer);
            Assertions.assertEquals((int)4097, (int)buffer.position());
            Assertions.assertEquals((int)0, (int)buffer.remaining());
            Assertions.assertEquals((int)0, (int)input.read(buffer));
            IOUtils.readFully((ReadableByteChannel)input, (ByteBuffer)buffer);
            Assertions.assertEquals((int)4097, (int)buffer.position());
            Assertions.assertEquals((int)0, (int)buffer.remaining());
            Assertions.assertEquals((int)0, (int)input.read(buffer));
            IOUtils.readFully((ReadableByteChannel)input, (ByteBuffer)buffer);
            buffer.clear();
            Assertions.assertThrows(EOFException.class, () -> IOUtils.readFully((ReadableByteChannel)input, (ByteBuffer)buffer), (String)"Should have failed with EOFxception");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable[])new Closeable[]{input, fileInputStream});
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{input, fileInputStream});
    }

    @Test
    public void testReadFully_Reader() throws Exception {
        int size = 1027;
        char[] buffer = new char[1027];
        CharArrayReader input = new CharArrayReader(new char[1027]);
        IOUtils.readFully((Reader)input, (char[])buffer, (int)0, (int)0);
        IOUtils.readFully((Reader)input, (char[])buffer, (int)0, (int)1024);
        Assertions.assertThrows(IllegalArgumentException.class, () -> IOUtils.readFully((Reader)input, (char[])buffer, (int)0, (int)-1), (String)"Should have failed with IllegalArgumentException");
        Assertions.assertThrows(EOFException.class, () -> IOUtils.readFully((Reader)input, (char[])buffer, (int)0, (int)5), (String)"Should have failed with EOFException");
        IOUtils.closeQuietly((Reader)input);
    }

    @Test
    public void testReadFully_Reader_Offset() throws Exception {
        StringReader reader = new StringReader("abcd1234");
        char[] buffer = "wx00000000".toCharArray();
        IOUtils.readFully((Reader)reader, (char[])buffer, (int)2, (int)8);
        Assertions.assertEquals((Object)"wxabcd1234", (Object)new String(buffer));
        IOUtils.closeQuietly((Reader)reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLines_CharSequence() throws IOException {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        String csq = null;
        try {
            String[] data = new String[]{"hello", "/u1234", "", "this is", "some text"};
            TestUtils.createLineBasedFile(file, data);
            csq = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
            List lines = IOUtils.readLines((CharSequence)csq);
            Assertions.assertEquals(Arrays.asList(data), (Object)lines);
        }
        finally {
            TestUtils.deleteFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLines_CharSequenceAsStringBuilder() throws IOException {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        StringBuilder csq = null;
        try {
            String[] data = new String[]{"hello", "/u1234", "", "this is", "some text"};
            TestUtils.createLineBasedFile(file, data);
            csq = new StringBuilder(new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8));
            List lines = IOUtils.readLines((CharSequence)csq);
            Assertions.assertEquals(Arrays.asList(data), (Object)lines);
        }
        finally {
            TestUtils.deleteFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLines_InputStream() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        InputStream in = null;
        try {
            String[] data = new String[]{"hello", "world", "", "this is", "some text"};
            TestUtils.createLineBasedFile(file, data);
            in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            List lines = IOUtils.readLines((InputStream)in);
            Assertions.assertEquals(Arrays.asList(data), (Object)lines);
            Assertions.assertEquals((int)-1, (int)in.read());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            TestUtils.deleteFile(file);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        TestUtils.deleteFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLines_InputStream_String() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        InputStream in = null;
        try {
            String[] data = new String[]{"hello", "/u1234", "", "this is", "some text"};
            TestUtils.createLineBasedFile(file, data);
            in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            List lines = IOUtils.readLines((InputStream)in, (String)UTF_8);
            Assertions.assertEquals(Arrays.asList(data), (Object)lines);
            Assertions.assertEquals((int)-1, (int)in.read());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            TestUtils.deleteFile(file);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        TestUtils.deleteFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLines_Reader() throws Exception {
        File file = TestUtils.newFile(this.temporaryFolder, "lines.txt");
        InputStreamReader in = null;
        try {
            String[] data = new String[]{"hello", "/u1234", "", "this is", "some text"};
            TestUtils.createLineBasedFile(file, data);
            in = new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]));
            List lines = IOUtils.readLines((Reader)in);
            Assertions.assertEquals(Arrays.asList(data), (Object)lines);
            Assertions.assertEquals((int)-1, (int)((Reader)in).read());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            TestUtils.deleteFile(file);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        TestUtils.deleteFile(file);
    }

    @Test
    public void testResourceToByteArray_ExistingResourceAtRootPackage() throws Exception {
        long fileSize = TestResources.getFile("test-file-utf8.bin").length();
        byte[] bytes = IOUtils.resourceToByteArray((String)"/org/apache/commons/io/test-file-utf8.bin");
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((long)fileSize, (long)bytes.length);
    }

    @Test
    public void testResourceToByteArray_ExistingResourceAtRootPackage_WithClassLoader() throws Exception {
        long fileSize = TestResources.getFile("test-file-utf8.bin").length();
        byte[] bytes = IOUtils.resourceToByteArray((String)"org/apache/commons/io/test-file-utf8.bin", (ClassLoader)ClassLoader.getSystemClassLoader());
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((long)fileSize, (long)bytes.length);
    }

    @Test
    public void testResourceToByteArray_ExistingResourceAtSubPackage() throws Exception {
        long fileSize = TestResources.getFile("FileUtilsTestDataCR.dat").length();
        byte[] bytes = IOUtils.resourceToByteArray((String)"/org/apache/commons/io/FileUtilsTestDataCR.dat");
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((long)fileSize, (long)bytes.length);
    }

    @Test
    public void testResourceToByteArray_ExistingResourceAtSubPackage_WithClassLoader() throws Exception {
        long fileSize = TestResources.getFile("FileUtilsTestDataCR.dat").length();
        byte[] bytes = IOUtils.resourceToByteArray((String)"org/apache/commons/io/FileUtilsTestDataCR.dat", (ClassLoader)ClassLoader.getSystemClassLoader());
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((long)fileSize, (long)bytes.length);
    }

    @Test
    public void testResourceToByteArray_NonExistingResource() {
        Assertions.assertThrows(IOException.class, () -> IOUtils.resourceToByteArray((String)"/non-existing-file.bin"));
    }

    @Test
    public void testResourceToByteArray_NonExistingResource_WithClassLoader() {
        Assertions.assertThrows(IOException.class, () -> IOUtils.resourceToByteArray((String)"non-existing-file.bin", (ClassLoader)ClassLoader.getSystemClassLoader()));
    }

    @Test
    public void testResourceToByteArray_Null() {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.resourceToByteArray(null));
    }

    @Test
    public void testResourceToByteArray_Null_WithClassLoader() {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.resourceToByteArray(null, (ClassLoader)ClassLoader.getSystemClassLoader()));
    }

    @Test
    public void testResourceToString_ExistingResourceAtRootPackage() throws Exception {
        long fileSize = TestResources.getFile("test-file-simple-utf8.bin").length();
        String content = IOUtils.resourceToString((String)"/org/apache/commons/io/test-file-simple-utf8.bin", (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)content);
        Assertions.assertEquals((long)fileSize, (long)content.getBytes().length);
    }

    @Test
    public void testResourceToString_ExistingResourceAtRootPackage_WithClassLoader() throws Exception {
        long fileSize = TestResources.getFile("test-file-simple-utf8.bin").length();
        String content = IOUtils.resourceToString((String)"org/apache/commons/io/test-file-simple-utf8.bin", (Charset)StandardCharsets.UTF_8, (ClassLoader)ClassLoader.getSystemClassLoader());
        Assertions.assertNotNull((Object)content);
        Assertions.assertEquals((long)fileSize, (long)content.getBytes().length);
    }

    @Test
    public void testResourceToString_ExistingResourceAtSubPackage() throws Exception {
        long fileSize = TestResources.getFile("FileUtilsTestDataCR.dat").length();
        String content = IOUtils.resourceToString((String)"/org/apache/commons/io/FileUtilsTestDataCR.dat", (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)content);
        Assertions.assertEquals((long)fileSize, (long)content.getBytes().length);
    }

    @Test
    public void testResourceToString_ExistingResourceAtSubPackage_WithClassLoader() throws Exception {
        long fileSize = TestResources.getFile("FileUtilsTestDataCR.dat").length();
        String content = IOUtils.resourceToString((String)"org/apache/commons/io/FileUtilsTestDataCR.dat", (Charset)StandardCharsets.UTF_8, (ClassLoader)ClassLoader.getSystemClassLoader());
        Assertions.assertNotNull((Object)content);
        Assertions.assertEquals((long)fileSize, (long)content.getBytes().length);
    }

    @Test
    public void testResourceToString_NonExistingResource() {
        Assertions.assertThrows(IOException.class, () -> IOUtils.resourceToString((String)"/non-existing-file.bin", (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testResourceToString_NonExistingResource_WithClassLoader() {
        Assertions.assertThrows(IOException.class, () -> IOUtils.resourceToString((String)"non-existing-file.bin", (Charset)StandardCharsets.UTF_8, (ClassLoader)ClassLoader.getSystemClassLoader()));
    }

    @Test
    public void testResourceToString_NullCharset() throws Exception {
        IOUtils.resourceToString((String)"/org/apache/commons/io//test-file-utf8.bin", null);
    }

    @Test
    public void testResourceToString_NullCharset_WithClassLoader() throws Exception {
        IOUtils.resourceToString((String)"org/apache/commons/io/test-file-utf8.bin", null, (ClassLoader)ClassLoader.getSystemClassLoader());
    }

    @Test
    public void testResourceToString_NullResource() {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.resourceToString(null, (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testResourceToString_NullResource_WithClassLoader() {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.resourceToString(null, (Charset)StandardCharsets.UTF_8, (ClassLoader)ClassLoader.getSystemClassLoader()));
    }

    @Test
    public void testResourceToURL_ExistingResourceAtRootPackage() throws Exception {
        URL url = IOUtils.resourceToURL((String)"/org/apache/commons/io/test-file-utf8.bin");
        Assertions.assertNotNull((Object)url);
        Assertions.assertTrue((boolean)url.getFile().endsWith("/test-file-utf8.bin"));
    }

    @Test
    public void testResourceToURL_ExistingResourceAtRootPackage_WithClassLoader() throws Exception {
        URL url = IOUtils.resourceToURL((String)"org/apache/commons/io/test-file-utf8.bin", (ClassLoader)ClassLoader.getSystemClassLoader());
        Assertions.assertNotNull((Object)url);
        Assertions.assertTrue((boolean)url.getFile().endsWith("/org/apache/commons/io/test-file-utf8.bin"));
    }

    @Test
    public void testResourceToURL_ExistingResourceAtSubPackage() throws Exception {
        URL url = IOUtils.resourceToURL((String)"/org/apache/commons/io/FileUtilsTestDataCR.dat");
        Assertions.assertNotNull((Object)url);
        Assertions.assertTrue((boolean)url.getFile().endsWith("/org/apache/commons/io/FileUtilsTestDataCR.dat"));
    }

    @Test
    public void testResourceToURL_ExistingResourceAtSubPackage_WithClassLoader() throws Exception {
        URL url = IOUtils.resourceToURL((String)"org/apache/commons/io/FileUtilsTestDataCR.dat", (ClassLoader)ClassLoader.getSystemClassLoader());
        Assertions.assertNotNull((Object)url);
        Assertions.assertTrue((boolean)url.getFile().endsWith("/org/apache/commons/io/FileUtilsTestDataCR.dat"));
    }

    @Test
    public void testResourceToURL_NonExistingResource() {
        Assertions.assertThrows(IOException.class, () -> IOUtils.resourceToURL((String)"/non-existing-file.bin"));
    }

    @Test
    public void testResourceToURL_NonExistingResource_WithClassLoader() {
        Assertions.assertThrows(IOException.class, () -> IOUtils.resourceToURL((String)"non-existing-file.bin", (ClassLoader)ClassLoader.getSystemClassLoader()));
    }

    @Test
    public void testResourceToURL_Null() {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.resourceToURL(null));
    }

    @Test
    public void testResourceToURL_Null_WithClassLoader() {
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.resourceToURL(null, (ClassLoader)ClassLoader.getSystemClassLoader()));
    }

    public void testSingleEOL(String s1, String s2, boolean ifEquals) {
        Assertions.assertEquals((Object)ifEquals, (Object)IOUtils.contentEqualsIgnoreEOL((Reader)new CharArrayReader(s1.toCharArray()), (Reader)new CharArrayReader(s2.toCharArray())), (String)("failed at :{" + s1 + "," + s2 + "}"));
        Assertions.assertEquals((Object)ifEquals, (Object)IOUtils.contentEqualsIgnoreEOL((Reader)new CharArrayReader(s2.toCharArray()), (Reader)new CharArrayReader(s1.toCharArray())), (String)("failed at :{" + s2 + "," + s1 + "}"));
        Assertions.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)new CharArrayReader(s1.toCharArray()), (Reader)new CharArrayReader(s1.toCharArray())), (String)("failed at :{" + s1 + "," + s1 + "}"));
        Assertions.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)new CharArrayReader(s2.toCharArray()), (Reader)new CharArrayReader(s2.toCharArray())), (String)("failed at :{" + s2 + "," + s2 + "}"));
    }

    @Test
    public void testSkip_FileReader() throws Exception {
        try (BufferedReader in = Files.newBufferedReader(this.testFilePath);){
            Assertions.assertEquals((long)4087L, (long)IOUtils.skip((Reader)in, (long)4087L));
            Assertions.assertEquals((long)10L, (long)IOUtils.skip((Reader)in, (long)20L));
            Assertions.assertEquals((long)0L, (long)IOUtils.skip((Reader)in, (long)10L));
        }
    }

    @Test
    public void testSkip_InputStream() throws Exception {
        try (InputStream in = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            Assertions.assertEquals((long)4087L, (long)IOUtils.skip((InputStream)in, (long)4087L));
            Assertions.assertEquals((long)10L, (long)IOUtils.skip((InputStream)in, (long)20L));
            Assertions.assertEquals((long)0L, (long)IOUtils.skip((InputStream)in, (long)10L));
        }
    }

    @Test
    public void testSkip_ReadableByteChannel() throws Exception {
        FileInputStream fileInputStream = new FileInputStream(this.testFile);
        FileChannel fileChannel = fileInputStream.getChannel();
        try {
            Assertions.assertEquals((long)4087L, (long)IOUtils.skip((ReadableByteChannel)fileChannel, (long)4087L));
            Assertions.assertEquals((long)10L, (long)IOUtils.skip((ReadableByteChannel)fileChannel, (long)20L));
            Assertions.assertEquals((long)0L, (long)IOUtils.skip((ReadableByteChannel)fileChannel, (long)10L));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable[])new Closeable[]{fileChannel, fileInputStream});
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{fileChannel, fileInputStream});
    }

    @Test
    public void testSkipFully_InputStream() throws Exception {
        int size = 1027;
        try (ByteArrayInputStream input = new ByteArrayInputStream(new byte[1027]);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> IOUtils.skipFully((InputStream)input, (long)-1L), (String)"Should have failed with IllegalArgumentException");
            IOUtils.skipFully((InputStream)input, (long)0L);
            IOUtils.skipFully((InputStream)input, (long)1026L);
            Assertions.assertThrows(IOException.class, () -> IOUtils.skipFully((InputStream)input, (long)2L), (String)"Should have failed with IOException");
        }
    }

    @Test
    public void testSkipFully_InputStream_Buffer_New_bytes() throws Exception {
        int size = 1027;
        Supplier<byte[]> bas = () -> new byte[1027];
        try (ByteArrayInputStream input = new ByteArrayInputStream(new byte[1027]);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> IOUtils.skipFully((InputStream)input, (long)-1L, (Supplier)bas), (String)"Should have failed with IllegalArgumentException");
            IOUtils.skipFully((InputStream)input, (long)0L, bas);
            IOUtils.skipFully((InputStream)input, (long)1026L, bas);
            Assertions.assertThrows(IOException.class, () -> IOUtils.skipFully((InputStream)input, (long)2L, (Supplier)bas), (String)"Should have failed with IOException");
        }
    }

    @Test
    public void testSkipFully_InputStream_Buffer_Reuse_bytes() throws Exception {
        int size = 1027;
        byte[] ba = new byte[1027];
        Supplier<byte[]> bas = () -> ba;
        try (ByteArrayInputStream input = new ByteArrayInputStream(new byte[1027]);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> IOUtils.skipFully((InputStream)input, (long)-1L, (Supplier)bas), (String)"Should have failed with IllegalArgumentException");
            IOUtils.skipFully((InputStream)input, (long)0L, bas);
            IOUtils.skipFully((InputStream)input, (long)1026L, bas);
            Assertions.assertThrows(IOException.class, () -> IOUtils.skipFully((InputStream)input, (long)2L, (Supplier)bas), (String)"Should have failed with IOException");
        }
    }

    @Test
    public void testSkipFully_InputStream_Buffer_Reuse_ThreadLocal() throws Exception {
        int size = 1027;
        ThreadLocal<byte[]> tl = ThreadLocal.withInitial(() -> new byte[1027]);
        try (ByteArrayInputStream input = new ByteArrayInputStream(new byte[1027]);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> IOUtils.skipFully((InputStream)input, (long)-1L, tl::get), (String)"Should have failed with IllegalArgumentException");
            IOUtils.skipFully((InputStream)input, (long)0L, tl::get);
            IOUtils.skipFully((InputStream)input, (long)1026L, tl::get);
            Assertions.assertThrows(IOException.class, () -> IOUtils.skipFully((InputStream)input, (long)2L, tl::get), (String)"Should have failed with IOException");
        }
    }

    @Test
    public void testSkipFully_ReadableByteChannel() throws Exception {
        FileInputStream fileInputStream = new FileInputStream(this.testFile);
        FileChannel fileChannel = fileInputStream.getChannel();
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> IOUtils.skipFully((ReadableByteChannel)fileChannel, (long)-1L), (String)"Should have failed with IllegalArgumentException");
            IOUtils.skipFully((ReadableByteChannel)fileChannel, (long)0L);
            IOUtils.skipFully((ReadableByteChannel)fileChannel, (long)4096L);
            Assertions.assertThrows(IOException.class, () -> IOUtils.skipFully((ReadableByteChannel)fileChannel, (long)2L), (String)"Should have failed with IOException");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable[])new Closeable[]{fileChannel, fileInputStream});
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{fileChannel, fileInputStream});
    }

    @Test
    public void testSkipFully_Reader() throws Exception {
        int size = 1027;
        try (CharArrayReader input = new CharArrayReader(new char[1027]);){
            IOUtils.skipFully((Reader)input, (long)0L);
            IOUtils.skipFully((Reader)input, (long)1024L);
            Assertions.assertThrows(IllegalArgumentException.class, () -> IOUtils.skipFully((Reader)input, (long)-1L), (String)"Should have failed with IllegalArgumentException");
            Assertions.assertThrows(IOException.class, () -> IOUtils.skipFully((Reader)input, (long)5L), (String)"Should have failed with IOException");
        }
    }

    @Test
    public void testStringToOutputStream() throws Exception {
        String str;
        File destination = TestUtils.newFile(this.temporaryFolder, "copy5.txt");
        try (BufferedReader fin = Files.newBufferedReader(this.testFilePath);){
            str = IOUtils.toString((Reader)fin);
        }
        try (OutputStream fout = Files.newOutputStream(destination.toPath(), new OpenOption[0]);){
            CopyUtils.copy((String)str, (OutputStream)fout);
            TestUtils.checkFile(destination, this.testFile);
            TestUtils.checkWrite(fout);
        }
        TestUtils.deleteFile(destination);
    }

    @Test
    public void testToBufferedInputStream_InputStream() throws Exception {
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            InputStream in = IOUtils.toBufferedInputStream((InputStream)fin);
            byte[] out = IOUtils.toByteArray((InputStream)in);
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((int)0, (int)fin.available(), (String)"Not all bytes were read");
            Assertions.assertEquals((int)4097, (int)out.length, (String)"Wrong output size");
            TestUtils.assertEqualContent(out, this.testFile);
        }
    }

    @Test
    public void testToBufferedInputStreamWithBufferSize_InputStream() throws Exception {
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            InputStream in = IOUtils.toBufferedInputStream((InputStream)fin, (int)2048);
            byte[] out = IOUtils.toByteArray((InputStream)in);
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((int)0, (int)fin.available(), (String)"Not all bytes were read");
            Assertions.assertEquals((int)4097, (int)out.length, (String)"Wrong output size");
            TestUtils.assertEqualContent(out, this.testFile);
        }
    }

    @Test
    public void testToByteArray_InputStream() throws Exception {
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            byte[] out = IOUtils.toByteArray((InputStream)fin);
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((int)0, (int)fin.available(), (String)"Not all bytes were read");
            Assertions.assertEquals((int)4097, (int)out.length, (String)"Wrong output size");
            TestUtils.assertEqualContent(out, this.testFile);
        }
    }

    @Test
    @Disabled(value="Disable by default as it uses too much memory and can cause builds to fail.")
    public void testToByteArray_InputStream_LongerThanIntegerMaxValue() throws Exception {
        CircularInputStream cin = new CircularInputStream(IOUtils.byteArray(), 0x80000000L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> IOUtils.toByteArray((InputStream)cin));
    }

    @Test
    public void testToByteArray_InputStream_NegativeSize() throws Exception {
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            IllegalArgumentException exc = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> IOUtils.toByteArray((InputStream)fin, (int)-1), (String)"Should have failed with IllegalArgumentException");
            Assertions.assertTrue((boolean)exc.getMessage().startsWith("Size must be equal or greater than zero"), (String)"Exception message does not start with \"Size must be equal or greater than zero\"");
        }
    }

    @Test
    public void testToByteArray_InputStream_Size() throws Exception {
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            byte[] out = IOUtils.toByteArray((InputStream)fin, (long)this.testFile.length());
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((int)0, (int)fin.available(), (String)"Not all bytes were read");
            Assertions.assertEquals((int)4097, (int)out.length, (String)("Wrong output size: out.length=" + out.length + "!=" + 4097));
            TestUtils.assertEqualContent(out, this.testFile);
        }
    }

    @Test
    public void testToByteArray_InputStream_SizeIllegal() throws Exception {
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            IOException exc = (IOException)Assertions.assertThrows(IOException.class, () -> IOUtils.toByteArray((InputStream)fin, (long)(this.testFile.length() + 1L)), (String)"Should have failed with IOException");
            Assertions.assertTrue((boolean)exc.getMessage().startsWith("Unexpected read size"), (String)"Exception message does not start with \"Unexpected read size\"");
        }
    }

    @Test
    public void testToByteArray_InputStream_SizeLong() throws Exception {
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            IllegalArgumentException exc = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> IOUtils.toByteArray((InputStream)fin, (long)0x80000000L), (String)"Should have failed with IllegalArgumentException");
            Assertions.assertTrue((boolean)exc.getMessage().startsWith("Size cannot be greater than Integer max value"), (String)"Exception message does not start with \"Size cannot be greater than Integer max value\"");
        }
    }

    @Test
    public void testToByteArray_InputStream_SizeOne() throws Exception {
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            byte[] out = IOUtils.toByteArray((InputStream)fin, (int)1);
            Assertions.assertNotNull((Object)out, (String)"Out cannot be null");
            Assertions.assertEquals((int)1, (int)out.length, (String)"Out length must be 1");
        }
    }

    @Test
    public void testToByteArray_InputStream_SizeZero() throws Exception {
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            byte[] out = IOUtils.toByteArray((InputStream)fin, (int)0);
            Assertions.assertNotNull((Object)out, (String)"Out cannot be null");
            Assertions.assertEquals((int)0, (int)out.length, (String)"Out length must be 0");
        }
    }

    @Test
    public void testToByteArray_Reader() throws IOException {
        String charsetName = UTF_8;
        byte[] expected = charsetName.getBytes(charsetName);
        byte[] actual = IOUtils.toByteArray((Reader)new InputStreamReader(new ByteArrayInputStream(expected)));
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        actual = IOUtils.toByteArray((Reader)new InputStreamReader(new ByteArrayInputStream(expected)), (String)charsetName);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testToByteArray_String() throws Exception {
        try (BufferedReader fin = Files.newBufferedReader(this.testFilePath);){
            String str = IOUtils.toString((Reader)fin);
            byte[] out = IOUtils.toByteArray((String)str);
            this.assertEqualContent(str.getBytes(), out);
        }
    }

    @Test
    public void testToByteArray_URI() throws Exception {
        URI url = this.testFile.toURI();
        byte[] actual = IOUtils.toByteArray((URI)url);
        Assertions.assertEquals((int)4097, (int)actual.length);
    }

    @Test
    public void testToByteArray_URL() throws Exception {
        URL url = this.testFile.toURI().toURL();
        byte[] actual = IOUtils.toByteArray((URL)url);
        Assertions.assertEquals((int)4097, (int)actual.length);
    }

    @Test
    public void testToByteArray_URLConnection() throws Exception {
        byte[] actual;
        try (CloseableURLConnection urlConnection = CloseableURLConnection.open((URI)this.testFile.toURI());){
            actual = IOUtils.toByteArray((URLConnection)urlConnection);
        }
        Assertions.assertEquals((int)4097, (int)actual.length);
    }

    @Test
    public void testToCharArray_InputStream() throws Exception {
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            char[] out = IOUtils.toCharArray((InputStream)fin);
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((int)0, (int)fin.available(), (String)"Not all chars were read");
            Assertions.assertEquals((int)4097, (int)out.length, (String)"Wrong output size");
            TestUtils.assertEqualContent(out, this.testFile);
        }
    }

    @Test
    public void testToCharArray_InputStream_CharsetName() throws Exception {
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            char[] out = IOUtils.toCharArray((InputStream)fin, (String)UTF_8);
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((int)0, (int)fin.available(), (String)"Not all chars were read");
            Assertions.assertEquals((int)4097, (int)out.length, (String)"Wrong output size");
            TestUtils.assertEqualContent(out, this.testFile);
        }
    }

    @Test
    public void testToCharArray_Reader() throws Exception {
        try (BufferedReader fr = Files.newBufferedReader(this.testFilePath);){
            char[] out = IOUtils.toCharArray((Reader)fr);
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((int)4097, (int)out.length, (String)"Wrong output size");
            TestUtils.assertEqualContent(out, this.testFile);
        }
    }

    @Test
    public void testToInputStream_CharSequence() throws Exception {
        StringBuilder csq = new StringBuilder("Abc123Xyz!");
        InputStream inStream = IOUtils.toInputStream((CharSequence)csq);
        byte[] bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent(csq.toString().getBytes(), bytes);
        inStream = IOUtils.toInputStream((CharSequence)csq, (String)null);
        bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent(csq.toString().getBytes(), bytes);
        inStream = IOUtils.toInputStream((CharSequence)csq, (String)UTF_8);
        bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent(csq.toString().getBytes(StandardCharsets.UTF_8), bytes);
    }

    @Test
    public void testToInputStream_String() throws Exception {
        String str = "Abc123Xyz!";
        InputStream inStream = IOUtils.toInputStream((String)"Abc123Xyz!");
        byte[] bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent("Abc123Xyz!".getBytes(), bytes);
        inStream = IOUtils.toInputStream((String)"Abc123Xyz!", (String)null);
        bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent("Abc123Xyz!".getBytes(), bytes);
        inStream = IOUtils.toInputStream((String)"Abc123Xyz!", (String)UTF_8);
        bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent("Abc123Xyz!".getBytes(StandardCharsets.UTF_8), bytes);
    }

    @Test
    public void testToString_ByteArray() throws Exception {
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            byte[] in = IOUtils.toByteArray((InputStream)fin);
            String str = IOUtils.toString((byte[])in);
            this.assertEqualContent(in, str.getBytes());
        }
    }

    @Test
    public void testToString_InputStream() throws Exception {
        try (InputStream fin = Files.newInputStream(this.testFilePath, new OpenOption[0]);){
            String out = IOUtils.toString((InputStream)fin);
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((int)0, (int)fin.available(), (String)"Not all bytes were read");
            Assertions.assertEquals((int)4097, (int)out.length(), (String)"Wrong output size");
        }
    }

    @Test
    public void testToString_InputStreamSupplier() throws Exception {
        String out = IOUtils.toString(() -> Files.newInputStream(this.testFilePath, new OpenOption[0]), (Charset)Charset.defaultCharset());
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((int)4097, (int)out.length(), (String)"Wrong output size");
        Assertions.assertNull((Object)IOUtils.toString(null, (Charset)Charset.defaultCharset(), () -> null));
        Assertions.assertNull((Object)IOUtils.toString(() -> null, (Charset)Charset.defaultCharset(), () -> null));
        Assertions.assertEquals((Object)"A", (Object)IOUtils.toString(null, (Charset)Charset.defaultCharset(), () -> "A"));
    }

    @Test
    public void testToString_Reader() throws Exception {
        try (BufferedReader fin = Files.newBufferedReader(this.testFilePath);){
            String out = IOUtils.toString((Reader)fin);
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((int)4097, (int)out.length(), (String)"Wrong output size");
        }
    }

    @Test
    public void testToString_URI() throws Exception {
        URI url = this.testFile.toURI();
        String out = IOUtils.toString((URI)url);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((int)4097, (int)out.length(), (String)"Wrong output size");
    }

    private void testToString_URI(String encoding) throws Exception {
        URI uri = this.testFile.toURI();
        String out = IOUtils.toString((URI)uri, (String)encoding);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((int)4097, (int)out.length(), (String)"Wrong output size");
    }

    @Test
    public void testToString_URI_CharsetName() throws Exception {
        this.testToString_URI(StandardCharsets.US_ASCII.name());
    }

    @Test
    public void testToString_URI_CharsetNameNull() throws Exception {
        this.testToString_URI(null);
    }

    @Test
    public void testToString_URL() throws Exception {
        URL url = this.testFile.toURI().toURL();
        String out = IOUtils.toString((URL)url);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((int)4097, (int)out.length(), (String)"Wrong output size");
    }

    private void testToString_URL(String encoding) throws Exception {
        URL url = this.testFile.toURI().toURL();
        String out = IOUtils.toString((URL)url, (String)encoding);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((int)4097, (int)out.length(), (String)"Wrong output size");
    }

    @Test
    public void testToString_URL_CharsetName() throws Exception {
        this.testToString_URL(StandardCharsets.US_ASCII.name());
    }

    @Test
    public void testToString_URL_CharsetNameNull() throws Exception {
        this.testToString_URL(null);
    }

    @Test
    public void testWriteBigString() throws IOException {
        String data;
        int repeat = Integer.getInteger("testBigString", 3000000);
        try {
            data = StringUtils.repeat((String)"\ud83d", (int)repeat);
        }
        catch (OutOfMemoryError e) {
            System.err.printf("Don't fail the test if we cannot build the fixture, just log, fixture size = %,d%n.", repeat);
            e.printStackTrace();
            return;
        }
        try (CountingOutputStream os = new CountingOutputStream((OutputStream)NullOutputStream.INSTANCE);){
            IOUtils.write((String)data, (OutputStream)os, (Charset)StandardCharsets.UTF_8);
            Assertions.assertEquals((long)repeat, (long)os.getByteCount());
        }
    }

    @Test
    public void testWriteLines() throws IOException {
        String[] data = new String[]{"The", "quick"};
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.writeLines(Arrays.asList(data), (String)"\n", (OutputStream)out, (String)StandardCharsets.UTF_16.name());
        String result = new String(out.toByteArray(), StandardCharsets.UTF_16);
        Assertions.assertEquals((Object)"The\nquick\n", (Object)result);
    }

    @Test
    public void testWriteLittleString() throws IOException {
        String data = "\ud83d";
        for (int i = 0; i < 1000000; ++i) {
            try (CountingOutputStream os = new CountingOutputStream((OutputStream)NullOutputStream.INSTANCE);){
                IOUtils.write((String)"\ud83d", (OutputStream)os, (Charset)StandardCharsets.UTF_8);
                Assertions.assertEquals((long)"\ud83d".length(), (long)os.getByteCount());
                continue;
            }
        }
    }

    private static /* synthetic */ void lambda$testCloseQuietly_AllCloseableIOException$29(Closeable closeable) throws Throwable {
        IOUtils.closeQuietly(Stream.of(closeable, null, closeable));
    }

    private static /* synthetic */ void lambda$testCloseQuietly_AllCloseableIOException$28(Closeable closeable) throws Throwable {
        IOUtils.closeQuietly(Arrays.asList(closeable, null, closeable));
    }

    private static /* synthetic */ void lambda$testCloseQuietly_AllCloseableIOException$27(Closeable closeable) throws Throwable {
        IOUtils.closeQuietly((Closeable[])new Closeable[]{closeable, null, closeable});
    }
}

