/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileUtilsCopyToFileTest {
    @TempDir
    public File temporaryFolder;
    private File testFile;
    private byte[] testData;

    @BeforeEach
    public void setUp() throws Exception {
        this.testFile = new File(this.temporaryFolder, "file1-test.txt");
        if (!this.testFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile + " as the parent directory does not exist");
        }
        this.testData = TestUtils.generateTestData(1024L);
    }

    @Test
    public void testCopyInputStreamToFile() throws IOException {
        try (CheckingInputStream inputStream = new CheckingInputStream(this.testData);){
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)this.testFile);
            Assertions.assertTrue((boolean)inputStream.isClosed(), (String)"inputStream should be closed");
        }
    }

    @Test
    public void testCopyToFile() throws IOException {
        try (CheckingInputStream inputStream = new CheckingInputStream(this.testData);){
            FileUtils.copyToFile((InputStream)inputStream, (File)this.testFile);
            Assertions.assertFalse((boolean)inputStream.isClosed(), (String)"inputStream should NOT be closed");
        }
    }

    private final class CheckingInputStream
    extends ByteArrayInputStream {
        private boolean closed;

        public CheckingInputStream(byte[] data) {
            super(data);
            this.closed = false;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

