/*
 * Decompiled with CFR 0.152.
 */
package rainbowPackage;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.paint.Color;

public class Rainbow3DController
implements Initializable {
    int step = 50;
    int mode = 1;
    public final int LEFT_ISO = 0;
    public final int CENTER_ISO = 1;
    public final int RIGHT_ISO = 2;
    public float ySkew = 1.0f;
    float y2dSkew = 1.0f;
    Surface3D surface = new Surface3D(50, 50, 150, -300, 300);
    public int originX = 0;
    public int originY = 0;
    GraphicsContext gc = null;
    Rainbow3DController rainbow3DController = null;
    @FXML
    private Canvas canvas3d;
    @FXML
    private Button modeLeftBtn;
    @FXML
    private Button modeCenterBtn;
    @FXML
    private Button modeRightBtn;
    @FXML
    private Button leftBtn;
    @FXML
    private Button rightBtn;
    @FXML
    private Button upBtn;
    @FXML
    private Button downBtn;
    @FXML
    private Button yPlusBtn;
    @FXML
    private Button yMinusBtn;
    @FXML
    private Button twoDYPlusBtn;
    @FXML
    private Button zoomPlusBtn;
    @FXML
    private Button zoomMinusBtn;

    public void setTransformMode(int mode) {
        this.mode = mode;
    }

    public Point2D transform3D(Point3D point3D) throws Exception {
        switch (this.mode) {
            case 0: {
                return new Point2D(point3D.x + point3D.z, (int)(((float)(-point3D.y) * this.y2dSkew + (float)point3D.z) * this.ySkew));
            }
            case 1: {
                return new Point2D(point3D.x + point3D.z, (int)(((float)(-point3D.y) * this.y2dSkew + (float)point3D.z - (float)point3D.x) * this.ySkew));
            }
            case 2: {
                return new Point2D(point3D.x - point3D.z, (int)(((float)(-point3D.y) * this.y2dSkew + (float)point3D.z) * this.ySkew));
            }
        }
        throw new Exception("Invalid Transformation Mode! [" + this.mode + "]?");
    }

    private void setElevationColor(int y1, int y2) {
        int yAvg = (y1 + y2) / 2;
        if (yAvg > -100 && yAvg < -10) {
            this.gc.setStroke(Color.DARKBLUE);
        }
        if (yAvg > -10 && yAvg < -2) {
            this.gc.setStroke(Color.BLUE);
        }
        if (yAvg > -2 && yAvg < 0) {
            this.gc.setStroke(Color.AQUAMARINE);
        }
        if (yAvg > 0 && yAvg < 10) {
            this.gc.setStroke(Color.GREEN);
        }
        if (yAvg > 10 && yAvg < 15) {
            this.gc.setStroke(Color.GRAY);
        }
        if (yAvg > 15 && yAvg < 20) {
            this.gc.setStroke(Color.WHITE);
        }
    }

    public void draw2DShapes() {
        this.gc.setLineWidth(1.0);
        this.gc.setFill(Color.BLACK);
        this.gc.fillRect(0.0, 0.0, this.canvas3d.getWidth(), this.canvas3d.getHeight());
        int xs = this.surface.xSquareSize;
        int ys = this.surface.ySquareSize;
        this.gc.setStroke(Color.GREEN);
        int y = 0;
        while (y < this.surface.yGridSize) {
            int x = 0;
            while (x < this.surface.xGridSize) {
                try {
                    Point2D point2;
                    Point2D point1;
                    Point3D point2_3D;
                    Point3D point1_3D;
                    if (x < this.surface.xGridSize - 1) {
                        point1_3D = new Point3D(x * xs, (int)((float)this.surface.getElevationAvg(x, y) * this.ySkew), y * ys);
                        point2_3D = new Point3D((x + 1) * xs, (int)((float)this.surface.getElevationAvg(x + 1, y) * this.ySkew), y * ys);
                        point1 = this.transform3D(point1_3D);
                        point2 = this.transform3D(point2_3D);
                        this.setElevationColor(point1_3D.y, point2_3D.y);
                        this.gc.strokeLine(point1.x + this.originX, point1.y + this.originY, point2.x + this.originX, point2.y + this.originY);
                    }
                    if (y < this.surface.yGridSize - 1) {
                        point1_3D = new Point3D(x * xs, (int)((float)this.surface.getElevationAvg(x, y) * this.ySkew), y * ys);
                        point2_3D = new Point3D(x * xs, (int)((float)this.surface.getElevationAvg(x, y + 1) * this.ySkew), (y + 1) * ys);
                        point1 = this.transform3D(point1_3D);
                        point2 = this.transform3D(point2_3D);
                        this.setElevationColor(point1_3D.y, point2_3D.y);
                        this.gc.strokeLine(point1.x + this.originX, point1.y + this.originY, point2.x + this.originX, point2.y + this.originY);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++x;
            }
            ++y;
        }
        this.gc.stroke();
    }

    @FXML
    void doModeLeft(ActionEvent event) {
        this.mode = 0;
        this.draw2DShapes();
    }

    @FXML
    void doModeCenter(ActionEvent event) {
        this.mode = 1;
        this.draw2DShapes();
    }

    @FXML
    void doModeRight(ActionEvent event) {
        this.mode = 2;
        this.draw2DShapes();
    }

    @FXML
    void up(ActionEvent event) {
        this.originY -= this.step;
        this.draw2DShapes();
    }

    @FXML
    void down(ActionEvent event) {
        this.originY += this.step;
        this.draw2DShapes();
    }

    @FXML
    void left(ActionEvent event) {
        this.originX -= this.step;
        this.draw2DShapes();
    }

    @FXML
    void right(ActionEvent event) {
        this.originX += this.step;
        this.draw2DShapes();
    }

    @FXML
    void yMinus(ActionEvent event) {
        this.ySkew += 0.1f;
        if (this.ySkew == 0.0f) {
            this.ySkew = 0.1f;
        }
        this.draw2DShapes();
    }

    @FXML
    void yPlus(ActionEvent event) {
        this.ySkew -= 0.1f;
        if (this.ySkew == 0.0f) {
            this.ySkew = -0.1f;
        }
        this.draw2DShapes();
    }

    @FXML
    void twoDYPlus(ActionEvent event) {
        this.y2dSkew += 0.1f;
        this.draw2DShapes();
    }

    @FXML
    void zoomMinus(ActionEvent event) {
        --this.surface.xSquareSize;
        --this.surface.ySquareSize;
        if (this.surface.xSquareSize <= 0) {
            this.surface.xSquareSize = 1;
        }
        if (this.surface.ySquareSize <= 0) {
            this.surface.ySquareSize = 1;
        }
        this.draw2DShapes();
    }

    @FXML
    void zoomPlus(ActionEvent event) {
        ++this.surface.xSquareSize;
        ++this.surface.ySquareSize;
        this.draw2DShapes();
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        assert (this.modeLeftBtn != null) : "fx:id=\"modeLeftBtn\" was not injected: check your FXML file 'simple3d.fxml'.";
        assert (this.modeCenterBtn != null) : "fx:id=\"modeCenterBtn\" was not injected: check your FXML file 'simple3d.fxml'.";
        assert (this.modeRightBtn != null) : "fx:id=\"modeRightBtn\" was not injected: check your FXML file 'simple3d.fxml'.";
        assert (this.leftBtn != null) : "fx:id=\"leftBtn\" was not injected: check your FXML file 'simple3d.fxml'.";
        assert (this.rightBtn != null) : "fx:id=\"rightBtn\" was not injected: check your FXML file 'simple3d.fxml'.";
        assert (this.upBtn != null) : "fx:id=\"upBtn\" was not injected: check your FXML file 'simple3d.fxml'.";
        assert (this.downBtn != null) : "fx:id=\"downBtn\" was not injected: check your FXML file 'simple3d.fxml'.";
        assert (this.yPlusBtn != null) : "fx:id=\"yPlusBtn\" was not injected: check your FXML file 'simple3d.fxml'.";
        assert (this.yMinusBtn != null) : "fx:id=\"yMinusBtn\" was not injected: check your FXML file 'simple3d.fxml'.";
        assert (this.twoDYPlusBtn != null) : "fx:id=\"twoDYPlusBtn\" was not injected: check your FXML file 'simple3d.fxml'.";
        assert (this.zoomPlusBtn != null) : "fx:id=\"zoomPlusBtn\" was not injected: check your FXML file 'simple3d.fxml'.";
        assert (this.zoomMinusBtn != null) : "fx:id=\"zoomMinusBtn\" was not injected: check your FXML file 'simple3d.fxml'.";
        this.gc = this.canvas3d.getGraphicsContext2D();
        this.draw2DShapes();
    }

    public class Point2D {
        int x = 0;
        int y = 0;

        public Point2D(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    public class Point3D {
        int x = 0;
        int y = 0;
        int z = 0;

        public Point3D(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public class Surface3D {
        int xSquareSize = 5;
        int ySquareSize = 5;
        int xGridSize;
        int yGridSize;
        int[][] surfaceElevations = null;
        int[][] surfaceElevationsAverage = null;

        public int getElevation(int x, int y) {
            return this.surfaceElevations[y][x];
        }

        public void setElevation(int x, int y, int elevation) {
            this.surfaceElevations[y][x] = elevation;
        }

        public int randomElevation(int minHeight, int maxHeight) {
            return (int)(Math.random() * (double)(maxHeight - minHeight) + (double)minHeight);
        }

        public int getElevationAvg(int x, int y) {
            return this.surfaceElevations[y][x];
        }

        public void setElevationAvg(int x, int y, int elevation) {
            this.surfaceElevationsAverage[y][x] = elevation;
        }

        public int average(int x, int y) {
            int total = this.getElevation(x - 1, y - 1);
            total += this.getElevation(x, y - 1);
            total += this.getElevation(x + 1, y - 1);
            total += this.getElevation(x - 1, y);
            total += this.getElevation(x, y);
            total += this.getElevation(x + 1, y);
            total += this.getElevation(x - 1, y + 1);
            total += this.getElevation(x, y + 1);
            return (total += this.getElevation(x + 1, y + 1)) / 9;
        }

        Surface3D(int xGridSize, int yGridSize, int nRandomHeights, int minHeight, int maxHeight) {
            this.xGridSize = xGridSize;
            this.yGridSize = yGridSize;
            this.surfaceElevations = new int[xGridSize][yGridSize];
            int i = 0;
            while (i < nRandomHeights) {
                int randomX = (int)(Math.random() * (double)(xGridSize - 2) + 1.0);
                int randomY = (int)(Math.random() * (double)(yGridSize - 2) + 1.0);
                this.setElevation(randomX, randomY, this.randomElevation(minHeight, maxHeight));
                ++i;
            }
            this.surfaceElevationsAverage = new int[xGridSize][yGridSize];
            i = 0;
            while (i < 2) {
                int y = 1;
                while (y < yGridSize - 1) {
                    int x = 1;
                    while (x < xGridSize - 1) {
                        this.setElevationAvg(x, y, this.average(x, y));
                        ++x;
                    }
                    ++y;
                }
                this.surfaceElevations = this.surfaceElevationsAverage;
                ++i;
            }
        }
    }
}

