/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.io.serialization.AbstractCloseableListTest;
import org.apache.commons.io.serialization.ClassNameMatcher;
import org.apache.commons.io.serialization.MockSerializedClass;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ValidatingObjectInputStreamTest
extends AbstractCloseableListTest {
    private static final ClassNameMatcher ALWAYS_TRUE = className -> true;
    private MockSerializedClass testObject;
    private InputStream testStream;

    private void assertSerialization(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        MockSerializedClass result = (MockSerializedClass)ois.readObject();
        Assertions.assertEquals((Object)this.testObject, (Object)result);
    }

    @BeforeEach
    public void setupMockSerializedClass() throws IOException {
        this.testObject = new MockSerializedClass(UUID.randomUUID().toString());
        ByteArrayOutputStream bos = this.closeAfterEachTest(new ByteArrayOutputStream());
        ObjectOutputStream oos = this.closeAfterEachTest(new ObjectOutputStream(bos));
        oos.writeObject(this.testObject);
        this.testStream = this.closeAfterEachTest(new ByteArrayInputStream(bos.toByteArray()));
    }

    @Test
    public void testAcceptCustomMatcher() throws Exception {
        this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(ALWAYS_TRUE));
    }

    @Test
    public void testAcceptPattern() throws Exception {
        this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(Pattern.compile(".*MockSerializedClass.*")));
    }

    @Test
    public void testAcceptWildcard() throws Exception {
        this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(new String[]{"org.apache.commons.io.*"}));
    }

    @Test
    public void testCustomInvalidMethod() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            final class CustomVOIS
            extends ValidatingObjectInputStream {
                CustomVOIS(InputStream is) throws IOException {
                    super(is);
                }

                protected void invalidClassNameFound(String className) throws InvalidClassException {
                    throw new RuntimeException("Custom exception");
                }
            }
            this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new CustomVOIS(this.testStream)).reject(new Class[]{Integer.class}));
        });
    }

    @Test
    public void testExceptionIncludesClassName() throws Exception {
        try {
            this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)));
            Assertions.fail((String)"Expected an InvalidClassException");
        }
        catch (InvalidClassException ice) {
            String name = MockSerializedClass.class.getName();
            Assertions.assertTrue((boolean)ice.getMessage().contains(name), (String)("Expecting message to contain " + name));
        }
    }

    @Test
    public void testNoAccept() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream))));
    }

    @Test
    public void testOurTestClassAcceptedFirst() throws Exception {
        this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{MockSerializedClass.class, Integer.class}));
    }

    @Test
    public void testOurTestClassAcceptedFirstWildcard() throws Exception {
        this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(new String[]{"*MockSerializedClass", "*Integer"}));
    }

    @Test
    public void testOurTestClassAcceptedSecond() throws Exception {
        this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{Integer.class, MockSerializedClass.class}));
    }

    @Test
    public void testOurTestClassAcceptedSecondWildcard() throws Exception {
        this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(new String[]{"*Integer", "*MockSerializedClass"}));
    }

    @Test
    public void testOurTestClassNotAccepted() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{Integer.class})));
    }

    @Test
    public void testOurTestClassOnlyAccepted() throws Exception {
        this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{MockSerializedClass.class}));
    }

    @Test
    public void testReject() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{Long.class}).reject(new Class[]{MockSerializedClass.class, Integer.class})));
    }

    @Test
    public void testRejectCustomMatcher() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{MockSerializedClass.class}).reject(ALWAYS_TRUE)));
    }

    @Test
    public void testRejectOnly() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).reject(new Class[]{Integer.class})));
    }

    @Test
    public void testRejectPattern() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{MockSerializedClass.class}).reject(Pattern.compile("org.*"))));
    }

    @Test
    public void testRejectPrecedence() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{MockSerializedClass.class}).reject(new Class[]{MockSerializedClass.class, Integer.class})));
    }

    @Test
    public void testRejectWildcard() {
        Assertions.assertThrows(InvalidClassException.class, () -> this.assertSerialization((ObjectInputStream)this.closeAfterEachTest(new ValidatingObjectInputStream(this.testStream)).accept(new Class[]{MockSerializedClass.class}).reject(new String[]{"org.*"})));
    }
}

