/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.LockableFileWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class LockableFileWriterTest {
    @TempDir
    public File temporaryFolder;
    private File file;
    private File lockDir;
    private File lockFile;
    private File altLockDir;
    private File altLockFile;

    @BeforeEach
    public void setUp() {
        this.file = new File(this.temporaryFolder, "testlockfile");
        this.lockDir = FileUtils.getTempDirectory();
        this.lockFile = new File(this.lockDir, this.file.getName() + ".lck");
        this.altLockDir = this.temporaryFolder;
        this.altLockFile = new File(this.altLockDir, this.file.getName() + ".lck");
    }

    @Test
    public void testAlternateLockDir() throws IOException {
        try (LockableFileWriter lfw1 = new LockableFileWriter(this.file, StandardCharsets.UTF_8, true, this.altLockDir.getAbsolutePath());){
            this.testAlternateLockDir(lfw1);
        }
        Assertions.assertTrue((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.altLockFile.exists());
        lfw1 = ((LockableFileWriter.Builder)((LockableFileWriter.Builder)LockableFileWriter.builder().setFile(this.file)).setCharset(StandardCharsets.UTF_8)).setAppend(true).setLockDirectory(this.altLockDir).get();
        try {
            this.testAlternateLockDir(lfw1);
        }
        finally {
            if (lfw1 != null) {
                lfw1.close();
            }
        }
        Assertions.assertTrue((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.altLockFile.exists());
    }

    private void testAlternateLockDir(LockableFileWriter lfw1) {
        Assertions.assertNotNull((Object)lfw1);
        Assertions.assertTrue((boolean)this.file.exists());
        Assertions.assertTrue((boolean)this.altLockFile.exists());
        try (LockableFileWriter lfw2 = new LockableFileWriter(this.file, StandardCharsets.UTF_8, true, this.altLockDir.getAbsolutePath());){
            Assertions.fail((String)"Somehow able to open a locked file. ");
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            Assertions.assertTrue((boolean)msg.startsWith("Can't write file, lock "), (String)"Exception message does not start correctly. ");
            Assertions.assertTrue((boolean)this.file.exists());
            Assertions.assertTrue((boolean)this.altLockFile.exists());
        }
    }

    @Test
    public void testConstructor_File_directory() {
        Assertions.assertThrows(IOException.class, () -> new LockableFileWriter(this.temporaryFolder));
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testConstructor_File_encoding_badEncoding() {
        Assertions.assertThrows(UnsupportedCharsetException.class, () -> new LockableFileWriter(this.file, "BAD-ENCODE"));
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
        Assertions.assertThrows(UnsupportedCharsetException.class, () -> ((LockableFileWriter.Builder)((LockableFileWriter.Builder)LockableFileWriter.builder().setFile(this.file)).setCharset("BAD-ENCODE")).get());
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testConstructor_File_nullFile() {
        Assertions.assertThrows(NullPointerException.class, () -> new LockableFileWriter((File)null));
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
        Assertions.assertThrows(IllegalStateException.class, () -> LockableFileWriter.builder().get());
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testConstructor_fileName_nullFile() {
        Assertions.assertThrows(NullPointerException.class, () -> new LockableFileWriter((String)null));
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
        Assertions.assertFalse((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testFileLocked() throws IOException {
        try (LockableFileWriter lfw1 = new LockableFileWriter(this.file);){
            String msg;
            Assertions.assertTrue((boolean)this.file.exists());
            Assertions.assertTrue((boolean)this.lockFile.exists());
            try (LockableFileWriter lfw2 = new LockableFileWriter(this.file);){
                Assertions.fail((String)"Somehow able to open a locked file. ");
            }
            catch (IOException ioe) {
                msg = ioe.getMessage();
                Assertions.assertTrue((boolean)msg.startsWith("Can't write file, lock "), (String)"Exception message does not start correctly. ");
                Assertions.assertTrue((boolean)this.file.exists());
                Assertions.assertTrue((boolean)this.lockFile.exists());
            }
            try (LockableFileWriter lfw3 = new LockableFileWriter(this.file);){
                Assertions.fail((String)"Somehow able to open a locked file. ");
            }
            catch (IOException ioe) {
                msg = ioe.getMessage();
                Assertions.assertTrue((boolean)msg.startsWith("Can't write file, lock "), (String)"Exception message does not start correctly. ");
                Assertions.assertTrue((boolean)this.file.exists());
                Assertions.assertTrue((boolean)this.lockFile.exists());
            }
        }
        Assertions.assertTrue((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
    }

    @Test
    public void testFileNotLocked() throws IOException {
        try (LockableFileWriter lfw1 = new LockableFileWriter(this.file);){
            Assertions.assertTrue((boolean)this.file.exists());
            Assertions.assertTrue((boolean)this.lockFile.exists());
        }
        Assertions.assertTrue((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
        try (LockableFileWriter lfw2 = new LockableFileWriter(this.file);){
            Assertions.assertTrue((boolean)this.file.exists());
            Assertions.assertTrue((boolean)this.lockFile.exists());
        }
        Assertions.assertTrue((boolean)this.file.exists());
        Assertions.assertFalse((boolean)this.lockFile.exists());
    }
}

