/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.UnsynchronizedBufferedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UnsynchronizedBufferedInputStreamTest {
    private static final int BUFFER_SIZE = 4096;
    public static final String DATA = StringUtils.repeat((String)"This is a test.", (int)500);
    Path fileName;
    private UnsynchronizedBufferedInputStream is;
    private InputStream isFile;
    byte[] ibuf = new byte[4096];

    private UnsynchronizedBufferedInputStream.Builder builder() {
        return new UnsynchronizedBufferedInputStream.Builder();
    }

    @BeforeEach
    protected void setUp() throws IOException {
        this.fileName = Files.createTempFile(this.getClass().getSimpleName(), ".tst", new FileAttribute[0]);
        Files.write(this.fileName, DATA.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        this.isFile = Files.newInputStream(this.fileName, new OpenOption[0]);
        this.is = ((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream(this.isFile)).get();
    }

    @AfterEach
    protected void tearDown() throws IOException {
        IOUtils.closeQuietly((InputStream)this.is);
        Files.deleteIfExists(this.fileName);
    }

    @Test
    public void test_available() throws IOException {
        Assertions.assertEquals((int)DATA.length(), (int)this.is.available(), (String)"Returned incorrect number of available bytes");
        UnsynchronizedBufferedInputStream bis = ((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream((InputStream)new ByteArrayInputStream(new byte[]{72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100}))).get();
        int available = bis.available();
        bis.close();
        Assertions.assertTrue((available != 0 ? 1 : 0) != 0);
        Assertions.assertThrows(IOException.class, () -> bis.available(), (String)"Expected test to throw IOE.");
    }

    @Test
    public void test_close() throws IOException {
        ((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream(this.isFile)).get().close();
        try (InputStream in = new InputStream(){
            Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }

            @Override
            public int read() {
                return 1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] buf, int offset, int length) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return 1;
            }
        };){
            UnsynchronizedBufferedInputStream bufin = ((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream(in)).get();
            Thread thread = new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                    bufin.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            thread.start();
            Assertions.assertThrows(IOException.class, () -> bufin.read(new byte[100], 0, 99), (String)"Should throw IOException");
        }
    }

    @Test
    public void test_ConstructorLjava_io_InputStream() {
        Assertions.assertThrows(NullPointerException.class, () -> ((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream(null)).get());
    }

    @Test
    public void test_ConstructorLjava_io_InputStreamI() throws IOException {
        Assertions.assertThrows(NullPointerException.class, () -> ((UnsynchronizedBufferedInputStream.Builder)((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream(null)).setBufferSize(1)).get());
        this.is = ((UnsynchronizedBufferedInputStream.Builder)((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream(this.isFile)).setBufferSize(DATA.length())).get();
        this.is.read();
        this.isFile.close();
        this.is.skip((long)(DATA.length() - 2));
        this.is.read();
        Assertions.assertThrows(IOException.class, () -> this.is.read());
        Assertions.assertThrows(NullPointerException.class, () -> ((UnsynchronizedBufferedInputStream.Builder)((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream(null)).setBufferSize(100)).get());
        Assertions.assertThrows(NullPointerException.class, () -> this.builder().setInputStream(null));
    }

    @Test
    public void test_markI() throws IOException {
        byte[] buf1 = new byte[100];
        byte[] buf2 = new byte[100];
        this.is.skip(3000L);
        this.is.mark(1000);
        this.is.read(buf1, 0, buf1.length);
        this.is.reset();
        this.is.read(buf2, 0, buf2.length);
        this.is.reset();
        Assertions.assertTrue((boolean)new String(buf1, 0, buf1.length).equals(new String(buf2, 0, buf2.length)), (String)"Failed to mark correct position");
        byte[] bytes = new byte[256];
        for (int i = 0; i < 256; ++i) {
            bytes[i] = (byte)i;
        }
        UnsynchronizedBufferedInputStream in = ((UnsynchronizedBufferedInputStream.Builder)((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream((InputStream)new ByteArrayInputStream(bytes))).setBufferSize(12)).get();
        in.skip(6L);
        in.mark(14);
        in.read(new byte[14], 0, 14);
        in.reset();
        Assertions.assertTrue((in.read() == 6 && in.read() == 7 ? 1 : 0) != 0, (String)"Wrong bytes");
        in = ((UnsynchronizedBufferedInputStream.Builder)((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream((InputStream)new ByteArrayInputStream(bytes))).setBufferSize(12)).get();
        in.skip(6L);
        in.mark(8);
        in.skip(7L);
        in.reset();
        Assertions.assertTrue((in.read() == 6 && in.read() == 7 ? 1 : 0) != 0, (String)"Wrong bytes 2");
        UnsynchronizedBufferedInputStream buf = ((UnsynchronizedBufferedInputStream.Builder)((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2, 3, 4}))).setBufferSize(2)).get();
        buf.mark(3);
        bytes = new byte[3];
        int result = buf.read(bytes);
        Assertions.assertEquals((int)3, (int)result);
        Assertions.assertEquals((int)0, (int)bytes[0], (String)"Assert 0:");
        Assertions.assertEquals((int)1, (int)bytes[1], (String)"Assert 1:");
        Assertions.assertEquals((int)2, (int)bytes[2], (String)"Assert 2:");
        Assertions.assertEquals((int)3, (int)buf.read(), (String)"Assert 3:");
        buf = ((UnsynchronizedBufferedInputStream.Builder)((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2, 3, 4}))).setBufferSize(2)).get();
        buf.mark(3);
        bytes = new byte[4];
        result = buf.read(bytes);
        Assertions.assertEquals((int)4, (int)result);
        Assertions.assertEquals((int)0, (int)bytes[0], (String)"Assert 4:");
        Assertions.assertEquals((int)1, (int)bytes[1], (String)"Assert 5:");
        Assertions.assertEquals((int)2, (int)bytes[2], (String)"Assert 6:");
        Assertions.assertEquals((int)3, (int)bytes[3], (String)"Assert 7:");
        Assertions.assertEquals((int)4, (int)buf.read(), (String)"Assert 8:");
        Assertions.assertEquals((int)-1, (int)buf.read(), (String)"Assert 9:");
        buf = ((UnsynchronizedBufferedInputStream.Builder)((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2, 3, 4}))).setBufferSize(2)).get();
        buf.mark(Integer.MAX_VALUE);
        buf.read();
        buf.close();
    }

    @Test
    public void test_markSupported() {
        Assertions.assertTrue((boolean)this.is.markSupported(), (String)"markSupported returned incorrect value");
    }

    @Test
    public void test_read() throws IOException {
        InputStreamReader isr = new InputStreamReader((InputStream)this.is);
        int c = isr.read();
        Assertions.assertEquals((int)DATA.charAt(0), (int)c, (String)"read returned incorrect char");
        byte[] bytes = new byte[256];
        for (int i = 0; i < 256; ++i) {
            bytes[i] = (byte)i;
        }
        UnsynchronizedBufferedInputStream in = ((UnsynchronizedBufferedInputStream.Builder)((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream((InputStream)new ByteArrayInputStream(bytes))).setBufferSize(12)).get();
        Assertions.assertEquals((int)0, (int)in.read(), (String)"Wrong initial byte");
        byte[] buf = new byte[14];
        in.read(buf, 0, 14);
        Assertions.assertTrue((boolean)new String(buf, 0, 14).equals(new String(bytes, 1, 14)), (String)"Wrong block read data");
        Assertions.assertEquals((int)15, (int)in.read(), (String)"Wrong bytes");
    }

    @Test
    public void test_read$BII() throws IOException {
        byte[] buf1 = new byte[100];
        this.is.skip(3000L);
        this.is.mark(1000);
        this.is.read(buf1, 0, buf1.length);
        Assertions.assertTrue((boolean)new String(buf1, 0, buf1.length).equals(DATA.substring(3000, 3100)), (String)"Failed to read correct data");
        try (UnsynchronizedBufferedInputStream bufin = ((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream(new InputStream(){
            int size = 2;
            int pos = 0;
            byte[] contents = new byte[this.size];

            @Override
            public int available() {
                return this.size - this.pos;
            }

            @Override
            public int read() throws IOException {
                if (this.pos >= this.size) {
                    throw new IOException("Read past end of data");
                }
                return this.contents[this.pos++];
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                if (this.pos >= this.size) {
                    throw new IOException("Read past end of data");
                }
                int toRead = len;
                if (toRead > this.available()) {
                    toRead = this.available();
                }
                System.arraycopy(this.contents, this.pos, buf, off, toRead);
                this.pos += toRead;
                return toRead;
            }
        })).get();){
            bufin.read();
            int result = bufin.read(new byte[2], 0, 2);
            Assertions.assertEquals((int)1, (int)result, () -> "Incorrect result: " + result);
        }
    }

    @Test
    public void test_reset() throws IOException {
        byte[] buf1 = new byte[10];
        byte[] buf2 = new byte[10];
        this.is.mark(2000);
        this.is.read(buf1, 0, 10);
        this.is.reset();
        this.is.read(buf2, 0, 10);
        this.is.reset();
        Assertions.assertTrue((boolean)new String(buf1, 0, buf1.length).equals(new String(buf2, 0, buf2.length)), (String)"Reset failed");
        UnsynchronizedBufferedInputStream bIn = ((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream((InputStream)new ByteArrayInputStream("1234567890".getBytes()))).get();
        bIn.mark(10);
        for (int i = 0; i < 11; ++i) {
            bIn.read();
        }
        bIn.reset();
    }

    @Test
    public void test_reset_scenario1() throws IOException {
        byte[] input = "12345678900".getBytes();
        UnsynchronizedBufferedInputStream bufin = ((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream((InputStream)new ByteArrayInputStream(input))).get();
        bufin.read();
        bufin.mark(5);
        bufin.skip(5L);
        bufin.reset();
    }

    @Test
    public void test_reset_scenario2() throws IOException {
        byte[] input = "12345678900".getBytes();
        UnsynchronizedBufferedInputStream bufin = ((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream((InputStream)new ByteArrayInputStream(input))).get();
        bufin.mark(5);
        bufin.skip(6L);
        bufin.reset();
    }

    @Test
    public void test_skip_NullInputStream() throws IOException {
        Assertions.assertThrows(NullPointerException.class, () -> ((UnsynchronizedBufferedInputStream.Builder)((UnsynchronizedBufferedInputStream.Builder)this.builder().setInputStream(null)).setBufferSize(5)).get());
    }

    @Test
    public void test_skipJ() throws IOException {
        byte[] buf1 = new byte[10];
        this.is.mark(2000);
        this.is.skip(1000L);
        this.is.read(buf1, 0, buf1.length);
        this.is.reset();
        Assertions.assertTrue((boolean)new String(buf1, 0, buf1.length).equals(DATA.substring(1000, 1010)), (String)"Failed to skip to correct position");
    }
}

