/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.UnixLineEndingInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnixLineEndingInputStreamTest {
    private String roundtrip(String msg) throws IOException {
        return this.roundtrip(msg, true);
    }

    private String roundtrip(String msg, boolean ensure) throws IOException {
        try (ByteArrayInputStream baos = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));){
            String string;
            try (UnixLineEndingInputStream lf = new UnixLineEndingInputStream((InputStream)baos, ensure);){
                byte[] buf = new byte[100];
                string = new String(buf, 0, lf.read(buf), StandardCharsets.UTF_8);
            }
            return string;
        }
    }

    @Test
    public void testCrAtEnd() throws Exception {
        Assertions.assertEquals((Object)"a\n", (Object)this.roundtrip("a\r"));
    }

    @Test
    public void testCrOnlyEnsureAtEof() throws Exception {
        Assertions.assertEquals((Object)"a\nb\n", (Object)this.roundtrip("a\rb"));
    }

    @Test
    public void testCrOnlyNotAtEof() throws Exception {
        Assertions.assertEquals((Object)"a\nb", (Object)this.roundtrip("a\rb", false));
    }

    @Test
    public void testInTheMiddleOfTheLine() throws Exception {
        Assertions.assertEquals((Object)"a\nbc\n", (Object)this.roundtrip("a\r\nbc"));
    }

    @Test
    public void testMultipleBlankLines() throws Exception {
        Assertions.assertEquals((Object)"a\n\nbc\n", (Object)this.roundtrip("a\r\n\r\nbc"));
    }

    @Test
    public void testRetainLineFeed() throws Exception {
        Assertions.assertEquals((Object)"a\n\n", (Object)this.roundtrip("a\r\n\r\n", false));
        Assertions.assertEquals((Object)"a", (Object)this.roundtrip("a", false));
    }

    @Test
    public void testSimpleString() throws Exception {
        Assertions.assertEquals((Object)"abc\n", (Object)this.roundtrip("abc"));
    }

    @Test
    public void testTwoLinesAtEnd() throws Exception {
        Assertions.assertEquals((Object)"a\n\n", (Object)this.roundtrip("a\r\n\r\n"));
    }
}

