/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProxyInputStreamTest<T extends ProxyInputStream> {
    protected T createFixture() throws IOException {
        return (T)((Object)new ProxyInputStreamFixture(this.createProxySource()));
    }

    protected InputStream createProxySource() {
        return ((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence((CharSequence)"abc")).get();
    }

    protected void testEos(T inputStream) {
    }

    @Test
    public void testRead() throws IOException {
        try (T inputStream = this.createFixture();){
            int found = inputStream.read();
            Assertions.assertEquals((int)97, (int)found);
            found = inputStream.read();
            Assertions.assertEquals((int)98, (int)found);
            found = inputStream.read();
            Assertions.assertEquals((int)99, (int)found);
            found = inputStream.read();
            Assertions.assertEquals((int)-1, (int)found);
            this.testEos(inputStream);
        }
    }

    @Test
    public void testReadArrayAtMiddleFully() throws IOException {
        try (T inputStream = this.createFixture();){
            byte[] dest = new byte[5];
            int found = inputStream.read(dest, 2, 3);
            Assertions.assertEquals((int)3, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 97, 98, 99}, (byte[])dest);
            found = inputStream.read(dest, 2, 3);
            Assertions.assertEquals((int)-1, (int)found);
            this.testEos(inputStream);
        }
    }

    @Test
    public void testReadArrayAtStartFully() throws IOException {
        try (T inputStream = this.createFixture();){
            byte[] dest = new byte[5];
            int found = inputStream.read(dest, 0, 5);
            Assertions.assertEquals((int)3, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{97, 98, 99, 0, 0}, (byte[])dest);
            found = inputStream.read(dest, 0, 5);
            Assertions.assertEquals((int)-1, (int)found);
            this.testEos(inputStream);
        }
    }

    @Test
    public void testReadArrayAtStartPartial() throws IOException {
        try (T inputStream = this.createFixture();){
            byte[] dest = new byte[5];
            int found = inputStream.read(dest, 0, 2);
            Assertions.assertEquals((int)2, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{97, 98, 0, 0, 0}, (byte[])dest);
            Arrays.fill(dest, (byte)0);
            found = inputStream.read(dest, 0, 2);
            Assertions.assertEquals((int)1, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{99, 0, 0, 0, 0}, (byte[])dest);
            found = inputStream.read(dest, 0, 2);
            Assertions.assertEquals((int)-1, (int)found);
            this.testEos(inputStream);
        }
    }

    @Test
    public void testReadArrayFully() throws IOException {
        try (T inputStream = this.createFixture();){
            byte[] dest = new byte[5];
            int found = inputStream.read(dest);
            Assertions.assertEquals((int)3, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{97, 98, 99, 0, 0}, (byte[])dest);
            found = inputStream.read(dest);
            Assertions.assertEquals((int)-1, (int)found);
            this.testEos(inputStream);
        }
    }

    @Test
    public void testReadArrayPartial() throws IOException {
        try (T inputStream = this.createFixture();){
            byte[] dest = new byte[2];
            int found = inputStream.read(dest);
            Assertions.assertEquals((int)2, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{97, 98}, (byte[])dest);
            Arrays.fill(dest, (byte)0);
            found = inputStream.read(dest);
            Assertions.assertEquals((int)1, (int)found);
            Assertions.assertArrayEquals((byte[])new byte[]{99, 0}, (byte[])dest);
            found = inputStream.read(dest);
            Assertions.assertEquals((int)-1, (int)found);
            this.testEos(inputStream);
        }
    }

    @Test
    public void testReadEof() throws Exception {
        ByteArrayInputStream proxy = new ByteArrayInputStream(new byte[2]);
        try (ProxyInputStreamFixture inputStream = new ProxyInputStreamFixture(proxy);){
            Assertions.assertSame((Object)proxy, (Object)inputStream.unwrap());
            int found = inputStream.read();
            Assertions.assertEquals((int)0, (int)found);
            found = inputStream.read();
            Assertions.assertEquals((int)0, (int)found);
            found = inputStream.read();
            Assertions.assertEquals((int)-1, (int)found);
        }
    }

    private static final class ProxyInputStreamFixture
    extends ProxyInputStream {
        public ProxyInputStreamFixture(InputStream proxy) {
            super(proxy);
        }
    }
}

