/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.MarkShieldInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MarkShieldInputStreamTest {
    @Test
    public void testMarkIsNoOpWhenUnderlyingDoesNotSupport() throws IOException {
        try (MarkTestableInputStream in = new MarkTestableInputStream((InputStream)new NullInputStream(64L, false, false));
             MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)((Object)in));){
            msis.mark(1024);
            Assertions.assertEquals((int)0, (int)in.markcount);
            Assertions.assertEquals((int)0, (int)in.readLimit);
        }
    }

    @Test
    public void testMarkIsNoOpWhenUnderlyingSupports() throws IOException {
        try (MarkTestableInputStream in = new MarkTestableInputStream((InputStream)new NullInputStream(64L, true, false));
             MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)((Object)in));){
            msis.mark(1024);
            Assertions.assertEquals((int)0, (int)in.markcount);
            Assertions.assertEquals((int)0, (int)in.readLimit);
        }
    }

    @Test
    public void testMarkSupportedIsFalseWhenUnderlyingFalse() throws IOException {
        try (NullInputStream is = new NullInputStream(64L, false, false);){
            Assertions.assertFalse((boolean)is.markSupported());
            try (MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)is);){
                Assertions.assertFalse((boolean)msis.markSupported());
            }
        }
    }

    @Test
    public void testMarkSupportedIsFalseWhenUnderlyingTrue() throws IOException {
        try (NullInputStream is = new NullInputStream(64L, true, false);){
            Assertions.assertTrue((boolean)is.markSupported());
            try (MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)is);){
                Assertions.assertFalse((boolean)msis.markSupported());
            }
        }
    }

    @Test
    public void testResetThrowsExceptionWhenUnderlyingDoesNotSupport() throws IOException {
        try (MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)new NullInputStream(64L, false, false));){
            Assertions.assertThrows(UnsupportedOperationException.class, () -> ((MarkShieldInputStream)msis).reset());
        }
    }

    @Test
    public void testResetThrowsExceptionWhenUnderlyingSupports() throws IOException {
        try (MarkShieldInputStream msis = new MarkShieldInputStream((InputStream)new NullInputStream(64L, true, false));){
            Assertions.assertThrows(UnsupportedOperationException.class, () -> ((MarkShieldInputStream)msis).reset());
        }
    }

    private static final class MarkTestableInputStream
    extends ProxyInputStream {
        int markcount;
        int readLimit;

        public MarkTestableInputStream(InputStream in) {
            super(in);
        }

        public void mark(int readLimit) {
            ++this.markcount;
            this.readLimit = readLimit;
            super.mark(readLimit);
        }
    }
}

