/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Flushable;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;

public class ClassLoaderObjectInputStreamTest {
    @org.junit.jupiter.api.Test
    public void testExpected() throws Exception {
        Boolean input = Boolean.FALSE;
        ByteArrayInputStream bais = new ByteArrayInputStream(SerializationUtils.serialize((Serializable)input));
        try (ClassLoaderObjectInputStream clois = new ClassLoaderObjectInputStream(this.getClass().getClassLoader(), (InputStream)bais);){
            Object result = clois.readObject();
            Assertions.assertEquals((Object)input, (Object)result);
        }
    }

    @org.junit.jupiter.api.Test
    public void testLong() throws Exception {
        Long input = 123L;
        ByteArrayInputStream bais = new ByteArrayInputStream(SerializationUtils.serialize((Serializable)input));
        try (ClassLoaderObjectInputStream clois = new ClassLoaderObjectInputStream(this.getClass().getClassLoader(), (InputStream)bais);){
            Object result = clois.readObject();
            Assertions.assertEquals((Object)input, (Object)result);
        }
    }

    @org.junit.jupiter.api.Test
    public void testObject1() throws Exception {
        Test input = new Test(123, null);
        ByteArrayInputStream bais = new ByteArrayInputStream(SerializationUtils.serialize((Serializable)input));
        try (ClassLoaderObjectInputStream clois = new ClassLoaderObjectInputStream(this.getClass().getClassLoader(), (InputStream)bais);){
            Object result = clois.readObject();
            Assertions.assertEquals((Object)input, (Object)result);
        }
    }

    @org.junit.jupiter.api.Test
    public void testObject2() throws Exception {
        Test input = new Test(123, 0);
        ByteArrayInputStream bais = new ByteArrayInputStream(SerializationUtils.serialize((Serializable)input));
        try (ClassLoaderObjectInputStream clois = new ClassLoaderObjectInputStream(this.getClass().getClassLoader(), (InputStream)bais);){
            Object result = clois.readObject();
            Assertions.assertEquals((Object)input, (Object)result);
        }
    }

    @org.junit.jupiter.api.Test
    public void testPrimitiveLong() throws Exception {
        long input = 12345L;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeLong(12345L);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ClassLoaderObjectInputStream clois = new ClassLoaderObjectInputStream(this.getClass().getClassLoader(), (InputStream)bais);){
            long result = clois.readLong();
            Assertions.assertEquals((long)12345L, (long)result);
        }
    }

    @org.junit.jupiter.api.Test
    public void testResolveProxyClass() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(SerializationUtils.serialize((Serializable)Boolean.FALSE));
        try (ClassLoaderObjectInputStream clois = new ClassLoaderObjectInputStream(this.getClass().getClassLoader(), (InputStream)bais);){
            String[] interfaces = new String[]{Comparable.class.getName()};
            Class result = clois.resolveProxyClass(interfaces);
            Assertions.assertTrue((boolean)Comparable.class.isAssignableFrom(result), (String)"Assignable");
        }
    }

    @org.junit.jupiter.api.Test
    public void testResolveProxyClassWithMultipleInterfaces() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(SerializationUtils.serialize((Serializable)Boolean.FALSE));
        try (ClassLoaderObjectInputStream clois = new ClassLoaderObjectInputStream(this.getClass().getClassLoader(), (InputStream)bais);){
            String[] interfaces = new String[]{Comparable.class.getName(), Serializable.class.getName(), Runnable.class.getName()};
            Class result = clois.resolveProxyClass(interfaces);
            Assertions.assertTrue((boolean)Comparable.class.isAssignableFrom(result), (String)"Assignable");
            Assertions.assertTrue((boolean)Runnable.class.isAssignableFrom(result), (String)"Assignable");
            Assertions.assertTrue((boolean)Serializable.class.isAssignableFrom(result), (String)"Assignable");
            Assertions.assertFalse((boolean)Flushable.class.isAssignableFrom(result), (String)"Not Assignable");
        }
    }

    private static final class Test
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int i;
        private final Object o;
        private final E e;

        Test(int i, Object o) {
            this.i = i;
            this.e = E.A;
            this.o = o;
        }

        private boolean equalObject(Object other) {
            if (this.o == null) {
                return other == null;
            }
            return this.o.equals(other);
        }

        public boolean equals(Object other) {
            if (other instanceof Test) {
                Test tOther = (Test)other;
                return this.i == tOther.i & this.e == tOther.e & this.equalObject(tOther.o);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static enum E {
        A,
        B,
        C;

    }
}

