/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.TempFile;
import org.apache.commons.io.input.BoundedReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BoundedReaderTest {
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private static final String STRING_END_NO_EOL = "0\n1\n2";
    private static final String STRING_END_EOL = "0\n1\n2\n";
    private final Reader sr = new BufferedReader(new StringReader("01234567890"));
    private final Reader shortReader = new BufferedReader(new StringReader("01"));

    @Test
    public void testCloseTest() throws IOException {
        final AtomicBoolean closed = new AtomicBoolean();
        try (BufferedReader sr = new BufferedReader(new StringReader("01234567890")){

            @Override
            public void close() throws IOException {
                closed.set(true);
                super.close();
            }
        };){
            BoundedReader mr = new BoundedReader((Reader)sr, 3);
            mr.close();
        }
        Assertions.assertTrue((boolean)closed.get());
    }

    private void testLineNumberReader(Reader source) throws IOException {
        try (LineNumberReader reader = new LineNumberReader((Reader)new BoundedReader(source, 10000000));){
            while (reader.readLine() != null) {
            }
        }
    }

    public void testLineNumberReaderAndFileReaderLastLine(String data) throws IOException {
        try (TempFile path = TempFile.create(this.getClass().getSimpleName(), ".txt", new FileAttribute[0]);){
            File file = path.toFile();
            FileUtils.write((File)file, (CharSequence)data, (Charset)StandardCharsets.ISO_8859_1);
            try (BufferedReader source = Files.newBufferedReader(file.toPath());){
                this.testLineNumberReader(source);
            }
        }
    }

    @Test
    public void testLineNumberReaderAndFileReaderLastLineEolNo() {
        Assertions.assertTimeout((Duration)TIMEOUT, () -> this.testLineNumberReaderAndFileReaderLastLine(STRING_END_NO_EOL));
    }

    @Test
    public void testLineNumberReaderAndFileReaderLastLineEolYes() {
        Assertions.assertTimeout((Duration)TIMEOUT, () -> this.testLineNumberReaderAndFileReaderLastLine(STRING_END_EOL));
    }

    @Test
    public void testLineNumberReaderAndStringReaderLastLineEolNo() {
        Assertions.assertTimeout((Duration)TIMEOUT, () -> this.testLineNumberReader(new StringReader(STRING_END_NO_EOL)));
    }

    @Test
    public void testLineNumberReaderAndStringReaderLastLineEolYes() {
        Assertions.assertTimeout((Duration)TIMEOUT, () -> this.testLineNumberReader(new StringReader(STRING_END_EOL)));
    }

    @Test
    public void testMarkReset() throws IOException {
        try (BoundedReader mr = new BoundedReader(this.sr, 3);){
            mr.mark(3);
            mr.read();
            mr.read();
            mr.read();
            mr.reset();
            mr.read();
            mr.read();
            mr.read();
            Assertions.assertEquals((int)-1, (int)mr.read());
        }
    }

    @Test
    public void testMarkResetFromOffset1() throws IOException {
        try (BoundedReader mr = new BoundedReader(this.sr, 3);){
            mr.mark(3);
            mr.read();
            mr.read();
            mr.read();
            Assertions.assertEquals((int)-1, (int)mr.read());
            mr.reset();
            mr.mark(1);
            mr.read();
            Assertions.assertEquals((int)-1, (int)mr.read());
        }
    }

    @Test
    public void testMarkResetMarkMore() throws IOException {
        try (BoundedReader mr = new BoundedReader(this.sr, 3);){
            mr.mark(4);
            mr.read();
            mr.read();
            mr.read();
            mr.reset();
            mr.read();
            mr.read();
            mr.read();
            Assertions.assertEquals((int)-1, (int)mr.read());
        }
    }

    @Test
    public void testMarkResetWithMarkOutsideBoundedReaderMax() throws IOException {
        try (BoundedReader mr = new BoundedReader(this.sr, 3);){
            mr.mark(4);
            mr.read();
            mr.read();
            mr.read();
            Assertions.assertEquals((int)-1, (int)mr.read());
        }
    }

    @Test
    public void testMarkResetWithMarkOutsideBoundedReaderMaxAndInitialOffset() throws IOException {
        try (BoundedReader mr = new BoundedReader(this.sr, 3);){
            mr.read();
            mr.mark(3);
            mr.read();
            mr.read();
            Assertions.assertEquals((int)-1, (int)mr.read());
        }
    }

    @Test
    public void testReadBytesEOF() {
        Assertions.assertTimeout((Duration)TIMEOUT, () -> {
            BoundedReader mr = new BoundedReader(this.sr, 3);
            try (BufferedReader br = new BufferedReader((Reader)mr);){
                br.readLine();
                br.readLine();
            }
        });
    }

    @Test
    public void testReadMulti() throws IOException {
        try (BoundedReader mr = new BoundedReader(this.sr, 3);){
            char[] cbuf = new char[4];
            Arrays.fill(cbuf, 'X');
            int read = mr.read(cbuf, 0, 4);
            Assertions.assertEquals((int)3, (int)read);
            Assertions.assertEquals((char)'0', (char)cbuf[0]);
            Assertions.assertEquals((char)'1', (char)cbuf[1]);
            Assertions.assertEquals((char)'2', (char)cbuf[2]);
            Assertions.assertEquals((char)'X', (char)cbuf[3]);
        }
    }

    @Test
    public void testReadMultiWithOffset() throws IOException {
        try (BoundedReader mr = new BoundedReader(this.sr, 3);){
            char[] cbuf = new char[4];
            Arrays.fill(cbuf, 'X');
            int read = mr.read(cbuf, 1, 2);
            Assertions.assertEquals((int)2, (int)read);
            Assertions.assertEquals((char)'X', (char)cbuf[0]);
            Assertions.assertEquals((char)'0', (char)cbuf[1]);
            Assertions.assertEquals((char)'1', (char)cbuf[2]);
            Assertions.assertEquals((char)'X', (char)cbuf[3]);
        }
    }

    @Test
    public void testReadTillEnd() throws IOException {
        try (BoundedReader mr = new BoundedReader(this.sr, 3);){
            mr.read();
            mr.read();
            mr.read();
            Assertions.assertEquals((int)-1, (int)mr.read());
        }
    }

    @Test
    public void testShortReader() throws IOException {
        try (BoundedReader mr = new BoundedReader(this.shortReader, 3);){
            mr.read();
            mr.read();
            Assertions.assertEquals((int)-1, (int)mr.read());
        }
    }

    @Test
    public void testSkipTest() throws IOException {
        try (BoundedReader mr = new BoundedReader(this.sr, 3);){
            mr.skip(2L);
            mr.read();
            Assertions.assertEquals((int)-1, (int)mr.read());
        }
    }
}

