/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.input.XmlStreamReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BOMInputStreamTest {
    private void assertData(byte[] expected, byte[] actual, int len) {
        Assertions.assertEquals((int)expected.length, (int)len, (String)"length");
        for (int ii = 0; ii < expected.length; ++ii) {
            Assertions.assertEquals((byte)expected[ii], (byte)actual[ii], (String)("byte " + ii));
        }
    }

    private InputStream createUtf16BeDataStream(byte[] baseData, boolean addBOM) {
        byte[] data = baseData;
        if (addBOM) {
            data = new byte[baseData.length + 2];
            data[0] = -2;
            data[1] = -1;
            System.arraycopy(baseData, 0, data, 2, baseData.length);
        }
        return new ByteArrayInputStream(data);
    }

    private InputStream createUtf16LeDataStream(byte[] baseData, boolean addBOM) {
        byte[] data = baseData;
        if (addBOM) {
            data = new byte[baseData.length + 2];
            data[0] = -1;
            data[1] = -2;
            System.arraycopy(baseData, 0, data, 2, baseData.length);
        }
        return new ByteArrayInputStream(data);
    }

    private InputStream createUtf32BeDataStream(byte[] baseData, boolean addBOM) {
        byte[] data = baseData;
        if (addBOM) {
            data = new byte[baseData.length + 4];
            data[0] = 0;
            data[1] = 0;
            data[2] = -2;
            data[3] = -1;
            System.arraycopy(baseData, 0, data, 4, baseData.length);
        }
        return new ByteArrayInputStream(data);
    }

    private InputStream createUtf32LeDataStream(byte[] baseData, boolean addBOM) {
        byte[] data = baseData;
        if (addBOM) {
            data = new byte[baseData.length + 4];
            data[0] = -1;
            data[1] = -2;
            data[2] = 0;
            data[3] = 0;
            System.arraycopy(baseData, 0, data, 4, baseData.length);
        }
        return new ByteArrayInputStream(data);
    }

    private InputStream createUtf8Input(byte[] baseData, boolean addBOM) {
        byte[] data = baseData;
        if (addBOM) {
            data = new byte[baseData.length + 3];
            data[0] = -17;
            data[1] = -69;
            data[2] = -65;
            System.arraycopy(baseData, 0, data, 3, baseData.length);
        }
        return new ByteArrayInputStream(data);
    }

    private boolean doesSaxSupportCharacterSet(String charsetName) throws ParserConfigurationException, SAXException, IOException {
        block8: {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            try (CharSequenceInputStream byteStream = ((CharSequenceInputStream.Builder)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence((CharSequence)("<?xml version=\"1.0\" encoding=\"" + charsetName + "\"?><Z/>"))).setCharset(charsetName)).get();){
                InputSource is = new InputSource((InputStream)byteStream);
                is.setEncoding(charsetName);
                documentBuilder.parse(is);
            }
            catch (SAXParseException e) {
                if (!e.getMessage().contains(charsetName)) break block8;
                return false;
            }
        }
        return true;
    }

    private boolean jvmAndSaxBothSupportCharset(String charSetName) throws ParserConfigurationException, SAXException, IOException {
        return Charset.isSupported(charSetName) && this.doesSaxSupportCharacterSet(charSetName);
    }

    private void parseXml(InputStream in) throws SAXException, IOException, ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(in));
        Assertions.assertNotNull((Object)doc);
        Assertions.assertEquals((Object)"X", (Object)doc.getFirstChild().getNodeName());
    }

    private void parseXml(Reader in) throws SAXException, IOException, ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(in));
        Assertions.assertNotNull((Object)doc);
        Assertions.assertEquals((Object)"X", (Object)doc.getFirstChild().getNodeName());
    }

    private void readBOMInputStreamTwice(String resource) throws Exception {
        try (InputStream inputStream = this.getClass().getResourceAsStream(resource);){
            Assertions.assertNotNull((Object)inputStream);
            try (BOMInputStream bomInputStream = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(inputStream)).get();){
                bomInputStream.mark(1000000);
                this.readFile(bomInputStream);
                bomInputStream.reset();
                this.readFile(bomInputStream);
                inputStream.close();
            }
        }
    }

    private void readFile(BOMInputStream bomInputStream) throws Exception {
        int bytes;
        byte[] bytesFromStream = new byte[100];
        while ((bytes = bomInputStream.read(bytesFromStream)) > 0) {
        }
    }

    @Test
    public void testAvailableWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, true))).get();){
            Assertions.assertEquals((int)7, (int)in.available());
        }
    }

    @Test
    public void testAvailableWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            Assertions.assertEquals((int)4, (int)in.available());
        }
    }

    @Test
    public void testBuilderGet() {
        Assertions.assertThrows(IllegalStateException.class, () -> BOMInputStream.builder().get());
    }

    @Test
    public void testClose() throws Exception {
        try (ExpectCloseInputStream del = new ExpectCloseInputStream();){
            BOMInputStream in = new BOMInputStream((InputStream)del);
            in.close();
            del.assertCloseCalled();
        }
    }

    @Test
    public void testEmptyBufferWithBOM() throws Exception {
        byte[] data = new byte[]{};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, true))).get();){
            byte[] buf = new byte[1024];
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    public void testEmptyBufferWithoutBOM() throws Exception {
        byte[] data = new byte[]{};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            byte[] buf = new byte[1024];
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    public void testGetBOMFirstThenRead() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, true))).get();){
            Assertions.assertEquals((Object)ByteOrderMark.UTF_8, (Object)in.getBOM(), (String)"getBOM");
            Assertions.assertTrue((boolean)in.hasBOM(), (String)"hasBOM()");
            Assertions.assertTrue((boolean)in.hasBOM(ByteOrderMark.UTF_8), (String)"hasBOM(UTF-8)");
            Assertions.assertEquals((int)65, (int)in.read());
            Assertions.assertEquals((int)66, (int)in.read());
            Assertions.assertEquals((int)67, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testGetBOMFirstThenReadInclude() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, true))).setInclude(true).get();){
            Assertions.assertTrue((boolean)in.hasBOM(), (String)"hasBOM()");
            Assertions.assertTrue((boolean)in.hasBOM(ByteOrderMark.UTF_8), (String)"hasBOM(UTF-8)");
            Assertions.assertEquals((Object)ByteOrderMark.UTF_8, (Object)in.getBOM(), (String)"getBOM");
            Assertions.assertEquals((int)239, (int)in.read());
            Assertions.assertEquals((int)187, (int)in.read());
            Assertions.assertEquals((int)191, (int)in.read());
            Assertions.assertEquals((int)65, (int)in.read());
            Assertions.assertEquals((int)66, (int)in.read());
            Assertions.assertEquals((int)67, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testLargeBufferWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, true))).get();){
            byte[] buf = new byte[1024];
            this.assertData(data, buf, in.read(buf));
        }
    }

    @Test
    public void testLargeBufferWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            byte[] buf = new byte[1024];
            this.assertData(data, buf, in.read(buf));
        }
    }

    @Test
    public void testLeadingNonBOMBufferedRead() throws Exception {
        byte[] data = new byte[]{-17, -85, -51};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            byte[] buf = new byte[1024];
            this.assertData(data, buf, in.read(buf));
        }
    }

    @Test
    public void testLeadingNonBOMSingleRead() throws Exception {
        byte[] data = new byte[]{-17, -85, -51};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            Assertions.assertEquals((int)239, (int)in.read());
            Assertions.assertEquals((int)171, (int)in.read());
            Assertions.assertEquals((int)205, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    public void testMarkResetAfterReadWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, true))).get();){
            Assertions.assertTrue((boolean)in.markSupported());
            in.read();
            in.mark(10);
            in.read();
            in.read();
            in.reset();
            Assertions.assertEquals((int)66, (int)in.read());
        }
    }

    @Test
    public void testMarkResetAfterReadWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            Assertions.assertTrue((boolean)in.markSupported());
            in.read();
            in.mark(10);
            in.read();
            in.read();
            in.reset();
            Assertions.assertEquals((int)66, (int)in.read());
        }
    }

    @Test
    public void testMarkResetBeforeReadWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, true))).get();){
            Assertions.assertTrue((boolean)in.markSupported());
            in.mark(10);
            in.read();
            in.read();
            in.reset();
            Assertions.assertEquals((int)65, (int)in.read());
        }
    }

    @Test
    public void testMarkResetBeforeReadWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            Assertions.assertTrue((boolean)in.markSupported());
            in.mark(10);
            in.read();
            in.read();
            in.reset();
            Assertions.assertEquals((int)65, (int)in.read());
        }
    }

    @Test
    public void testNoBoms() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BOMInputStream(this.createUtf8Input(data, true), false, (ByteOrderMark[])null).close());
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BOMInputStream(this.createUtf8Input(data, true), false, new ByteOrderMark[0]).close());
        try (BOMInputStream bomInputStream = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, true))).setInclude(true).setByteOrderMarks((ByteOrderMark[])null).get();){
            Assertions.assertEquals((Object)BOMInputStream.Builder.getDefaultByteOrderMark(), (Object)bomInputStream.getBOM());
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, true))).setInclude(true).setByteOrderMarks(new ByteOrderMark[0]).get().close());
    }

    @Test
    public void testReadEmpty() throws Exception {
        byte[] data = new byte[]{};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertFalse((boolean)in.hasBOM(), (String)"hasBOM()");
            Assertions.assertFalse((boolean)in.hasBOM(ByteOrderMark.UTF_8), (String)"hasBOM(UTF-8)");
            Assertions.assertNull((Object)in.getBOM(), (String)"getBOM");
        }
    }

    @Test
    public void testReadSmall() throws Exception {
        byte[] data = new byte[]{65, 66};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            Assertions.assertEquals((int)65, (int)in.read());
            Assertions.assertEquals((int)66, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertFalse((boolean)in.hasBOM(), (String)"hasBOM()");
            Assertions.assertFalse((boolean)in.hasBOM(ByteOrderMark.UTF_8), (String)"hasBOM(UTF-8)");
            Assertions.assertNull((Object)in.getBOM(), (String)"getBOM");
        }
    }

    @Test
    public void testReadTwiceWithBOM() throws Exception {
        this.readBOMInputStreamTwice("/org/apache/commons/io/testfileBOM.xml");
    }

    @Test
    public void testReadTwiceWithoutBOM() throws Exception {
        this.readBOMInputStreamTwice("/org/apache/commons/io/testfileNoBOM.xml");
    }

    @Test
    public void testReadWithBOMInclude() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        try (BOMInputStream in = new BOMInputStream(this.createUtf8Input(data, true), true);){
            Assertions.assertEquals((int)239, (int)in.read());
            Assertions.assertEquals((int)187, (int)in.read());
            Assertions.assertEquals((int)191, (int)in.read());
            Assertions.assertEquals((int)65, (int)in.read());
            Assertions.assertEquals((int)66, (int)in.read());
            Assertions.assertEquals((int)67, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertTrue((boolean)in.hasBOM(), (String)"hasBOM()");
            Assertions.assertTrue((boolean)in.hasBOM(ByteOrderMark.UTF_8), (String)"hasBOM(UTF-8)");
            Assertions.assertEquals((Object)ByteOrderMark.UTF_8, (Object)in.getBOM(), (String)"getBOM");
        }
    }

    @Test
    public void testReadWithBOMUtf16Be() throws Exception {
        byte[] data = "ABC".getBytes(StandardCharsets.UTF_16BE);
        try (BOMInputStream in = new BOMInputStream(this.createUtf16BeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_16BE});){
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)65, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)66, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)67, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertTrue((boolean)in.hasBOM(), (String)"hasBOM()");
            Assertions.assertTrue((boolean)in.hasBOM(ByteOrderMark.UTF_16BE), (String)"hasBOM(UTF-16BE)");
            Assertions.assertEquals((Object)ByteOrderMark.UTF_16BE, (Object)in.getBOM(), (String)"getBOM");
            Assertions.assertThrows(IllegalArgumentException.class, () -> in.hasBOM(ByteOrderMark.UTF_16LE));
        }
    }

    @Test
    public void testReadWithBOMUtf16Le() throws Exception {
        byte[] data = "ABC".getBytes(StandardCharsets.UTF_16LE);
        try (BOMInputStream in = new BOMInputStream(this.createUtf16LeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_16LE});){
            Assertions.assertEquals((int)65, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)66, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)67, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertTrue((boolean)in.hasBOM(), (String)"hasBOM()");
            Assertions.assertTrue((boolean)in.hasBOM(ByteOrderMark.UTF_16LE), (String)"hasBOM(UTF-16LE)");
            Assertions.assertEquals((Object)ByteOrderMark.UTF_16LE, (Object)in.getBOM(), (String)"getBOM");
            Assertions.assertThrows(IllegalArgumentException.class, () -> in.hasBOM(ByteOrderMark.UTF_16BE));
        }
    }

    @Test
    public void testReadWithBOMUtf32Be() throws Exception {
        Assumptions.assumeTrue((boolean)Charset.isSupported("UTF_32BE"));
        byte[] data = "ABC".getBytes("UTF_32BE");
        try (BOMInputStream in = new BOMInputStream(this.createUtf32BeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_32BE});){
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)65, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)66, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)67, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertTrue((boolean)in.hasBOM(), (String)"hasBOM()");
            Assertions.assertTrue((boolean)in.hasBOM(ByteOrderMark.UTF_32BE), (String)"hasBOM(UTF-32BE)");
            Assertions.assertEquals((Object)ByteOrderMark.UTF_32BE, (Object)in.getBOM(), (String)"getBOM");
            Assertions.assertThrows(IllegalArgumentException.class, () -> in.hasBOM(ByteOrderMark.UTF_32LE));
        }
    }

    @Test
    public void testReadWithBOMUtf32Le() throws Exception {
        Assumptions.assumeTrue((boolean)Charset.isSupported("UTF_32LE"));
        byte[] data = "ABC".getBytes("UTF_32LE");
        try (BOMInputStream in = new BOMInputStream(this.createUtf32LeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_32LE});){
            Assertions.assertEquals((int)65, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)66, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)67, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)0, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertTrue((boolean)in.hasBOM(), (String)"hasBOM()");
            Assertions.assertTrue((boolean)in.hasBOM(ByteOrderMark.UTF_32LE), (String)"hasBOM(UTF-32LE)");
            Assertions.assertEquals((Object)ByteOrderMark.UTF_32LE, (Object)in.getBOM(), (String)"getBOM");
            Assertions.assertThrows(IllegalArgumentException.class, () -> in.hasBOM(ByteOrderMark.UTF_32BE));
        }
    }

    @Test
    public void testReadWithBOMUtf8() throws Exception {
        byte[] data = "ABC".getBytes(StandardCharsets.UTF_8);
        try (BOMInputStream in = new BOMInputStream(this.createUtf8Input(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_8});){
            Assertions.assertEquals((int)65, (int)in.read());
            Assertions.assertEquals((int)66, (int)in.read());
            Assertions.assertEquals((int)67, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertTrue((boolean)in.hasBOM(), (String)"hasBOM()");
            Assertions.assertTrue((boolean)in.hasBOM(ByteOrderMark.UTF_8), (String)"hasBOM(UTF-8)");
            Assertions.assertEquals((Object)ByteOrderMark.UTF_8, (Object)in.getBOM(), (String)"getBOM");
            Assertions.assertThrows(IllegalArgumentException.class, () -> in.hasBOM(ByteOrderMark.UTF_16BE));
        }
    }

    @Test
    public void testReadWithMultipleBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        try (BOMInputStream in = new BOMInputStream(this.createUtf8Input(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_8});){
            Assertions.assertEquals((int)65, (int)in.read());
            Assertions.assertEquals((int)66, (int)in.read());
            Assertions.assertEquals((int)67, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertTrue((boolean)in.hasBOM(), (String)"hasBOM()");
            Assertions.assertTrue((boolean)in.hasBOM(ByteOrderMark.UTF_8), (String)"hasBOM(UTF-8)");
            Assertions.assertFalse((boolean)in.hasBOM(ByteOrderMark.UTF_16BE), (String)"hasBOM(UTF-16BE)");
            Assertions.assertEquals((Object)ByteOrderMark.UTF_8, (Object)in.getBOM(), (String)"getBOM");
        }
    }

    @Test
    public void testReadWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            Assertions.assertEquals((int)65, (int)in.read());
            Assertions.assertEquals((int)66, (int)in.read());
            Assertions.assertEquals((int)67, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertFalse((boolean)in.hasBOM(), (String)"hasBOM()");
            Assertions.assertFalse((boolean)in.hasBOM(ByteOrderMark.UTF_8), (String)"hasBOM(UTF-8)");
            Assertions.assertNull((Object)in.getBOM(), (String)"getBOM");
        }
    }

    @Test
    public void testReadXmlWithBOMUcs2() throws Exception {
        Assumptions.assumeFalse((boolean)System.getProperty("java.vendor").contains("IBM"), (String)"This test does not pass on some IBM VMs xml parsers");
        Assumptions.assumeTrue((boolean)Charset.isSupported("ISO-10646-UCS-2"));
        byte[] data = "<?xml version=\"1.0\" encoding=\"ISO-10646-UCS-2\"?><X/>".getBytes("ISO-10646-UCS-2");
        try (BOMInputStream in = new BOMInputStream(this.createUtf16BeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_16BE});){
            this.parseXml((InputStream)in);
        }
        this.parseXml(this.createUtf16BeDataStream(data, true));
    }

    @Test
    public void testReadXmlWithBOMUcs4() throws Exception {
        Assumptions.assumeTrue((boolean)Charset.isSupported("ISO-10646-UCS-4"));
        byte[] data = "<?xml version=\"1.0\" encoding=\"ISO-10646-UCS-4\"?><X/>".getBytes("ISO-10646-UCS-4");
        try (BOMInputStream in = new BOMInputStream(this.createUtf32BeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_32BE});){
            this.parseXml((InputStream)in);
            Assumptions.assumeTrue((boolean)this.jvmAndSaxBothSupportCharset("UTF_32LE"), (String)"JVM and SAX need to support UTF_32LE for this");
        }
        this.parseXml(this.createUtf32BeDataStream(data, true));
    }

    @Test
    public void testReadXmlWithBOMUtf16Be() throws Exception {
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF-16BE\"?><X/>".getBytes(StandardCharsets.UTF_16BE);
        try (BOMInputStream in = new BOMInputStream(this.createUtf16BeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_16BE});){
            this.parseXml((InputStream)in);
        }
        this.parseXml(this.createUtf16BeDataStream(data, true));
    }

    @Test
    public void testReadXmlWithBOMUtf16Le() throws Exception {
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF-16LE\"?><X/>".getBytes(StandardCharsets.UTF_16LE);
        try (BOMInputStream in = new BOMInputStream(this.createUtf16LeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_16LE});){
            this.parseXml((InputStream)in);
        }
        this.parseXml(this.createUtf16LeDataStream(data, true));
    }

    @Test
    public void testReadXmlWithBOMUtf32Be() throws Exception {
        Assumptions.assumeTrue((boolean)this.jvmAndSaxBothSupportCharset("UTF_32BE"), (String)"JVM and SAX need to support UTF_32BE for this");
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF-32BE\"?><X/>".getBytes("UTF_32BE");
        try (BOMInputStream in = new BOMInputStream(this.createUtf32BeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_32BE});){
            this.parseXml((InputStream)in);
        }
        in = new XmlStreamReader(this.createUtf32BeDataStream(data, true));
        try {
            this.parseXml((Reader)in);
        }
        finally {
            in.close();
        }
    }

    @Test
    public void testReadXmlWithBOMUtf32Le() throws Exception {
        Assumptions.assumeTrue((boolean)this.jvmAndSaxBothSupportCharset("UTF_32LE"), (String)"JVM and SAX need to support UTF_32LE for this");
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF-32LE\"?><X/>".getBytes("UTF_32LE");
        try (BOMInputStream in = new BOMInputStream(this.createUtf32LeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_32LE});){
            this.parseXml((InputStream)in);
        }
        in = new XmlStreamReader(this.createUtf32LeDataStream(data, true));
        try {
            this.parseXml((Reader)in);
        }
        finally {
            in.close();
        }
    }

    @Test
    public void testReadXmlWithBOMUtf8() throws Exception {
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><X/>".getBytes(StandardCharsets.UTF_8);
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, true))).get();){
            this.parseXml((InputStream)in);
        }
        this.parseXml(this.createUtf8Input(data, true));
    }

    @Test
    public void testReadXmlWithoutBOMUtf32Be() throws Exception {
        Assumptions.assumeTrue((boolean)this.jvmAndSaxBothSupportCharset("UTF_32BE"), (String)"JVM and SAX need to support UTF_32BE for this");
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF_32BE\"?><X/>".getBytes("UTF_32BE");
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            this.parseXml((InputStream)in);
        }
        this.parseXml(this.createUtf32BeDataStream(data, false));
    }

    @Test
    public void testReadXmlWithoutBOMUtf32Le() throws Exception {
        Assumptions.assumeTrue((boolean)this.jvmAndSaxBothSupportCharset("UTF_32LE"), (String)"JVM and SAX need to support UTF_32LE for this");
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF-32LE\"?><X/>".getBytes("UTF_32LE");
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            this.parseXml((InputStream)in);
        }
        this.parseXml(this.createUtf32BeDataStream(data, false));
    }

    @Test
    public void testSkipReturnValueWithBom() throws IOException {
        byte[] data = new byte[]{49, 50, 51};
        try (BOMInputStream is1 = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, true))).get();){
            Assertions.assertEquals((long)2L, (long)is1.skip(2L));
            Assertions.assertEquals((int)51, (int)is1.read());
        }
    }

    @Test
    public void testSkipReturnValueWithoutBom() throws IOException {
        byte[] data = new byte[]{49, 50, 51};
        try (BOMInputStream is2 = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            Assertions.assertEquals((long)2L, (long)is2.skip(2L));
            Assertions.assertEquals((int)51, (int)is2.read());
        }
    }

    @Test
    public void testSkipWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, true))).get();){
            in.skip(2L);
            Assertions.assertEquals((int)67, (int)in.read());
        }
    }

    @Test
    public void testSkipWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            in.skip(2L);
            Assertions.assertEquals((int)67, (int)in.read());
        }
    }

    @Test
    public void testSmallBufferWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, true))).get();){
            byte[] buf = new byte[1024];
            this.assertData(new byte[]{65, 66}, buf, in.read(buf, 0, 2));
            this.assertData(new byte[]{67}, buf, in.read(buf, 0, 2));
        }
    }

    @Test
    public void testSmallBufferWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        try (BOMInputStream in = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(this.createUtf8Input(data, false))).get();){
            byte[] buf = new byte[1024];
            this.assertData(new byte[]{65, 66}, buf, in.read(buf, 0, 2));
            this.assertData(new byte[]{67}, buf, in.read(buf, 0, 2));
        }
    }

    @Test
    public void testSupportCode() throws Exception {
        try (InputStream in = this.createUtf8Input(new byte[]{65, 66}, true);){
            byte[] buf = new byte[1024];
            int len = in.read(buf);
            Assertions.assertEquals((int)5, (int)len);
            Assertions.assertEquals((int)239, (int)(buf[0] & 0xFF));
            Assertions.assertEquals((int)187, (int)(buf[1] & 0xFF));
            Assertions.assertEquals((int)191, (int)(buf[2] & 0xFF));
            Assertions.assertEquals((int)65, (int)(buf[3] & 0xFF));
            Assertions.assertEquals((int)66, (int)(buf[4] & 0xFF));
            this.assertData(new byte[]{-17, -69, -65, 65, 66}, buf, len);
        }
    }

    private static final class ExpectCloseInputStream
    extends InputStream {
        private boolean _closeCalled;

        private ExpectCloseInputStream() {
        }

        public void assertCloseCalled() {
            Assertions.assertTrue((boolean)this._closeCalled);
        }

        @Override
        public void close() throws IOException {
            this._closeCalled = true;
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }
}

