/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AutoCloseInputStreamTest {
    private byte[] data;
    private AutoCloseInputStream stream;
    private boolean closed;

    @BeforeEach
    public void setUp() {
        this.data = new byte[]{120, 121, 122};
        this.stream = new AutoCloseInputStream((InputStream)new ByteArrayInputStream(this.data){

            @Override
            public void close() {
                AutoCloseInputStreamTest.this.closed = true;
            }
        });
        this.closed = false;
    }

    @Test
    public void testBuilderGet() {
        Assertions.assertThrows(IllegalStateException.class, () -> AutoCloseInputStream.builder().get());
    }

    @Test
    public void testClose() throws IOException {
        this.stream.close();
        Assertions.assertTrue((boolean)this.closed, (String)"closed");
        Assertions.assertEquals((int)-1, (int)this.stream.read(), (String)"read()");
    }

    @Test
    public void testFinalize() throws Throwable {
        this.stream.finalize();
        Assertions.assertTrue((boolean)this.closed, (String)"closed");
        Assertions.assertEquals((int)-1, (int)this.stream.read(), (String)"read()");
    }

    @Test
    public void testRead() throws IOException {
        for (byte element : this.data) {
            Assertions.assertEquals((int)element, (int)this.stream.read(), (String)"read()");
            Assertions.assertFalse((boolean)this.closed, (String)"closed");
        }
        Assertions.assertEquals((int)-1, (int)this.stream.read(), (String)"read()");
        Assertions.assertTrue((boolean)this.closed, (String)"closed");
    }

    @Test
    public void testReadBuffer() throws IOException {
        byte[] b = new byte[this.data.length * 2];
        int total = 0;
        int n = 0;
        while (n != -1) {
            Assertions.assertFalse((boolean)this.closed, (String)"closed");
            for (int i = 0; i < n; ++i) {
                Assertions.assertEquals((byte)this.data[total + i], (byte)b[i], (String)"read(b)");
            }
            total += n;
            n = this.stream.read(b);
        }
        Assertions.assertEquals((int)this.data.length, (int)total, (String)"read(b)");
        Assertions.assertTrue((boolean)this.closed, (String)"closed");
        Assertions.assertEquals((int)-1, (int)this.stream.read(b), (String)"read(b)");
    }

    @Test
    public void testReadBufferOffsetLength() throws IOException {
        byte[] b = new byte[this.data.length * 2];
        int total = 0;
        int n = 0;
        while (n != -1) {
            Assertions.assertFalse((boolean)this.closed, (String)"closed");
            n = this.stream.read(b, total += n, b.length - total);
        }
        Assertions.assertEquals((int)this.data.length, (int)total, (String)"read(b, off, len)");
        for (int i = 0; i < this.data.length; ++i) {
            Assertions.assertEquals((byte)this.data[i], (byte)b[i], (String)"read(b, off, len)");
        }
        Assertions.assertTrue((boolean)this.closed, (String)"closed");
        Assertions.assertEquals((int)-1, (int)this.stream.read(b, 0, b.length), (String)"read(b, off, len)");
    }

    private void testResetBeforeEnd(AutoCloseInputStream inputStream) throws IOException {
        inputStream.mark(1);
        Assertions.assertEquals((int)49, (int)inputStream.read());
        inputStream.reset();
        Assertions.assertEquals((int)49, (int)inputStream.read());
        Assertions.assertEquals((int)50, (int)inputStream.read());
        inputStream.reset();
        Assertions.assertEquals((int)49, (int)inputStream.read());
        Assertions.assertEquals((int)50, (int)inputStream.read());
        Assertions.assertEquals((int)51, (int)inputStream.read());
        inputStream.reset();
        Assertions.assertEquals((int)49, (int)inputStream.read());
        Assertions.assertEquals((int)50, (int)inputStream.read());
        Assertions.assertEquals((int)51, (int)inputStream.read());
        Assertions.assertEquals((int)52, (int)inputStream.read());
        inputStream.reset();
        Assertions.assertEquals((int)49, (int)inputStream.read());
    }

    @Test
    public void testResetBeforeEndCtor() throws IOException {
        try (AutoCloseInputStream inputStream = new AutoCloseInputStream((InputStream)new ByteArrayInputStream("1234".getBytes()));){
            this.testResetBeforeEnd(inputStream);
        }
    }

    @Test
    public void testResetBeforeEndSetByteArray() throws IOException {
        try (AutoCloseInputStream inputStream = ((AutoCloseInputStream.Builder)AutoCloseInputStream.builder().setByteArray("1234".getBytes())).get();){
            this.testResetBeforeEnd(inputStream);
        }
    }

    @Test
    public void testResetBeforeEndSetCharSequence() throws IOException {
        try (AutoCloseInputStream inputStream = ((AutoCloseInputStream.Builder)AutoCloseInputStream.builder().setCharSequence((CharSequence)"1234")).get();){
            this.testResetBeforeEnd(inputStream);
        }
    }

    @Test
    public void testResetBeforeEndSetInputStream() throws IOException {
        try (AutoCloseInputStream inputStream = ((AutoCloseInputStream.Builder)AutoCloseInputStream.builder().setInputStream((InputStream)new ByteArrayInputStream("1234".getBytes()))).get();){
            this.testResetBeforeEnd(inputStream);
        }
    }
}

