/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.function.IOIntSupplier;
import org.apache.commons.io.function.IOLongSupplier;
import org.apache.commons.io.function.IORunnable;
import org.apache.commons.io.function.TestConstants;
import org.apache.commons.io.function.TestUtils;
import org.apache.commons.io.function.Uncheck;
import org.apache.commons.io.input.BrokenInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UncheckTest {
    private static final byte[] BYTES = new byte[]{97, 98};
    private static final String CAUSE_MESSAGE = "CauseMessage";
    private static final String CUSTOM_MESSAGE = "Custom message";
    private AtomicInteger atomicInt;
    private AtomicLong atomicLong;
    private AtomicReference<String> ref1;
    private AtomicReference<String> ref2;
    private AtomicReference<String> ref3;
    private AtomicReference<String> ref4;

    private void assertUncheckedIOException(IOException expected, UncheckedIOException e) {
        Assertions.assertEquals((Object)CUSTOM_MESSAGE, (Object)e.getMessage());
        IOException cause = e.getCause();
        Assertions.assertEquals(expected.getClass(), cause.getClass());
        Assertions.assertEquals((Object)CAUSE_MESSAGE, (Object)cause.getMessage());
    }

    @BeforeEach
    public void initEach() {
        this.ref1 = new AtomicReference();
        this.ref2 = new AtomicReference();
        this.ref3 = new AtomicReference();
        this.ref4 = new AtomicReference();
        this.atomicInt = new AtomicInteger();
        this.atomicLong = new AtomicLong();
    }

    private ByteArrayInputStream newInputStream() {
        return new ByteArrayInputStream(BYTES);
    }

    @Test
    public void testAccept() {
        ByteArrayInputStream stream = this.newInputStream();
        Uncheck.accept(n -> stream.skip(n.intValue()), (Object)1);
        Assertions.assertEquals((int)98, (int)((Integer)Uncheck.get(stream::read)));
    }

    @Test
    public void testAcceptIOBiConsumerOfTUTU() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.accept((t, u) -> {
            throw new IOException();
        }, null, null));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.accept(TestConstants.THROWING_IO_BI_CONSUMER, null, null));
        Uncheck.accept((t, u) -> {
            TestUtils.compareAndSetThrowsIO(this.ref1, t);
            TestUtils.compareAndSetThrowsIO(this.ref2, u);
        }, (Object)"new1", (Object)"new2");
        Assertions.assertEquals((Object)"new1", (Object)this.ref1.get());
        Assertions.assertEquals((Object)"new2", (Object)this.ref2.get());
    }

    @Test
    public void testAcceptIOConsumerOfTT() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.accept(t -> {
            throw new IOException();
        }, null));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.accept(TestUtils.throwingIOConsumer(), null));
        Uncheck.accept(t -> TestUtils.compareAndSetThrowsIO(this.ref1, t), (Object)"new1");
        Assertions.assertEquals((Object)"new1", (Object)this.ref1.get());
    }

    @Test
    public void testAcceptIOTriConsumerOfTUVTUV() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.accept((t, u, v) -> {
            throw new IOException();
        }, null, null, null));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.accept(TestConstants.THROWING_IO_TRI_CONSUMER, null, null, null));
        Uncheck.accept((t, u, v) -> {
            TestUtils.compareAndSetThrowsIO(this.ref1, t);
            TestUtils.compareAndSetThrowsIO(this.ref2, u);
            TestUtils.compareAndSetThrowsIO(this.ref3, v);
        }, (Object)"new1", (Object)"new2", (Object)"new3");
        Assertions.assertEquals((Object)"new1", (Object)this.ref1.get());
        Assertions.assertEquals((Object)"new2", (Object)this.ref2.get());
        Assertions.assertEquals((Object)"new3", (Object)this.ref3.get());
    }

    @Test
    public void testApply1() {
        ByteArrayInputStream stream = this.newInputStream();
        Assertions.assertEquals((int)1, (int)((Long)Uncheck.apply(n -> stream.skip(n.intValue()), (Object)1)).intValue());
        Assertions.assertEquals((int)98, (int)((Integer)Uncheck.get(stream::read)));
    }

    @Test
    public void testApply2() {
        ByteArrayInputStream stream = this.newInputStream();
        byte[] buf = new byte[BYTES.length];
        Assertions.assertEquals((int)1, (int)((Integer)Uncheck.apply((o, l) -> stream.read(buf, (int)o, (int)l), (Object)0, (Object)1)));
        Assertions.assertEquals((int)97, (int)buf[0]);
    }

    @Test
    public void testApply3() {
        ByteArrayInputStream stream = this.newInputStream();
        byte[] buf = new byte[BYTES.length];
        Assertions.assertEquals((int)1, (int)((Integer)Uncheck.apply((b, o, l) -> stream.read((byte[])b, (int)o, (int)l), (Object)buf, (Object)0, (Object)1)));
        Assertions.assertEquals((int)97, (int)buf[0]);
    }

    @Test
    public void testApplyIOBiFunctionOfTURTU() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.apply((t, u) -> {
            throw new IOException();
        }, null, null));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.apply(TestConstants.THROWING_IO_BI_FUNCTION, null, null));
        Assertions.assertEquals((Object)"new0", (Object)Uncheck.apply((t, u) -> {
            TestUtils.compareAndSetThrowsIO(this.ref1, t);
            TestUtils.compareAndSetThrowsIO(this.ref2, u);
            return "new0";
        }, (Object)"new1", (Object)"new2"));
        Assertions.assertEquals((Object)"new1", (Object)this.ref1.get());
        Assertions.assertEquals((Object)"new2", (Object)this.ref2.get());
    }

    @Test
    public void testApplyIOFunctionOfTRT() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.apply(t -> {
            throw new IOException();
        }, null));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.apply(TestConstants.THROWING_IO_FUNCTION, null));
        Uncheck.apply(t -> TestUtils.compareAndSetThrowsIO(this.ref1, t), (Object)"new1");
        Assertions.assertEquals((Object)"new1", (Object)this.ref1.get());
    }

    @Test
    public void testApplyIOQuadFunctionOfTUVWRTUVW() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.apply((t, u, v, w) -> {
            throw new IOException();
        }, null, null, null, null));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.apply(TestConstants.THROWING_IO_QUAD_FUNCTION, null, null, null, null));
        Assertions.assertEquals((Object)"new0", (Object)Uncheck.apply((t, u, v, w) -> {
            TestUtils.compareAndSetThrowsIO(this.ref1, t);
            TestUtils.compareAndSetThrowsIO(this.ref2, u);
            TestUtils.compareAndSetThrowsIO(this.ref3, v);
            TestUtils.compareAndSetThrowsIO(this.ref4, w);
            return "new0";
        }, (Object)"new1", (Object)"new2", (Object)"new3", (Object)"new4"));
        Assertions.assertEquals((Object)"new1", (Object)this.ref1.get());
        Assertions.assertEquals((Object)"new2", (Object)this.ref2.get());
        Assertions.assertEquals((Object)"new3", (Object)this.ref3.get());
        Assertions.assertEquals((Object)"new4", (Object)this.ref4.get());
    }

    @Test
    public void testApplyIOTriFunctionOfTUVRTUV() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.apply((t, u, v) -> {
            throw new IOException();
        }, null, null, null));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.apply(TestConstants.THROWING_IO_TRI_FUNCTION, null, null, null));
        Assertions.assertEquals((Object)"new0", (Object)Uncheck.apply((t, u, v) -> {
            TestUtils.compareAndSetThrowsIO(this.ref1, t);
            TestUtils.compareAndSetThrowsIO(this.ref2, u);
            TestUtils.compareAndSetThrowsIO(this.ref3, v);
            return "new0";
        }, (Object)"new1", (Object)"new2", (Object)"new3"));
        Assertions.assertEquals((Object)"new1", (Object)this.ref1.get());
        Assertions.assertEquals((Object)"new2", (Object)this.ref2.get());
        Assertions.assertEquals((Object)"new3", (Object)this.ref3.get());
    }

    @Test
    public void testGet() {
        Assertions.assertEquals((int)97, (int)((Integer)Uncheck.get(() -> this.newInputStream().read())));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.get(() -> {
            throw new IOException();
        }));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.get(TestConstants.THROWING_IO_SUPPLIER));
        Assertions.assertEquals((Object)"new1", (Object)Uncheck.get(() -> TestUtils.compareAndSetThrowsIO(this.ref1, "new1")));
        Assertions.assertEquals((Object)"new1", (Object)this.ref1.get());
    }

    @Test
    public void testGetAsInt() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.getAsInt(() -> {
            throw new IOException();
        }));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.getAsInt((IOIntSupplier)TestConstants.THROWING_IO_INT_SUPPLIER));
        Assertions.assertEquals((int)1, (int)Uncheck.getAsInt(() -> TestUtils.compareAndSetThrowsIO(this.atomicInt, 1)));
        Assertions.assertEquals((int)1, (int)this.atomicInt.get());
    }

    @Test
    public void testGetAsIntMessage() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.getAsInt(() -> {
            throw new IOException();
        }, () -> CUSTOM_MESSAGE));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.getAsInt((IOIntSupplier)TestConstants.THROWING_IO_INT_SUPPLIER, () -> CUSTOM_MESSAGE));
        Assertions.assertEquals((int)1, (int)Uncheck.getAsInt(() -> TestUtils.compareAndSetThrowsIO(this.atomicInt, 1), () -> CUSTOM_MESSAGE));
        Assertions.assertEquals((int)1, (int)this.atomicInt.get());
        IOException expected = new IOException(CAUSE_MESSAGE);
        try {
            Uncheck.getAsInt(() -> new BrokenInputStream(expected).read(), () -> CUSTOM_MESSAGE);
            Assertions.fail();
        }
        catch (UncheckedIOException e) {
            this.assertUncheckedIOException(expected, e);
        }
    }

    @Test
    public void testGetAsLong() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.getAsLong(() -> {
            throw new IOException();
        }));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.getAsLong((IOLongSupplier)TestConstants.THROWING_IO_LONG_SUPPLIER));
        Assertions.assertEquals((long)1L, (long)Uncheck.getAsLong(() -> TestUtils.compareAndSetThrowsIO(this.atomicLong, 1L)));
        Assertions.assertEquals((long)1L, (long)this.atomicLong.get());
    }

    @Test
    public void testGetAsLongMessage() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.getAsLong(() -> {
            throw new IOException();
        }, () -> CUSTOM_MESSAGE));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.getAsLong((IOLongSupplier)TestConstants.THROWING_IO_LONG_SUPPLIER, () -> CUSTOM_MESSAGE));
        Assertions.assertEquals((long)1L, (long)Uncheck.getAsLong(() -> TestUtils.compareAndSetThrowsIO(this.atomicLong, 1L), () -> CUSTOM_MESSAGE));
        Assertions.assertEquals((long)1L, (long)this.atomicLong.get());
        IOException expected = new IOException(CAUSE_MESSAGE);
        try {
            Uncheck.getAsLong(() -> new BrokenInputStream(expected).read(), () -> CUSTOM_MESSAGE);
            Assertions.fail();
        }
        catch (UncheckedIOException e) {
            this.assertUncheckedIOException(expected, e);
        }
    }

    @Test
    public void testGetMessage() {
        Assertions.assertEquals((int)97, (int)((Integer)Uncheck.get(() -> this.newInputStream().read())), () -> CUSTOM_MESSAGE);
        IOException expected = new IOException(CAUSE_MESSAGE);
        try {
            Uncheck.get(() -> new BrokenInputStream(expected).read(), () -> CUSTOM_MESSAGE);
            Assertions.fail();
        }
        catch (UncheckedIOException e) {
            this.assertUncheckedIOException(expected, e);
        }
    }

    @Test
    public void testRun() {
        ByteArrayInputStream stream = this.newInputStream();
        Uncheck.run(() -> stream.skip(1L));
        Assertions.assertEquals((int)98, (int)((Integer)Uncheck.get(stream::read)));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.run(() -> {
            throw new IOException();
        }));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.run((IORunnable)TestConstants.THROWING_IO_RUNNABLE));
        Uncheck.run(() -> TestUtils.compareAndSetThrowsIO(this.ref1, "new1"));
        Assertions.assertEquals((Object)"new1", (Object)this.ref1.get());
    }

    @Test
    public void testRunMessage() throws IOException {
        ByteArrayInputStream stream = this.newInputStream();
        Uncheck.run(() -> stream.skip(1L), () -> CUSTOM_MESSAGE);
        Assertions.assertEquals((int)98, (int)((Integer)Uncheck.get(stream::read)));
        IOException expected = new IOException(CAUSE_MESSAGE);
        try {
            Uncheck.run(() -> new BrokenInputStream(expected).read(), () -> CUSTOM_MESSAGE);
            Assertions.fail();
        }
        catch (UncheckedIOException e) {
            this.assertUncheckedIOException(expected, e);
        }
    }

    @Test
    public void testTest() {
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.test(t -> {
            throw new IOException();
        }, null));
        Assertions.assertThrows(UncheckedIOException.class, () -> Uncheck.test(TestConstants.THROWING_IO_PREDICATE, null));
        Assertions.assertTrue((boolean)Uncheck.test(t -> TestUtils.compareAndSetThrowsIO(this.ref1, t).equals(t), (Object)"new1"));
        Assertions.assertEquals((Object)"new1", (Object)this.ref1.get());
    }
}

