/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.TestConstants;
import org.apache.commons.io.function.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IOSupplierTest {
    private AtomicReference<String> ref1;

    private String getThrowsIO(IOSupplier<String> supplier) throws IOException {
        return (String)supplier.get();
    }

    private String getThrowsNone(IOSupplier<String> supplier) {
        return (String)supplier.asSupplier().get();
    }

    @BeforeEach
    public void initEach() {
        this.ref1 = new AtomicReference();
    }

    @Test
    public void testAsSupplier() {
        Assertions.assertThrows(UncheckedIOException.class, () -> TestConstants.THROWING_IO_SUPPLIER.asSupplier().get());
        Assertions.assertEquals((Object)"new1", (Object)this.getThrowsNone((IOSupplier<String>)((IOSupplier)() -> TestUtils.compareAndSetThrowsIO(this.ref1, "new1"))));
        Assertions.assertEquals((Object)"new1", (Object)this.ref1.get());
        Assertions.assertNotEquals((Object)TestConstants.THROWING_IO_SUPPLIER.asSupplier(), (Object)TestConstants.THROWING_IO_SUPPLIER.asSupplier());
    }

    @Test
    public void testGet() throws IOException {
        Assertions.assertThrows(IOException.class, () -> TestConstants.THROWING_IO_SUPPLIER.get());
        Assertions.assertThrows(IOException.class, () -> {
            throw new IOException();
        });
        Assertions.assertEquals((Object)"new1", (Object)this.getThrowsIO((IOSupplier<String>)((IOSupplier)() -> TestUtils.compareAndSetThrowsIO(this.ref1, "new1"))));
        Assertions.assertEquals((Object)"new1", (Object)this.ref1.get());
    }
}

