/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.file.AbstractTempDirTest;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathUtilsDeleteDirectoryTest
extends AbstractTempDirTest {
    @Test
    public void testDeleteAbsentDirectory() throws IOException {
        Path absent = this.tempDirPath.resolve("ThisDirectoryDoesNotExist");
        Assertions.assertFalse((boolean)Files.exists(absent, new LinkOption[0]));
        Class<NoSuchFileException> expectedType = NoSuchFileException.class;
        Assertions.assertThrows(expectedType, () -> PathUtils.deleteDirectory((Path)absent));
        Assertions.assertThrows(expectedType, () -> PathUtils.deleteDirectory((Path)absent, (DeleteOption[])new DeleteOption[]{StandardDeleteOption.OVERRIDE_READ_ONLY}));
        Assertions.assertThrows(expectedType, () -> PathUtils.deleteDirectory((Path)absent, (DeleteOption[])PathUtils.EMPTY_DELETE_OPTION_ARRAY));
        Files.deleteIfExists(this.tempDirPath);
    }

    @Test
    public void testDeleteDirectory1FileSize0() throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]), (Path)this.tempDirPath, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(1L, 1L, 0L, PathUtils.deleteDirectory((Path)this.tempDirPath));
        Files.deleteIfExists(this.tempDirPath);
    }

    private void testDeleteDirectory1FileSize0(DeleteOption ... options) throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0", new String[0]), (Path)this.tempDirPath, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(1L, 1L, 0L, PathUtils.deleteDirectory((Path)this.tempDirPath, (DeleteOption[])options));
        Files.deleteIfExists(this.tempDirPath);
    }

    @Test
    public void testDeleteDirectory1FileSize0NoOptions() throws IOException {
        this.testDeleteDirectory1FileSize0(PathUtils.EMPTY_DELETE_OPTION_ARRAY);
    }

    @Test
    public void testDeleteDirectory1FileSize0OverrideReadOnly() throws IOException {
        this.testDeleteDirectory1FileSize0(new DeleteOption[]{StandardDeleteOption.OVERRIDE_READ_ONLY});
    }

    @Test
    public void testDeleteDirectory1FileSize1() throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]), (Path)this.tempDirPath, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(1L, 1L, 1L, PathUtils.deleteDirectory((Path)this.tempDirPath));
        Files.deleteIfExists(this.tempDirPath);
    }

    @Test
    public void testDeleteDirectory2FileSize2() throws IOException {
        PathUtils.copyDirectory((Path)Paths.get("src/test/resources/org/apache/commons/io/dirs-2-file-size-2", new String[0]), (Path)this.tempDirPath, (CopyOption[])new CopyOption[0]);
        CounterAssertions.assertCounts(3L, 2L, 2L, PathUtils.deleteDirectory((Path)this.tempDirPath));
        Files.deleteIfExists(this.tempDirPath);
    }

    @Test
    public void testDeleteEmptyDirectory() throws IOException {
        CounterAssertions.assertCounts(1L, 0L, 0L, PathUtils.deleteDirectory((Path)this.tempDirPath));
        Files.deleteIfExists(this.tempDirPath);
    }
}

