/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

public abstract class AbstractTempDirTest {
    protected static final String SUB_DIR = "subdir";
    protected static final String SYMLINKED_DIR = "symlinked-dir";
    @TempDir
    public Path managedTempDirPath;
    public File tempDirFile;
    public Path tempDirPath;

    protected static Path createTempSymlinkedRelativeDir(Path rootDir) throws IOException {
        Path targetDir = rootDir.resolve(SUB_DIR);
        Path symlinkDir = rootDir.resolve(SYMLINKED_DIR);
        Files.createDirectory(targetDir, new FileAttribute[0]);
        return Files.createSymbolicLink(symlinkDir, targetDir, new FileAttribute[0]);
    }

    @BeforeEach
    public void beforeEachCreateTempDirs() throws IOException {
        this.tempDirPath = Files.createTempDirectory(this.managedTempDirPath, this.getClass().getSimpleName(), new FileAttribute[0]);
        this.tempDirFile = this.tempDirPath.toFile();
    }

    protected final boolean isPosixFilePermissionsSupported() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }
}

