/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.RandomAccessFiles;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RandomAccessFilesTest {
    private static final String FILE_NAME_RO_20 = "src/test/resources/org/apache/commons/io/test-file-20byteslength.bin";
    private static final String FILE_NAME_RO_0 = "src/test/resources/org/apache/commons/io/test-file-empty.bin";
    private static final String FILE_NAME_RO_0_BIS = "src/test/resources/org/apache/commons/io/test-file-empty2.bin";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContentEquals() throws IOException {
        RandomAccessFile raf2;
        try (RandomAccessFile raf1 = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_20);){
            Assertions.assertEquals((Object)raf1, (Object)raf1);
            Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)raf1, (RandomAccessFile)raf1));
        }
        raf1 = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_20);
        try {
            Assertions.assertEquals((Object)raf1, (Object)raf1);
            Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)raf1, (RandomAccessFile)raf1));
        }
        finally {
            if (raf1 != null) {
                raf1.close();
            }
        }
        raf1 = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_20);
        try {
            raf2 = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_20);
            try {
                Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)raf1, (RandomAccessFile)raf2));
            }
            finally {
                if (raf2 != null) {
                    raf2.close();
                }
            }
        }
        finally {
            if (raf1 != null) {
                raf1.close();
            }
        }
        raf1 = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_0);
        try {
            raf2 = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_0);
            try {
                Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)raf1, (RandomAccessFile)raf2));
                Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)RandomAccessFiles.reset((RandomAccessFile)raf2), (RandomAccessFile)RandomAccessFiles.reset((RandomAccessFile)raf1)));
            }
            finally {
                if (raf2 != null) {
                    raf2.close();
                }
            }
        }
        finally {
            if (raf1 != null) {
                raf1.close();
            }
        }
        raf1 = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_0);
        try {
            raf2 = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_0_BIS);
            try {
                Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)raf1, (RandomAccessFile)raf2));
                Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)RandomAccessFiles.reset((RandomAccessFile)raf2), (RandomAccessFile)RandomAccessFiles.reset((RandomAccessFile)raf1)));
            }
            finally {
                if (raf2 != null) {
                    raf2.close();
                }
            }
        }
        finally {
            if (raf1 != null) {
                raf1.close();
            }
        }
        raf1 = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_0);
        try {
            raf2 = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_20);
            try {
                Assertions.assertFalse((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)raf1, (RandomAccessFile)raf2));
                Assertions.assertFalse((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)RandomAccessFiles.reset((RandomAccessFile)raf2), (RandomAccessFile)RandomAccessFiles.reset((RandomAccessFile)raf1)));
            }
            finally {
                if (raf2 != null) {
                    raf2.close();
                }
            }
        }
        finally {
            if (raf1 != null) {
                raf1.close();
            }
        }
        Path bigFile1 = Files.createTempFile(this.getClass().getSimpleName(), "-1.bin", new FileAttribute[0]);
        Path bigFile2 = Files.createTempFile(this.getClass().getSimpleName(), "-2.bin", new FileAttribute[0]);
        Path bigFile3 = Files.createTempFile(this.getClass().getSimpleName(), "-3.bin", new FileAttribute[0]);
        try {
            int newLength = 1000000;
            byte[] bytes1 = new byte[1000000];
            byte[] bytes2 = new byte[1000000];
            Arrays.fill(bytes1, (byte)1);
            Arrays.fill(bytes2, (byte)2);
            Files.write(bigFile1, bytes1, new OpenOption[0]);
            Files.write(bigFile2, bytes2, new OpenOption[0]);
            try (RandomAccessFile raf1 = RandomAccessFileMode.READ_ONLY.create(bigFile1);
                 RandomAccessFile raf22 = RandomAccessFileMode.READ_ONLY.create(bigFile2);){
                Assertions.assertFalse((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)raf1, (RandomAccessFile)raf22));
                Assertions.assertFalse((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)RandomAccessFiles.reset((RandomAccessFile)raf22), (RandomAccessFile)RandomAccessFiles.reset((RandomAccessFile)raf1)));
                Assertions.assertTrue((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)RandomAccessFiles.reset((RandomAccessFile)raf1), (RandomAccessFile)RandomAccessFiles.reset((RandomAccessFile)raf1)));
            }
            byte[] bytes3 = (byte[])bytes1.clone();
            bytes3[bytes3.length - 1] = 9;
            Files.write(bigFile3, bytes3, new OpenOption[0]);
            try (RandomAccessFile raf1 = RandomAccessFileMode.READ_ONLY.create(bigFile1);
                 RandomAccessFile raf3 = RandomAccessFileMode.READ_ONLY.create(bigFile3);){
                Assertions.assertFalse((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)raf1, (RandomAccessFile)raf3));
                Assertions.assertFalse((boolean)RandomAccessFiles.contentEquals((RandomAccessFile)RandomAccessFiles.reset((RandomAccessFile)raf3), (RandomAccessFile)RandomAccessFiles.reset((RandomAccessFile)raf1)));
            }
        }
        finally {
            Files.deleteIfExists(bigFile1);
            Files.deleteIfExists(bigFile2);
            Files.deleteIfExists(bigFile3);
        }
    }

    @Test
    public void testRead() throws IOException {
        byte[] buffer;
        try (RandomAccessFile raf = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_20);){
            buffer = RandomAccessFiles.read((RandomAccessFile)raf, (long)0L, (int)0);
            Assertions.assertArrayEquals((byte[])new byte[0], (byte[])buffer);
        }
        raf = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_20);
        try {
            buffer = RandomAccessFiles.read((RandomAccessFile)raf, (long)1L, (int)0);
            Assertions.assertArrayEquals((byte[])new byte[0], (byte[])buffer);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        raf = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_20);
        try {
            buffer = RandomAccessFiles.read((RandomAccessFile)raf, (long)0L, (int)1);
            Assertions.assertArrayEquals((byte[])new byte[]{49}, (byte[])buffer);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        raf = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_20);
        try {
            buffer = RandomAccessFiles.read((RandomAccessFile)raf, (long)1L, (int)1);
            Assertions.assertArrayEquals((byte[])new byte[]{50}, (byte[])buffer);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        raf = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_20);
        try {
            buffer = RandomAccessFiles.read((RandomAccessFile)raf, (long)0L, (int)20);
            Assertions.assertEquals((int)20, (int)buffer.length);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        raf = RandomAccessFileMode.READ_ONLY.create(FILE_NAME_RO_20);
        try {
            Assertions.assertThrows(IOException.class, () -> RandomAccessFiles.read((RandomAccessFile)raf, (long)0L, (int)21));
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }
}

