/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.function.Consumers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileUtilsListFilesTest {
    @TempDir
    public File temporaryFolder;

    private Collection<String> filesToFilenames(Collection<File> files) {
        return files.stream().map(File::getName).collect(Collectors.toList());
    }

    private Collection<String> filesToFilenames(Iterator<File> files) {
        ArrayList<String> fileNames = new ArrayList<String>();
        files.forEachRemaining(f -> fileNames.add(f.getName()));
        return fileNames;
    }

    @BeforeEach
    public void setUp() throws Exception {
        File dir = this.temporaryFolder;
        File file = new File(dir, "dummy-build.xml");
        FileUtils.touch((File)file);
        file = new File(dir, "README");
        FileUtils.touch((File)file);
        dir = new File(dir, "subdir1");
        dir.mkdirs();
        file = new File(dir, "dummy-build.xml");
        FileUtils.touch((File)file);
        file = new File(dir, "dummy-readme.txt");
        FileUtils.touch((File)file);
        dir = new File(dir, "subsubdir1");
        dir.mkdirs();
        file = new File(dir, "dummy-file.txt");
        FileUtils.touch((File)file);
        file = new File(dir, "dummy-index.html");
        FileUtils.touch((File)file);
        dir = dir.getParentFile();
        dir = new File(dir, "CVS");
        dir.mkdirs();
        file = new File(dir, "Entries");
        FileUtils.touch((File)file);
        file = new File(dir, "Repository");
        FileUtils.touch((File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIterateFilesByExtension() {
        Collection<String> fileNames;
        String[] extensions = new String[]{"xml", "txt"};
        Iterator files = FileUtils.iterateFiles((File)this.temporaryFolder, (String[])extensions, (boolean)false);
        try {
            fileNames = this.filesToFilenames(files);
            Assertions.assertEquals((int)1, (int)fileNames.size());
            Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"));
            Assertions.assertFalse((boolean)fileNames.contains("README"));
            Assertions.assertFalse((boolean)fileNames.contains("dummy-file.txt"));
        }
        finally {
            files.forEachRemaining(Consumers.nop());
        }
        try {
            files = FileUtils.iterateFiles((File)this.temporaryFolder, (String[])extensions, (boolean)true);
            fileNames = this.filesToFilenames(files);
            Assertions.assertEquals((int)4, (int)fileNames.size());
            Assertions.assertTrue((boolean)fileNames.contains("dummy-file.txt"));
            Assertions.assertFalse((boolean)fileNames.contains("dummy-index.html"));
        }
        finally {
            files.forEachRemaining(Consumers.nop());
        }
        files = FileUtils.iterateFiles((File)this.temporaryFolder, null, (boolean)false);
        try {
            fileNames = this.filesToFilenames(files);
            Assertions.assertEquals((int)2, (int)fileNames.size());
            Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"));
            Assertions.assertTrue((boolean)fileNames.contains("README"));
            Assertions.assertFalse((boolean)fileNames.contains("dummy-file.txt"));
        }
        finally {
            files.forEachRemaining(Consumers.nop());
        }
    }

    @Test
    public void testListFiles() {
        IOFileFilter fileFilter = FileFilterUtils.trueFileFilter();
        Collection files = FileUtils.listFiles((File)this.temporaryFolder, (IOFileFilter)fileFilter, null);
        Collection<String> fileNames = this.filesToFilenames(files);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"), (String)"'dummy-build.xml' is missing");
        Assertions.assertFalse((boolean)fileNames.contains("dummy-index.html"), (String)"'dummy-index.html' shouldn't be found");
        Assertions.assertFalse((boolean)fileNames.contains("Entries"), (String)"'Entries' shouldn't be found");
        fileFilter = FileFilterUtils.trueFileFilter();
        IOFileFilter dirFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"CVS"));
        files = FileUtils.listFiles((File)this.temporaryFolder, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        fileNames = this.filesToFilenames(files);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"), (String)"'dummy-build.xml' is missing");
        Assertions.assertTrue((boolean)fileNames.contains("dummy-index.html"), (String)"'dummy-index.html' is missing");
        Assertions.assertFalse((boolean)fileNames.contains("Entries"), (String)"'Entries' shouldn't be found");
        fileFilter = FileFilterUtils.trueFileFilter();
        dirFilter = FileFilterUtils.makeCVSAware(null);
        files = FileUtils.listFiles((File)this.temporaryFolder, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        fileNames = this.filesToFilenames(files);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"), (String)"'dummy-build.xml' is missing");
        Assertions.assertTrue((boolean)fileNames.contains("dummy-index.html"), (String)"'dummy-index.html' is missing");
        Assertions.assertFalse((boolean)fileNames.contains("Entries"), (String)"'Entries' shouldn't be found");
        fileFilter = FileFilterUtils.trueFileFilter();
        dirFilter = FileFilterUtils.prefixFileFilter((String)"sub");
        dirFilter = FileFilterUtils.makeCVSAware((IOFileFilter)dirFilter);
        files = FileUtils.listFiles((File)this.temporaryFolder, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        fileNames = this.filesToFilenames(files);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"), (String)"'dummy-build.xml' is missing");
        Assertions.assertTrue((boolean)fileNames.contains("dummy-index.html"), (String)"'dummy-index.html' is missing");
        Assertions.assertFalse((boolean)fileNames.contains("Entries"), (String)"'Entries' shouldn't be found");
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.listFiles((File)this.temporaryFolder, null, null));
    }

    @Test
    public void testListFilesByExtension() {
        String[] extensions = new String[]{"xml", "txt"};
        Collection files = FileUtils.listFiles((File)this.temporaryFolder, (String[])extensions, (boolean)false);
        Assertions.assertEquals((int)1, (int)files.size());
        Collection<String> fileNames = this.filesToFilenames(files);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"));
        Assertions.assertFalse((boolean)fileNames.contains("README"));
        Assertions.assertFalse((boolean)fileNames.contains("dummy-file.txt"));
        files = FileUtils.listFiles((File)this.temporaryFolder, (String[])extensions, (boolean)true);
        fileNames = this.filesToFilenames(files);
        Assertions.assertEquals((int)4, (int)fileNames.size());
        Assertions.assertTrue((boolean)fileNames.contains("dummy-file.txt"));
        Assertions.assertFalse((boolean)fileNames.contains("dummy-index.html"));
        files = FileUtils.listFiles((File)this.temporaryFolder, null, (boolean)false);
        Assertions.assertEquals((int)2, (int)files.size());
        fileNames = this.filesToFilenames(files);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"));
        Assertions.assertTrue((boolean)fileNames.contains("README"));
        Assertions.assertFalse((boolean)fileNames.contains("dummy-file.txt"));
    }
}

