package org.openqa.selenium.devtools.v140.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Style information for drawing a line.
 */
public class LineStyle {

    public enum Pattern {

        DASHED("dashed"), DOTTED("dotted");

        private String value;

        Pattern(String value) {
            this.value = value;
        }

        public static Pattern fromString(String s) {
            return java.util.Arrays.stream(Pattern.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Pattern "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Pattern fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final java.util.Optional<org.openqa.selenium.devtools.v140.dom.model.RGBA> color;

    private final java.util.Optional<Pattern> pattern;

    public LineStyle(java.util.Optional<org.openqa.selenium.devtools.v140.dom.model.RGBA> color, java.util.Optional<Pattern> pattern) {
        this.color = color;
        this.pattern = pattern;
    }

    /**
     * The color of the line (default: transparent)
     */
    public java.util.Optional<org.openqa.selenium.devtools.v140.dom.model.RGBA> getColor() {
        return color;
    }

    /**
     * The line pattern (default: solid)
     */
    public java.util.Optional<Pattern> getPattern() {
        return pattern;
    }

    private static LineStyle fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v140.dom.model.RGBA> color = java.util.Optional.empty();
        java.util.Optional<Pattern> pattern = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "color":
                    color = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v140.dom.model.RGBA.class));
                    break;
                case "pattern":
                    pattern = java.util.Optional.ofNullable(Pattern.fromString(input.nextString()));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new LineStyle(color, pattern);
    }
}
