/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.module;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.permissions.PermissionState;
import org.openqa.selenium.internal.Require;

public class Permission {
    private final BiDi bidi;

    public Permission(WebDriver driver) {
        Require.nonNull("WebDriver", driver);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)((Object)driver)).getBiDi();
    }

    public void setPermission(Map<String, String> permissionDescriptor, PermissionState state, String origin) {
        this.setPermission(permissionDescriptor, state, origin, null);
    }

    public void setPermission(Map<String, String> permissionDescriptor, PermissionState state, String origin, String userContext) {
        Require.nonNull("Permission descriptor", permissionDescriptor);
        Require.nonNull("Permission state", state);
        Require.nonNull("Origin", origin);
        HashMap<String, Object> params = new HashMap<String, Object>(Map.of("descriptor", permissionDescriptor, "state", state.toString(), "origin", origin));
        if (userContext != null) {
            params.put("userContext", userContext);
        }
        this.bidi.send(new Command("permissions.setPermission", params));
    }
}

