/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.IgnoredChars;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeDirectivesBuilder;
import graphql.language.NodeVisitor;
import graphql.language.SelectionSet;
import graphql.language.SelectionSetContainer;
import graphql.language.SourceLocation;
import graphql.language.TypeName;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

@PublicApi
public class FragmentDefinition
extends AbstractNode<FragmentDefinition>
implements Definition<FragmentDefinition>,
SelectionSetContainer<FragmentDefinition>,
DirectivesContainer<FragmentDefinition>,
NamedNode<FragmentDefinition> {
    private final String name;
    private final TypeName typeCondition;
    private final ImmutableList<Directive> directives;
    private final SelectionSet selectionSet;
    public static final String CHILD_TYPE_CONDITION = "typeCondition";
    public static final String CHILD_DIRECTIVES = "directives";
    public static final String CHILD_SELECTION_SET = "selectionSet";

    @Internal
    protected FragmentDefinition(String name, TypeName typeCondition, List<Directive> directives, SelectionSet selectionSet, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(sourceLocation, comments, ignoredChars, additionalData);
        this.name = name;
        this.typeCondition = typeCondition;
        this.directives = ImmutableList.copyOf(directives);
        this.selectionSet = selectionSet;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TypeName getTypeCondition() {
        return this.typeCondition;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.directives;
    }

    @Override
    public SelectionSet getSelectionSet() {
        return this.selectionSet;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(this.typeCondition);
        result.addAll(this.directives);
        result.add(this.selectionSet);
        return result;
    }

    @Override
    public NodeChildrenContainer getNamedChildren() {
        return NodeChildrenContainer.newNodeChildrenContainer().child(CHILD_TYPE_CONDITION, this.typeCondition).children(CHILD_DIRECTIVES, this.directives).child(CHILD_SELECTION_SET, this.selectionSet).build();
    }

    @Override
    public FragmentDefinition withNewChildren(NodeChildrenContainer newChildren) {
        return this.transform(builder -> ((Builder)builder.typeCondition((TypeName)newChildren.getChildOrNull(CHILD_TYPE_CONDITION)).directives(newChildren.getChildren(CHILD_DIRECTIVES))).selectionSet((SelectionSet)newChildren.getChildOrNull(CHILD_SELECTION_SET)));
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentDefinition that = (FragmentDefinition)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public FragmentDefinition deepCopy() {
        return new FragmentDefinition(this.name, this.deepCopy(this.typeCondition), this.deepCopy(this.directives), this.deepCopy(this.selectionSet), this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    public String toString() {
        return "FragmentDefinition{name='" + this.name + "', typeCondition='" + String.valueOf(this.typeCondition) + "', directives=" + String.valueOf(this.directives) + ", selectionSet=" + String.valueOf(this.selectionSet) + "}";
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor nodeVisitor) {
        return nodeVisitor.visitFragmentDefinition(this, context);
    }

    public static Builder newFragmentDefinition() {
        return new Builder();
    }

    public FragmentDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeDirectivesBuilder {
        private SourceLocation sourceLocation;
        private ImmutableList<Comment> comments = ImmutableKit.emptyList();
        private String name;
        private TypeName typeCondition;
        private ImmutableList<Directive> directives = ImmutableKit.emptyList();
        private SelectionSet selectionSet;
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(FragmentDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = ImmutableList.copyOf(existing.getComments());
            this.name = existing.getName();
            this.typeCondition = existing.getTypeCondition();
            this.directives = ImmutableList.copyOf(existing.getDirectives());
            this.selectionSet = existing.getSelectionSet();
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = ImmutableList.copyOf(comments);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder typeCondition(TypeName typeCondition) {
            this.typeCondition = typeCondition;
            return this;
        }

        @Override
        public Builder directives(List<Directive> directives) {
            this.directives = ImmutableList.copyOf(directives);
            return this;
        }

        @Override
        public Builder directive(Directive directive) {
            this.directives = ImmutableKit.addToList(this.directives, directive, new Directive[0]);
            return this;
        }

        public Builder selectionSet(SelectionSet selectionSet) {
            this.selectionSet = selectionSet;
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public FragmentDefinition build() {
            return new FragmentDefinition(this.name, this.typeCondition, this.directives, this.selectionSet, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

