/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;

public interface HasDownloads {
    default public void requireDownloadsEnabled(Capabilities capabilities) {
        if (!HasDownloads.isDownloadsEnabled(capabilities)) {
            throw new WebDriverException("You must enable downloads in order to work with downloadable files.");
        }
    }

    public boolean isDownloadsEnabled();

    public static boolean isDownloadsEnabled(Capabilities capabilities) {
        return capabilities.is("se:downloadsEnabled");
    }

    public List<String> getDownloadableFiles();

    public void downloadFile(String var1, Path var2) throws IOException;

    public void deleteDownloadableFiles();
}

