package org.openqa.selenium.devtools.v140.browser.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum PermissionType {

    AR("ar"),
    AUDIOCAPTURE("audioCapture"),
    AUTOMATICFULLSCREEN("automaticFullscreen"),
    BACKGROUNDFETCH("backgroundFetch"),
    BACKGROUNDSYNC("backgroundSync"),
    CAMERAPANTILTZOOM("cameraPanTiltZoom"),
    CAPTUREDSURFACECONTROL("capturedSurfaceControl"),
    CLIPBOARDREADWRITE("clipboardReadWrite"),
    CLIPBOARDSANITIZEDWRITE("clipboardSanitizedWrite"),
    DISPLAYCAPTURE("displayCapture"),
    DURABLESTORAGE("durableStorage"),
    GEOLOCATION("geolocation"),
    HANDTRACKING("handTracking"),
    IDLEDETECTION("idleDetection"),
    KEYBOARDLOCK("keyboardLock"),
    LOCALFONTS("localFonts"),
    LOCALNETWORKACCESS("localNetworkAccess"),
    MIDI("midi"),
    MIDISYSEX("midiSysex"),
    NFC("nfc"),
    NOTIFICATIONS("notifications"),
    PAYMENTHANDLER("paymentHandler"),
    PERIODICBACKGROUNDSYNC("periodicBackgroundSync"),
    POINTERLOCK("pointerLock"),
    PROTECTEDMEDIAIDENTIFIER("protectedMediaIdentifier"),
    SENSORS("sensors"),
    SMARTCARD("smartCard"),
    SPEAKERSELECTION("speakerSelection"),
    STORAGEACCESS("storageAccess"),
    TOPLEVELSTORAGEACCESS("topLevelStorageAccess"),
    VIDEOCAPTURE("videoCapture"),
    VR("vr"),
    WAKELOCKSCREEN("wakeLockScreen"),
    WAKELOCKSYSTEM("wakeLockSystem"),
    WEBAPPINSTALLATION("webAppInstallation"),
    WEBPRINTING("webPrinting"),
    WINDOWMANAGEMENT("windowManagement");

    private String value;

    PermissionType(String value) {
        this.value = value;
    }

    public static PermissionType fromString(String s) {
        return java.util.Arrays.stream(PermissionType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PermissionType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PermissionType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
