/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import java.util.Map;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class ForwardWebDriverCommand
implements HttpHandler {
    private final Node node;

    ForwardWebDriverCommand(Node node) {
        this.node = Require.nonNull("Node", node);
    }

    public boolean matches(HttpRequest req) {
        return HttpSessionId.getSessionId(req.getUri()).map(id -> this.node.isSessionOwner(new SessionId((String)id))).orElse(false);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        if (this.matches(req)) {
            return this.node.executeWebDriverCommand(req);
        }
        return (HttpResponse)new HttpResponse().setStatus(404).setContent(Contents.asJson(Map.of("value", Map.of("error", "invalid session id", "message", "Cannot find session with id: " + (String)HttpSessionId.getSessionId(req.getUri()).orElse(null), "stacktrace", ""))));
    }
}

