/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.v1_41;

import java.time.Duration;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.v1_41.DockerMessages;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

class StopContainer {
    private final HttpHandler client;

    public StopContainer(HttpHandler client) {
        this.client = Require.nonNull("HTTP client", client);
    }

    public void apply(ContainerId id, Duration timeout) {
        Require.nonNull("Container id", id);
        Require.nonNull("Timeout", timeout);
        String seconds = String.valueOf(timeout.toMillis() / 1000L);
        String requestUrl = String.format("/v%s/containers/%s/stop", "1.41", id);
        HttpRequest request = ((HttpRequest)new HttpRequest(HttpMethod.POST, requestUrl).addHeader("Content-Type", "text/plain")).addQueryParameter("t", seconds);
        DockerMessages.throwIfNecessary(this.client.execute(request), "Unable to stop container: %s", id);
    }
}

