/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLSchema;
import graphql.util.StringKit;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

@Internal
public class KnownOperationTypes
extends AbstractRule {
    public KnownOperationTypes(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkOperationDefinition(OperationDefinition operationDefinition) {
        OperationDefinition.Operation documentOperation = operationDefinition.getOperation();
        GraphQLSchema graphQLSchema = this.getValidationContext().getSchema();
        if (documentOperation == OperationDefinition.Operation.MUTATION && graphQLSchema.getMutationType() == null) {
            String message = this.i18n(ValidationErrorType.UnknownOperation, "KnownOperationTypes.noOperation", this.formatOperation(documentOperation));
            this.addError(ValidationErrorType.UnknownOperation, operationDefinition.getSourceLocation(), message);
        } else if (documentOperation == OperationDefinition.Operation.SUBSCRIPTION && graphQLSchema.getSubscriptionType() == null) {
            String message = this.i18n(ValidationErrorType.UnknownOperation, "KnownOperationTypes.noOperation", this.formatOperation(documentOperation));
            this.addError(ValidationErrorType.UnknownOperation, operationDefinition.getSourceLocation(), message);
        } else if (documentOperation == OperationDefinition.Operation.QUERY && graphQLSchema.getQueryType() == null) {
            String message = this.i18n(ValidationErrorType.UnknownOperation, "KnownOperationTypes.noOperation", this.formatOperation(documentOperation));
            this.addError(ValidationErrorType.UnknownOperation, operationDefinition.getSourceLocation(), message);
        }
    }

    private String formatOperation(OperationDefinition.Operation operation) {
        return StringKit.capitalize(operation.name().toLowerCase());
    }
}

