/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.TypeResolver;
import graphql.schema.idl.EnumValuesProvider;
import graphql.schema.idl.MockedWiringFactory;
import graphql.schema.idl.NoopWiringFactory;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.TypeRuntimeWiring;
import graphql.schema.idl.WiringFactory;
import graphql.schema.idl.errors.StrictModeWiringException;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class RuntimeWiring {
    private final Map<String, Map<String, DataFetcher>> dataFetchers;
    private final Map<String, DataFetcher> defaultDataFetchers;
    private final Map<String, GraphQLScalarType> scalars;
    private final Map<String, TypeResolver> typeResolvers;
    private final Map<String, SchemaDirectiveWiring> registeredDirectiveWiring;
    private final List<SchemaDirectiveWiring> directiveWiring;
    private final WiringFactory wiringFactory;
    private final Map<String, EnumValuesProvider> enumValuesProviders;
    private final GraphqlFieldVisibility fieldVisibility;
    private final GraphQLCodeRegistry codeRegistry;
    private final GraphqlTypeComparatorRegistry comparatorRegistry;
    public static final RuntimeWiring MOCKED_WIRING = RuntimeWiring.newRuntimeWiring().wiringFactory(new MockedWiringFactory()).build();

    private RuntimeWiring(Builder builder) {
        this.dataFetchers = builder.dataFetchers;
        this.defaultDataFetchers = builder.defaultDataFetchers;
        this.scalars = builder.scalars;
        this.typeResolvers = builder.typeResolvers;
        this.registeredDirectiveWiring = builder.registeredDirectiveWiring;
        this.directiveWiring = builder.directiveWiring;
        this.wiringFactory = builder.wiringFactory;
        this.enumValuesProviders = builder.enumValuesProviders;
        this.fieldVisibility = builder.fieldVisibility;
        this.codeRegistry = builder.codeRegistry;
        this.comparatorRegistry = builder.comparatorRegistry;
    }

    public static Builder newRuntimeWiring() {
        return new Builder();
    }

    public static Builder newRuntimeWiring(RuntimeWiring originalRuntimeWiring) {
        Builder builder = new Builder();
        builder.dataFetchers.putAll(originalRuntimeWiring.dataFetchers);
        builder.defaultDataFetchers.putAll(originalRuntimeWiring.defaultDataFetchers);
        builder.scalars.putAll(originalRuntimeWiring.scalars);
        builder.typeResolvers.putAll(originalRuntimeWiring.typeResolvers);
        builder.registeredDirectiveWiring.putAll(originalRuntimeWiring.registeredDirectiveWiring);
        builder.directiveWiring.addAll(originalRuntimeWiring.directiveWiring);
        builder.wiringFactory = originalRuntimeWiring.wiringFactory;
        builder.enumValuesProviders.putAll(originalRuntimeWiring.enumValuesProviders);
        builder.fieldVisibility = originalRuntimeWiring.fieldVisibility;
        builder.codeRegistry = originalRuntimeWiring.codeRegistry;
        builder.comparatorRegistry = originalRuntimeWiring.comparatorRegistry;
        return builder;
    }

    public RuntimeWiring transform(Consumer<Builder> builderConsumer) {
        Builder builder = RuntimeWiring.newRuntimeWiring(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public GraphQLCodeRegistry getCodeRegistry() {
        return this.codeRegistry;
    }

    public Map<String, GraphQLScalarType> getScalars() {
        return new LinkedHashMap<String, GraphQLScalarType>(this.scalars);
    }

    public Map<String, Map<String, DataFetcher>> getDataFetchers() {
        return this.dataFetchers;
    }

    @Deprecated(since="2024-04-28")
    public Map<String, DataFetcher> getDataFetcherForType(String typeName) {
        return this.dataFetchers.computeIfAbsent(typeName, k -> new LinkedHashMap());
    }

    public Map<String, DataFetcher> getDataFetchersForType(String typeName) {
        return this.dataFetchers.computeIfAbsent(typeName, k -> new LinkedHashMap());
    }

    public DataFetcher getDefaultDataFetcherForType(String typeName) {
        return this.defaultDataFetchers.get(typeName);
    }

    public Map<String, TypeResolver> getTypeResolvers() {
        return this.typeResolvers;
    }

    public Map<String, EnumValuesProvider> getEnumValuesProviders() {
        return this.enumValuesProviders;
    }

    public WiringFactory getWiringFactory() {
        return this.wiringFactory;
    }

    public GraphqlFieldVisibility getFieldVisibility() {
        return this.fieldVisibility;
    }

    public Map<String, SchemaDirectiveWiring> getRegisteredDirectiveWiring() {
        return this.registeredDirectiveWiring;
    }

    public List<SchemaDirectiveWiring> getDirectiveWiring() {
        return this.directiveWiring;
    }

    public GraphqlTypeComparatorRegistry getComparatorRegistry() {
        return this.comparatorRegistry;
    }

    @PublicApi
    public static class Builder {
        private final Map<String, Map<String, DataFetcher>> dataFetchers = new LinkedHashMap<String, Map<String, DataFetcher>>();
        private final Map<String, DataFetcher> defaultDataFetchers = new LinkedHashMap<String, DataFetcher>();
        private final Map<String, GraphQLScalarType> scalars = new LinkedHashMap<String, GraphQLScalarType>();
        private final Map<String, TypeResolver> typeResolvers = new LinkedHashMap<String, TypeResolver>();
        private final Map<String, EnumValuesProvider> enumValuesProviders = new LinkedHashMap<String, EnumValuesProvider>();
        private final Map<String, SchemaDirectiveWiring> registeredDirectiveWiring = new LinkedHashMap<String, SchemaDirectiveWiring>();
        private final List<SchemaDirectiveWiring> directiveWiring = new ArrayList<SchemaDirectiveWiring>();
        private WiringFactory wiringFactory = new NoopWiringFactory();
        private boolean strictMode = true;
        private GraphqlFieldVisibility fieldVisibility = DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
        private GraphQLCodeRegistry codeRegistry = GraphQLCodeRegistry.newCodeRegistry().build();
        private GraphqlTypeComparatorRegistry comparatorRegistry = GraphqlTypeComparatorRegistry.AS_IS_REGISTRY;

        private Builder() {
            ScalarInfo.GRAPHQL_SPECIFICATION_SCALARS.forEach(this::scalar);
        }

        public Builder strictMode(boolean strictMode) {
            this.strictMode = strictMode;
            return this;
        }

        @Deprecated(since="2025-03-22", forRemoval=true)
        public Builder strictMode() {
            this.strictMode = true;
            return this;
        }

        public Builder wiringFactory(WiringFactory wiringFactory) {
            Assert.assertNotNull(wiringFactory, () -> "You must provide a wiring factory");
            this.wiringFactory = wiringFactory;
            return this;
        }

        public Builder codeRegistry(GraphQLCodeRegistry codeRegistry) {
            this.codeRegistry = Assert.assertNotNull(codeRegistry);
            return this;
        }

        public Builder codeRegistry(GraphQLCodeRegistry.Builder codeRegistry) {
            this.codeRegistry = Assert.assertNotNull(codeRegistry).build();
            return this;
        }

        public Builder scalar(GraphQLScalarType scalarType) {
            if (this.strictMode && this.scalars.containsKey(scalarType.getName())) {
                throw new StrictModeWiringException(String.format("The scalar %s is already defined", scalarType.getName()));
            }
            this.scalars.put(scalarType.getName(), scalarType);
            return this;
        }

        public Builder fieldVisibility(GraphqlFieldVisibility fieldVisibility) {
            this.fieldVisibility = Assert.assertNotNull(fieldVisibility);
            return this;
        }

        public Builder type(TypeRuntimeWiring.Builder builder) {
            return this.type(builder.build());
        }

        public Builder type(String typeName, UnaryOperator<TypeRuntimeWiring.Builder> builderFunction) {
            TypeRuntimeWiring.Builder builder = (TypeRuntimeWiring.Builder)builderFunction.apply(TypeRuntimeWiring.newTypeWiring(typeName));
            return this.type(builder.build());
        }

        public Builder type(TypeRuntimeWiring typeRuntimeWiring) {
            EnumValuesProvider enumValuesProvider;
            TypeResolver typeResolver;
            String typeName = typeRuntimeWiring.getTypeName();
            Map typeDataFetchers = this.dataFetchers.computeIfAbsent(typeName, k -> new LinkedHashMap());
            Map<String, DataFetcher> additionalFieldDataFetchers = typeRuntimeWiring.getFieldDataFetchers();
            if (this.strictMode && !typeDataFetchers.isEmpty()) {
                for (String fieldName : additionalFieldDataFetchers.keySet()) {
                    if (!typeDataFetchers.containsKey(fieldName)) continue;
                    throw new StrictModeWiringException(String.format("The field %s on type %s has already been defined", fieldName, typeName));
                }
            }
            typeDataFetchers.putAll(additionalFieldDataFetchers);
            DataFetcher defaultDataFetcher = typeRuntimeWiring.getDefaultDataFetcher();
            if (defaultDataFetcher != null) {
                if (this.strictMode && this.defaultDataFetchers.containsKey(typeName)) {
                    throw new StrictModeWiringException(String.format("The type %s already has a default data fetcher defined", typeName));
                }
                this.defaultDataFetchers.put(typeName, defaultDataFetcher);
            }
            if ((typeResolver = typeRuntimeWiring.getTypeResolver()) != null) {
                if (this.strictMode && this.typeResolvers.containsKey(typeName)) {
                    throw new StrictModeWiringException(String.format("The type %s already has a type resolver defined", typeName));
                }
                this.typeResolvers.put(typeName, typeResolver);
            }
            if ((enumValuesProvider = typeRuntimeWiring.getEnumValuesProvider()) != null) {
                if (this.strictMode && this.enumValuesProviders.containsKey(typeName)) {
                    throw new StrictModeWiringException(String.format("The type %s already has a enum provider defined", typeName));
                }
                this.enumValuesProviders.put(typeName, enumValuesProvider);
            }
            return this;
        }

        public Builder directive(String directiveName, SchemaDirectiveWiring schemaDirectiveWiring) {
            this.registeredDirectiveWiring.put(directiveName, schemaDirectiveWiring);
            return this;
        }

        public Builder directiveWiring(SchemaDirectiveWiring schemaDirectiveWiring) {
            this.directiveWiring.add(schemaDirectiveWiring);
            return this;
        }

        public Builder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
            this.comparatorRegistry = comparatorRegistry;
            return this;
        }

        public RuntimeWiring build() {
            return new RuntimeWiring(this);
        }
    }
}

