/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.OneOfNullValueException;
import graphql.execution.OneOfTooManyKeysException;
import graphql.execution.ValuesResolverConversion;
import graphql.i18n.I18n;
import graphql.language.ArrayValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Value;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
final class ValuesResolverOneOfValidation {
    ValuesResolverOneOfValidation() {
    }

    static void validateOneOfInputTypes(GraphQLType type, Object inputValue, Value<?> argumentValue, String argumentName, Locale locale) {
        GraphQLType unwrappedNonNullType = GraphQLTypeUtil.unwrapNonNull(type);
        if (GraphQLTypeUtil.isList(unwrappedNonNullType) && !ValuesResolverConversion.isNullValue(inputValue) && inputValue instanceof List && argumentValue instanceof ArrayValue) {
            GraphQLType elementType = ((GraphQLList)unwrappedNonNullType).getWrappedType();
            List inputList = (List)inputValue;
            List<Value> argumentList = ((ArrayValue)argumentValue).getValues();
            for (int i = 0; i < argumentList.size(); ++i) {
                ValuesResolverOneOfValidation.validateOneOfInputTypes(elementType, inputList.get(i), argumentList.get(i), argumentName, locale);
            }
        }
        if (unwrappedNonNullType instanceof GraphQLInputObjectType && !ValuesResolverConversion.isNullValue(inputValue)) {
            Assert.assertTrue(inputValue instanceof Map, "The coerced argument %s GraphQLInputObjectType is unexpectedly not a map", argumentName);
            Map objectMap = (Map)inputValue;
            GraphQLInputObjectType inputObjectType = (GraphQLInputObjectType)unwrappedNonNullType;
            if (inputObjectType.isOneOf()) {
                ValuesResolverOneOfValidation.validateOneOfInputTypesInternal(inputObjectType, argumentValue, objectMap, locale);
            }
            for (GraphQLInputObjectField fieldDefinition : inputObjectType.getFields()) {
                GraphQLInputType childFieldType = fieldDefinition.getType();
                String childFieldName = fieldDefinition.getName();
                Object childFieldInputValue = objectMap.get(childFieldName);
                if (argumentValue instanceof ObjectValue) {
                    List values = ((ObjectValue)argumentValue).getObjectFields().stream().filter(of -> of.getName().equals(childFieldName)).map(ObjectField::getValue).collect(Collectors.toList());
                    if (values.size() > 1) {
                        Assert.assertShouldNeverHappen("argument %s has %s object fields with the same name: '%s'. A maximum of 1 is expected", argumentName, values.size(), childFieldName);
                        continue;
                    }
                    if (values.isEmpty()) continue;
                    ValuesResolverOneOfValidation.validateOneOfInputTypes(childFieldType, childFieldInputValue, (Value)values.get(0), argumentName, locale);
                    continue;
                }
                ValuesResolverOneOfValidation.validateOneOfInputTypes(childFieldType, childFieldInputValue, argumentValue, argumentName, locale);
            }
        }
    }

    private static void validateOneOfInputTypesInternal(GraphQLInputObjectType oneOfInputType, Value<?> argumentValue, Map<String, Object> objectMap, Locale locale) {
        String fieldName;
        if (argumentValue instanceof ObjectValue) {
            List<ObjectField> objectFields = ((ObjectValue)argumentValue).getObjectFields();
            if (objectFields.size() != 1) {
                ValuesResolverOneOfValidation.throwNotOneFieldError(oneOfInputType, locale);
            }
            fieldName = objectFields.iterator().next().getName();
        } else {
            if (objectMap.size() != 1) {
                ValuesResolverOneOfValidation.throwNotOneFieldError(oneOfInputType, locale);
            }
            fieldName = objectMap.keySet().iterator().next();
        }
        if (objectMap.get(fieldName) == null) {
            ValuesResolverOneOfValidation.throwValueIsNullError(oneOfInputType, locale, fieldName);
        }
    }

    private static void throwValueIsNullError(GraphQLInputObjectType oneOfInputType, Locale locale, String fieldName) {
        String msg = I18n.i18n(I18n.BundleType.Execution, locale).msg("Execution.handleOneOfValueIsNullError", oneOfInputType.getName() + "." + fieldName);
        throw new OneOfNullValueException(msg);
    }

    private static void throwNotOneFieldError(GraphQLInputObjectType oneOfInputType, Locale locale) {
        String msg = I18n.i18n(I18n.BundleType.Execution, locale).msg("Execution.handleOneOfNotOneFieldError", oneOfInputType.getName());
        throw new OneOfTooManyKeysException(msg);
    }
}

