package org.openqa.selenium.devtools.v144.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Specifies which auctions a particular network fetch may be related to, and
 * in what role. Note that it is not ordered with respect to
 * Network.requestWillBeSent (but will happen before loadingFinished
 * loadingFailed).
 */
public class InterestGroupAuctionNetworkRequestCreated {

    private final org.openqa.selenium.devtools.v144.storage.model.InterestGroupAuctionFetchType type;

    private final org.openqa.selenium.devtools.v144.network.model.RequestId requestId;

    private final java.util.List<org.openqa.selenium.devtools.v144.storage.model.InterestGroupAuctionId> auctions;

    public InterestGroupAuctionNetworkRequestCreated(org.openqa.selenium.devtools.v144.storage.model.InterestGroupAuctionFetchType type, org.openqa.selenium.devtools.v144.network.model.RequestId requestId, java.util.List<org.openqa.selenium.devtools.v144.storage.model.InterestGroupAuctionId> auctions) {
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.auctions = java.util.Objects.requireNonNull(auctions, "auctions is required");
    }

    public org.openqa.selenium.devtools.v144.storage.model.InterestGroupAuctionFetchType getType() {
        return type;
    }

    public org.openqa.selenium.devtools.v144.network.model.RequestId getRequestId() {
        return requestId;
    }

    /**
     * This is the set of the auctions using the worklet that issued this
     * request.  In the case of trusted signals, it's possible that only some of
     * them actually care about the keys being queried.
     */
    public java.util.List<org.openqa.selenium.devtools.v144.storage.model.InterestGroupAuctionId> getAuctions() {
        return auctions;
    }

    private static InterestGroupAuctionNetworkRequestCreated fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v144.storage.model.InterestGroupAuctionFetchType type = null;
        org.openqa.selenium.devtools.v144.network.model.RequestId requestId = null;
        java.util.List<org.openqa.selenium.devtools.v144.storage.model.InterestGroupAuctionId> auctions = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v144.storage.model.InterestGroupAuctionFetchType.class);
                    break;
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v144.network.model.RequestId.class);
                    break;
                case "auctions":
                    auctions = input.readArray(org.openqa.selenium.devtools.v144.storage.model.InterestGroupAuctionId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new InterestGroupAuctionNetworkRequestCreated(type, requestId, auctions);
    }
}
