package org.openqa.selenium.devtools.v144.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when a navigation starts. This event is fired for both
 * renderer-initiated and browser-initiated navigations. For renderer-initiated
 * navigations, the event is fired after `frameRequestedNavigation`.
 * Navigation may still be cancelled after the event is issued. Multiple events
 * can be fired for a single navigation, for example, when a same-document
 * navigation becomes a cross-document navigation (such as in the case of a
 * frameset).
 */
@org.openqa.selenium.Beta()
public class FrameStartedNavigating {

    public enum NavigationType {

        RELOAD("reload"),
        RELOADBYPASSINGCACHE("reloadBypassingCache"),
        RESTORE("restore"),
        RESTOREWITHPOST("restoreWithPost"),
        HISTORYSAMEDOCUMENT("historySameDocument"),
        HISTORYDIFFERENTDOCUMENT("historyDifferentDocument"),
        SAMEDOCUMENT("sameDocument"),
        DIFFERENTDOCUMENT("differentDocument");

        private String value;

        NavigationType(String value) {
            this.value = value;
        }

        public static NavigationType fromString(String s) {
            return java.util.Arrays.stream(NavigationType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within NavigationType "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static NavigationType fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final org.openqa.selenium.devtools.v144.page.model.FrameId frameId;

    private final java.lang.String url;

    private final org.openqa.selenium.devtools.v144.network.model.LoaderId loaderId;

    private final NavigationType navigationType;

    public FrameStartedNavigating(org.openqa.selenium.devtools.v144.page.model.FrameId frameId, java.lang.String url, org.openqa.selenium.devtools.v144.network.model.LoaderId loaderId, NavigationType navigationType) {
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.loaderId = java.util.Objects.requireNonNull(loaderId, "loaderId is required");
        this.navigationType = java.util.Objects.requireNonNull(navigationType, "navigationType is required");
    }

    /**
     * ID of the frame that is being navigated.
     */
    public org.openqa.selenium.devtools.v144.page.model.FrameId getFrameId() {
        return frameId;
    }

    /**
     * The URL the navigation started with. The final URL can be different.
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * Loader identifier. Even though it is present in case of same-document
     * navigation, the previously committed loaderId would not change unless
     * the navigation changes from a same-document to a cross-document
     * navigation.
     */
    public org.openqa.selenium.devtools.v144.network.model.LoaderId getLoaderId() {
        return loaderId;
    }

    public NavigationType getNavigationType() {
        return navigationType;
    }

    private static FrameStartedNavigating fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v144.page.model.FrameId frameId = null;
        java.lang.String url = null;
        org.openqa.selenium.devtools.v144.network.model.LoaderId loaderId = null;
        NavigationType navigationType = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v144.page.model.FrameId.class);
                    break;
                case "url":
                    url = input.nextString();
                    break;
                case "loaderId":
                    loaderId = input.read(org.openqa.selenium.devtools.v144.network.model.LoaderId.class);
                    break;
                case "navigationType":
                    navigationType = NavigationType.fromString(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FrameStartedNavigating(frameId, url, loaderId, navigationType);
    }
}
