package org.openqa.selenium.devtools.v142.tethering;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * The Tethering domain defines methods and events for browser port binding.
 */
@Beta()
public class Tethering {

    /**
     * Request browser port binding.
     */
    public static Command<Void> bind(java.lang.Integer port) {
        java.util.Objects.requireNonNull(port, "port is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("port", port);
        return new Command<>("Tethering.bind", Map.copyOf(params));
    }

    /**
     * Request browser port unbinding.
     */
    public static Command<Void> unbind(java.lang.Integer port) {
        java.util.Objects.requireNonNull(port, "port is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("port", port);
        return new Command<>("Tethering.unbind", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v142.tethering.model.Accepted> accepted() {
        return new Event<>("Tethering.accepted", input -> input.read(org.openqa.selenium.devtools.v142.tethering.model.Accepted.class));
    }
}
