package org.openqa.selenium.devtools.v143.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Shared storage was accessed by the associated page.
 * The following parameters are included in all events.
 */
public class SharedStorageAccessed {

    private final org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch accessTime;

    private final org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessScope scope;

    private final org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessMethod method;

    private final org.openqa.selenium.devtools.v143.page.model.FrameId mainFrameId;

    private final java.lang.String ownerOrigin;

    private final java.lang.String ownerSite;

    private final org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessParams params;

    public SharedStorageAccessed(org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch accessTime, org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessScope scope, org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessMethod method, org.openqa.selenium.devtools.v143.page.model.FrameId mainFrameId, java.lang.String ownerOrigin, java.lang.String ownerSite, org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessParams params) {
        this.accessTime = java.util.Objects.requireNonNull(accessTime, "accessTime is required");
        this.scope = java.util.Objects.requireNonNull(scope, "scope is required");
        this.method = java.util.Objects.requireNonNull(method, "method is required");
        this.mainFrameId = java.util.Objects.requireNonNull(mainFrameId, "mainFrameId is required");
        this.ownerOrigin = java.util.Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        this.ownerSite = java.util.Objects.requireNonNull(ownerSite, "ownerSite is required");
        this.params = java.util.Objects.requireNonNull(params, "params is required");
    }

    /**
     * Time of the access.
     */
    public org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch getAccessTime() {
        return accessTime;
    }

    /**
     * Enum value indicating the access scope.
     */
    public org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessScope getScope() {
        return scope;
    }

    /**
     * Enum value indicating the Shared Storage API method invoked.
     */
    public org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessMethod getMethod() {
        return method;
    }

    /**
     * DevTools Frame Token for the primary frame tree's root.
     */
    public org.openqa.selenium.devtools.v143.page.model.FrameId getMainFrameId() {
        return mainFrameId;
    }

    /**
     * Serialization of the origin owning the Shared Storage data.
     */
    public java.lang.String getOwnerOrigin() {
        return ownerOrigin;
    }

    /**
     * Serialization of the site owning the Shared Storage data.
     */
    public java.lang.String getOwnerSite() {
        return ownerSite;
    }

    /**
     * The sub-parameters wrapped by `params` are all optional and their
     * presence/absence depends on `type`.
     */
    public org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessParams getParams() {
        return params;
    }

    private static SharedStorageAccessed fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch accessTime = null;
        org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessScope scope = null;
        org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessMethod method = null;
        org.openqa.selenium.devtools.v143.page.model.FrameId mainFrameId = null;
        java.lang.String ownerOrigin = null;
        java.lang.String ownerSite = null;
        org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessParams params = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "accessTime":
                    accessTime = input.read(org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch.class);
                    break;
                case "scope":
                    scope = input.read(org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessScope.class);
                    break;
                case "method":
                    method = input.read(org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessMethod.class);
                    break;
                case "mainFrameId":
                    mainFrameId = input.read(org.openqa.selenium.devtools.v143.page.model.FrameId.class);
                    break;
                case "ownerOrigin":
                    ownerOrigin = input.nextString();
                    break;
                case "ownerSite":
                    ownerSite = input.nextString();
                    break;
                case "params":
                    params = input.read(org.openqa.selenium.devtools.v143.storage.model.SharedStorageAccessParams.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SharedStorageAccessed(accessTime, scope, method, mainFrameId, ownerOrigin, ownerSite, params);
    }
}
