package org.openqa.selenium.devtools.v143.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class AttributionReportingEventTriggerData {

    private final org.openqa.selenium.devtools.v143.storage.model.UnsignedInt64AsBase10 data;

    private final org.openqa.selenium.devtools.v143.storage.model.SignedInt64AsBase10 priority;

    private final java.util.Optional<org.openqa.selenium.devtools.v143.storage.model.UnsignedInt64AsBase10> dedupKey;

    private final org.openqa.selenium.devtools.v143.storage.model.AttributionReportingFilterPair filters;

    public AttributionReportingEventTriggerData(org.openqa.selenium.devtools.v143.storage.model.UnsignedInt64AsBase10 data, org.openqa.selenium.devtools.v143.storage.model.SignedInt64AsBase10 priority, java.util.Optional<org.openqa.selenium.devtools.v143.storage.model.UnsignedInt64AsBase10> dedupKey, org.openqa.selenium.devtools.v143.storage.model.AttributionReportingFilterPair filters) {
        this.data = java.util.Objects.requireNonNull(data, "data is required");
        this.priority = java.util.Objects.requireNonNull(priority, "priority is required");
        this.dedupKey = dedupKey;
        this.filters = java.util.Objects.requireNonNull(filters, "filters is required");
    }

    public org.openqa.selenium.devtools.v143.storage.model.UnsignedInt64AsBase10 getData() {
        return data;
    }

    public org.openqa.selenium.devtools.v143.storage.model.SignedInt64AsBase10 getPriority() {
        return priority;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v143.storage.model.UnsignedInt64AsBase10> getDedupKey() {
        return dedupKey;
    }

    public org.openqa.selenium.devtools.v143.storage.model.AttributionReportingFilterPair getFilters() {
        return filters;
    }

    private static AttributionReportingEventTriggerData fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v143.storage.model.UnsignedInt64AsBase10 data = null;
        org.openqa.selenium.devtools.v143.storage.model.SignedInt64AsBase10 priority = null;
        java.util.Optional<org.openqa.selenium.devtools.v143.storage.model.UnsignedInt64AsBase10> dedupKey = java.util.Optional.empty();
        org.openqa.selenium.devtools.v143.storage.model.AttributionReportingFilterPair filters = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "data":
                    data = input.read(org.openqa.selenium.devtools.v143.storage.model.UnsignedInt64AsBase10.class);
                    break;
                case "priority":
                    priority = input.read(org.openqa.selenium.devtools.v143.storage.model.SignedInt64AsBase10.class);
                    break;
                case "dedupKey":
                    dedupKey = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.storage.model.UnsignedInt64AsBase10.class));
                    break;
                case "filters":
                    filters = input.read(org.openqa.selenium.devtools.v143.storage.model.AttributionReportingFilterPair.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AttributionReportingEventTriggerData(data, priority, dedupKey, filters);
    }
}
