package org.openqa.selenium.devtools.v143.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when additional information about a requestWillBeSent event is available from the
 * network stack. Not every requestWillBeSent event will have an additional
 * requestWillBeSentExtraInfo fired for it, and there is no guarantee whether requestWillBeSent
 * or requestWillBeSentExtraInfo will be fired first for the same request.
 */
@org.openqa.selenium.Beta()
public class RequestWillBeSentExtraInfo {

    private final org.openqa.selenium.devtools.v143.network.model.RequestId requestId;

    private final java.util.List<org.openqa.selenium.devtools.v143.network.model.AssociatedCookie> associatedCookies;

    private final org.openqa.selenium.devtools.v143.network.model.Headers headers;

    private final org.openqa.selenium.devtools.v143.network.model.ConnectTiming connectTiming;

    private final java.util.Optional<org.openqa.selenium.devtools.v143.network.model.ClientSecurityState> clientSecurityState;

    private final java.util.Optional<java.lang.Boolean> siteHasCookieInOtherPartition;

    private final java.util.Optional<java.lang.String> appliedNetworkConditionsId;

    public RequestWillBeSentExtraInfo(org.openqa.selenium.devtools.v143.network.model.RequestId requestId, java.util.List<org.openqa.selenium.devtools.v143.network.model.AssociatedCookie> associatedCookies, org.openqa.selenium.devtools.v143.network.model.Headers headers, org.openqa.selenium.devtools.v143.network.model.ConnectTiming connectTiming, java.util.Optional<org.openqa.selenium.devtools.v143.network.model.ClientSecurityState> clientSecurityState, java.util.Optional<java.lang.Boolean> siteHasCookieInOtherPartition, java.util.Optional<java.lang.String> appliedNetworkConditionsId) {
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.associatedCookies = java.util.Objects.requireNonNull(associatedCookies, "associatedCookies is required");
        this.headers = java.util.Objects.requireNonNull(headers, "headers is required");
        this.connectTiming = java.util.Objects.requireNonNull(connectTiming, "connectTiming is required");
        this.clientSecurityState = clientSecurityState;
        this.siteHasCookieInOtherPartition = siteHasCookieInOtherPartition;
        this.appliedNetworkConditionsId = appliedNetworkConditionsId;
    }

    /**
     * Request identifier. Used to match this information to an existing requestWillBeSent event.
     */
    public org.openqa.selenium.devtools.v143.network.model.RequestId getRequestId() {
        return requestId;
    }

    /**
     * A list of cookies potentially associated to the requested URL. This includes both cookies sent with
     * the request and the ones not sent; the latter are distinguished by having blockedReasons field set.
     */
    public java.util.List<org.openqa.selenium.devtools.v143.network.model.AssociatedCookie> getAssociatedCookies() {
        return associatedCookies;
    }

    /**
     * Raw request headers as they will be sent over the wire.
     */
    public org.openqa.selenium.devtools.v143.network.model.Headers getHeaders() {
        return headers;
    }

    /**
     * Connection timing information for the request.
     */
    @Beta()
    public org.openqa.selenium.devtools.v143.network.model.ConnectTiming getConnectTiming() {
        return connectTiming;
    }

    /**
     * The client security state set for the request.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v143.network.model.ClientSecurityState> getClientSecurityState() {
        return clientSecurityState;
    }

    /**
     * Whether the site has partitioned cookies stored in a partition different than the current one.
     */
    public java.util.Optional<java.lang.Boolean> getSiteHasCookieInOtherPartition() {
        return siteHasCookieInOtherPartition;
    }

    /**
     * The network conditions id if this request was affected by network conditions configured via
     * emulateNetworkConditionsByRule.
     */
    public java.util.Optional<java.lang.String> getAppliedNetworkConditionsId() {
        return appliedNetworkConditionsId;
    }

    private static RequestWillBeSentExtraInfo fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v143.network.model.RequestId requestId = null;
        java.util.List<org.openqa.selenium.devtools.v143.network.model.AssociatedCookie> associatedCookies = null;
        org.openqa.selenium.devtools.v143.network.model.Headers headers = null;
        org.openqa.selenium.devtools.v143.network.model.ConnectTiming connectTiming = null;
        java.util.Optional<org.openqa.selenium.devtools.v143.network.model.ClientSecurityState> clientSecurityState = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> siteHasCookieInOtherPartition = java.util.Optional.empty();
        java.util.Optional<java.lang.String> appliedNetworkConditionsId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v143.network.model.RequestId.class);
                    break;
                case "associatedCookies":
                    associatedCookies = input.readArray(org.openqa.selenium.devtools.v143.network.model.AssociatedCookie.class);
                    break;
                case "headers":
                    headers = input.read(org.openqa.selenium.devtools.v143.network.model.Headers.class);
                    break;
                case "connectTiming":
                    connectTiming = input.read(org.openqa.selenium.devtools.v143.network.model.ConnectTiming.class);
                    break;
                case "clientSecurityState":
                    clientSecurityState = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.network.model.ClientSecurityState.class));
                    break;
                case "siteHasCookieInOtherPartition":
                    siteHasCookieInOtherPartition = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "appliedNetworkConditionsId":
                    appliedNetworkConditionsId = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new RequestWillBeSentExtraInfo(requestId, associatedCookies, headers, connectTiming, clientSecurityState, siteHasCookieInOtherPartition, appliedNetworkConditionsId);
    }
}
