package org.openqa.selenium.devtools.v143.bluetoothemulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Event for when a characteristic operation of |type| to the characteristic
 * respresented by |characteristicId| happened. |data| and |writeType| is
 * expected to exist when |type| is write.
 */
public class CharacteristicOperationReceived {

    private final java.lang.String characteristicId;

    private final org.openqa.selenium.devtools.v143.bluetoothemulation.model.CharacteristicOperationType type;

    private final java.util.Optional<java.lang.String> data;

    private final java.util.Optional<org.openqa.selenium.devtools.v143.bluetoothemulation.model.CharacteristicWriteType> writeType;

    public CharacteristicOperationReceived(java.lang.String characteristicId, org.openqa.selenium.devtools.v143.bluetoothemulation.model.CharacteristicOperationType type, java.util.Optional<java.lang.String> data, java.util.Optional<org.openqa.selenium.devtools.v143.bluetoothemulation.model.CharacteristicWriteType> writeType) {
        this.characteristicId = java.util.Objects.requireNonNull(characteristicId, "characteristicId is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.data = data;
        this.writeType = writeType;
    }

    public java.lang.String getCharacteristicId() {
        return characteristicId;
    }

    public org.openqa.selenium.devtools.v143.bluetoothemulation.model.CharacteristicOperationType getType() {
        return type;
    }

    public java.util.Optional<java.lang.String> getData() {
        return data;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v143.bluetoothemulation.model.CharacteristicWriteType> getWriteType() {
        return writeType;
    }

    private static CharacteristicOperationReceived fromJson(JsonInput input) {
        java.lang.String characteristicId = null;
        org.openqa.selenium.devtools.v143.bluetoothemulation.model.CharacteristicOperationType type = null;
        java.util.Optional<java.lang.String> data = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v143.bluetoothemulation.model.CharacteristicWriteType> writeType = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "characteristicId":
                    characteristicId = input.nextString();
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v143.bluetoothemulation.model.CharacteristicOperationType.class);
                    break;
                case "data":
                    data = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "writeType":
                    writeType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.bluetoothemulation.model.CharacteristicWriteType.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CharacteristicOperationReceived(characteristicId, type, data, writeType);
    }
}
