/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebDriverBuilder;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.AddHasDebugger;
import org.openqa.selenium.safari.AddHasPermissions;
import org.openqa.selenium.safari.HasDebugger;
import org.openqa.selenium.safari.HasPermissions;
import org.openqa.selenium.safari.SafariDriverService;
import org.openqa.selenium.safari.SafariOptions;
import org.openqa.selenium.safari.SafariTechPreviewDriverService;

public class SafariDriver
extends RemoteWebDriver
implements HasPermissions,
HasDebugger {
    private final HasPermissions permissions = new AddHasPermissions().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final HasDebugger debugger = new AddHasDebugger().getImplementation(this.getCapabilities(), this.getExecuteMethod());

    public SafariDriver() {
        this(new SafariOptions());
    }

    public SafariDriver(SafariOptions safariOptions) {
        this(safariOptions, ClientConfig.defaultConfig());
    }

    public SafariDriver(SafariOptions safariOptions, ClientConfig clientConfig) {
        this(safariOptions.getUseTechnologyPreview() ? SafariTechPreviewDriverService.createDefaultService() : SafariDriverService.createDefaultService(), safariOptions, clientConfig);
    }

    public SafariDriver(SafariDriverService safariService) {
        this(safariService, new SafariOptions());
    }

    public SafariDriver(DriverService service, SafariOptions options) {
        this(service, options, ClientConfig.defaultConfig());
    }

    public SafariDriver(DriverService service, SafariOptions options, ClientConfig clientConfig) {
        super(SafariDriver.generateExecutor(service, options, clientConfig), (Capabilities)options, clientConfig);
    }

    private static SafariDriverCommandExecutor generateExecutor(DriverService service, SafariOptions options, ClientConfig clientConfig) {
        Require.nonNull("Driver service", service);
        Require.nonNull("Driver options", options);
        Require.nonNull("Driver clientConfig", clientConfig);
        DriverFinder finder = new DriverFinder(service, options);
        service.setExecutable(finder.getDriverPath());
        return new SafariDriverCommandExecutor(service, clientConfig);
    }

    @Beta
    public static RemoteWebDriverBuilder builder() {
        return RemoteWebDriver.builder().oneOf(new SafariOptions(), new Capabilities[0]);
    }

    @Override
    public void setPermissions(String permission, boolean value) {
        Require.nonNull("Permission Name", permission);
        Require.nonNull("Permission Value", value);
        this.permissions.setPermissions(permission, value);
    }

    @Override
    public Map<String, Boolean> getPermissions() {
        return this.permissions.getPermissions();
    }

    @Override
    public void attachDebugger() {
        this.debugger.attachDebugger();
    }

    @Override
    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    private static class SafariDriverCommandExecutor
    extends DriverCommandExecutor {
        public SafariDriverCommandExecutor(DriverService service, ClientConfig clientConfig) {
            super(service, SafariDriverCommandExecutor.getExtraCommands(), clientConfig);
        }

        private static Map<String, CommandInfo> getExtraCommands() {
            return Stream.of(new AddHasPermissions().getAdditionalCommands(), new AddHasDebugger().getAdditionalCommands()).flatMap(m4 -> m4.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

