/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class Sets {
    @SafeVarargs
    public static <T> Set<T> sequencedSetOf(T ... values) {
        LinkedHashSet set = new LinkedHashSet();
        Collections.addAll(set, values);
        return Collections.unmodifiableSet(set);
    }

    @SafeVarargs
    public static <T extends Comparable<T>> Set<T> sortedSetOf(T ... values) {
        TreeSet set = new TreeSet();
        Collections.addAll(set, values);
        return Collections.unmodifiableSet(set);
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, Set<T>> toSortedSet() {
        return Collectors.collectingAndThen(Collectors.toCollection(TreeSet::new), Collections::unmodifiableSet);
    }

    public static <T> Collector<T, ?, Set<T>> toSequencedSet() {
        return Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet);
    }

    public static <T extends Comparable<? super T>> Set<T> sortedSet(Set<T> source) {
        return Collections.unmodifiableSet(new TreeSet<T>(source));
    }

    public static <T> boolean haveCommonElements(Set<T> set1, Set<T> set2) {
        return set1.stream().anyMatch(set2::contains);
    }
}

